/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/***********************************************************************
 
 			Copyright (c) 1995 by
 			Kubota Graphics Technology Inc.
 			All Rights Reserved
 	
 	This software comprises unpublished confidential information of
 	Kubota Graphics Technology Inc. and may not be used, copied or
 	made available to anyone, except in accordance with the license
 	under which it is furnished.
 	
 
        module name   :  Vector Arrow
        file name     :  vector.c
        exe           :  Vector
 
        This module creats arrows from 3 component data (U,V,W).
 
***********************************************************************/
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <sys/types.h>

#include <avs/avs.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/flow.h>
#include <avs/geom.h>
#include <avs/colormap.h>

#include "l_vector.h"

extern GEOMobj *create_vector_object();
extern GEOMobj *create_lib_object();
extern GEOMobj *create_cone_object();

AVSinit_modules() 
{
    int vector();

   	AVSmodule_from_desc(vector);
}

/*static int*/
vector() 
{
   	int         param;
   	int         vector_compute();
   	static char *vector_types = "bar|high cone|middle cone|low cone|high lib|middle lib|low lib|mini lib";
   	static char *sections = "3D|x-y|x-z|y-z";

   	AVSset_module_name("Vector Arrow", MODULE_MAPPER);

        /*
         *  create input port
         */
        AVScreate_input_port("Field Input", "field 3-vector real irregular 3-space", REQUIRED);
        AVScreate_input_port("Field Input", "field scalar real irregular 3-space", OPTIONAL);
        AVScreate_input_port("Colormap Input", "colormap", OPTIONAL);

        /*
         *  create output port
         */
        AVScreate_output_port("Geometry Output", "geom");

        /*
         *  addtion parameter
         */
        param = AVSadd_float_parameter("scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
        param = AVSadd_parameter("vector type", "choice", "bar", vector_types, "|");
        AVSconnect_widget(param, "radio_buttons");
        param = AVSadd_parameter("cross section", "choice", "3D", sections, "|");
        AVSconnect_widget(param, "radio_buttons");
        param = AVSadd_float_parameter("cone min", 0.0,  FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(param, "dial");
        param = AVSadd_float_parameter("cone max", 1.0,  FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget(param, "dial");

        AVSset_compute_proc(vector_compute);
}

/*static int*/
vector_compute(input, value, color_map, output, scale, type, section, min, max)
        AVSfield_float *input;
        AVScolormap    *color_map;
        AVSfield_float *value;
        GEOMedit_list  *output;
        float          *scale;
        char           *type;
        char           *section;
        float          *min, *max;
{
        static char  *function_name = "vector_compute";
        int          ndims, numdiv, total, total_scal;
        float        *vectors, *coords, *works, *cones, *flags;
        ARROW_TYPE   arrow_type;
        SECTION_TYPE section_type;
        GEOMobj      *obj;

        if (!input ||(*scale < ESP && *scale > -ESP) || (type == NULL) || (section == NULL)) return(ERROR_RETURN);

        arrow_type = (ARROW_TYPE)AVSchoice_number("vector type", type);

        /*
         *  initalize data 
         */
        ndims=input->ndim;
        if(ndims == 1) {
         total = input->dimensions[0];
        }
        else if(ndims == 2) {
         total = input->dimensions[0]*input->dimensions[1];
        }
        else if(ndims == 3) {
         total = input->dimensions[0]*input->dimensions[1]*input->dimensions[2];
        }

        /* check input scalar value */
        if(value) {
         if(ndims != value->ndim){
               ERROR_PROCESS("err dimension(scalar value)");
         }
         if(value->ndim == 1){
           total_scal = value->dimensions[0];
         }
         else if(value->ndim == 2){
           total_scal = value->dimensions[0]*value->dimensions[1];
         }
         else if(value->ndim == 3){
           total_scal = value->dimensions[0]*value->dimensions[1]*value->dimensions[2];
         }
         if(total != total_scal){
               ERROR_PROCESS("err dimension(scalar value)");
         }
        }

        vectors = coords = works = cones = flags = NULL;

        if (set_numdiv(arrow_type, &numdiv) == ERROR_RETURN) {
               ERROR_PROCESS("unkown type");
        }

        if (alloc_area(&coords, &flags, &vectors, &works, &cones, total, numdiv) == ERROR_RETURN) {
               ERROR_PROCESS("Can't allocate memory");
        }

        /*
         * set vector data
         */
        section_type = (SECTION_TYPE)AVSchoice_number("cross section", section);

        set_vectors(section_type, vectors, input->data, total, *scale);

        /*
         * set cone create data 
         */
        if (set_cone_data(*input, coords, flags, works, total, numdiv, vectors) == ERROR_RETURN) {
               ERROR_PROCESS("Can't set cone create data");
        }

        if (numdiv > 0) {
                /*
                 *  make cone date
                 */
                cone(vectors, works, total, *min, *max, CONE_RADIUSE, CONE_LENGTH, numdiv, cones, flags);
                FREE(works);
        }

	/*
	 *  initalize output
	 */
	*output = GEOMinit_edit_list(*output);
	
	/*
	 *  create vector obj
	 */
	if ((obj = create_vector_object(coords, vectors, flags, color_map, value, total)) == NULL) {
		ERROR_PROCESS("Can't create vector object");
	}

	/*
	 *  set edit_list for vector
	 */
	GEOMedit_geometry(*output, "vector", obj);
	GEOMdestroy_obj(obj);

	if (numdiv > 0) {
		/*
	 	 *  create vector obj
	 	 */
		if (arrow_type > 4) {
			if ((obj = create_lib_object(coords, vectors, flags, cones, arrow_type,
							      color_map, value, total, numdiv)) == NULL) {
				ERROR_PROCESS("Can't create lib object");
			}
		 } else {
			if ((obj = create_cone_object(coords, vectors, flags, cones, 
							       color_map, value, total, numdiv)) == NULL) {
				ERROR_PROCESS("Can't create cone object");
			}
		}

		/*
	 	 *  set edit_list for cone
	 	 */
		GEOMedit_geometry(*output, "cone", obj);
		GEOMdestroy_obj(obj);
	
	} else {
	    obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
		GEOMedit_geometry(*output, "cone", obj);
		GEOMdestroy_obj(obj);
	}
	
	GEOMedit_parent(*output, "cone", "vector");

	FREE_PROCESS;

	return(NORMAL_RETURN);
}
