/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h>  */
#include <avs/avs_math.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
#include "separate.h"


float XARROWHEADSIZE;   
float YARROWHEADSIZE;

#define DEFAULT_ARROW_SIZE 0.3

#define RADIAN 0.01745329251994329576

double sqrt();
double acos();
double sin();
double cos();
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int WIND_PLOT_desc()
{

	int in_port, out_port, param;
	extern int WIND_PLOT_compute();

	AVSset_module_name("WIND PLOT", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input_field", 
		"field 2D 3-vector uniform float", REQUIRED);

	in_port = AVScreate_input_port("slice axis", "string", REQUIRED);

	in_port = AVScreate_input_port("input_color_map", "colormap",
		OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("geom_output", "geom");

	/* Parameter Specifications */
/*
	param = AVSadd_parameter("Plot Every", "integer", 1, 1, 30);
	AVSconnect_widget(param, "islider");
*/
        param = AVSadd_float_parameter("Wind Max", 15.00000, FLOAT_UNBOUND,
                FLOAT_UNBOUND);

	param = AVSadd_parameter("Draw Arrows", "boolean", 1, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("Fixed Lengths", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(WIND_PLOT_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int WIND_PLOT_compute(input_field, input_slice_axis, input_color_map,
geom_output,
/*
plot_every,
*/
wind_max, draw_arrows, fixed_lengths)
AVSfield_float *input_field;
char *input_slice_axis;
AVScolormap *input_color_map;
GEOMedit_list *geom_output;
/*
int plot_every;
*/
float *wind_max;
int draw_arrows;
int fixed_lengths;
{
GEOMobj *obj;
static float verts[6];
static float colors[6] = {0.0, 0.0, 1.0, 1.0, 0.0, 0.0 };
float x, y, x0, y0, z0, x1, y1, z1, r; 
float xarrow0, yarrow0, xarrow1, yarrow1;
float red, green, blue;
int color_index;
int slice_axis;
register int i, j, k, in;
register int i1, i2;

#define plot_every 1

#define HALFCELLSIZE 0.5
#define MAXLENGTH 0.7

#define INPUT input_field->data[in]

#define XCOORD_MIN ((int) (input_field->points[0]))
#define XCOORD_MAX ((int) (input_field->points[1]))
#define YCOORD_MIN ((int) (input_field->points[2]))
#define YCOORD_MAX ((int) (input_field->points[3]))
#define ZCOORD_MIN ((int) (input_field->points[4]))
#define ZCOORD_MAX ((int) (input_field->points[5]))
 
#define NX ((int) ((XCOORD_MAX - XCOORD_MIN) + 1) )
#define NY ((int) ((YCOORD_MAX - YCOORD_MIN) + 1) )
#define NZ ((int) ((ZCOORD_MAX - ZCOORD_MIN) + 1) )
 
#define SLICE_XAXIS 1
#define SLICE_YAXIS 2
#define SLICE_ZAXIS 3
 
if (!strcmp(input_slice_axis, "X"))
        slice_axis = SLICE_XAXIS;
else if (!strcmp(input_slice_axis, "Y"))
        slice_axis = SLICE_YAXIS;
else if (!strcmp(input_slice_axis, "Z"))
        slice_axis = SLICE_ZAXIS;
else
        {
        AVSerror("Slice axis must be X or Y or Z.");
        return(0);
        }
 
if ((*wind_max == 0.0) && (!fixed_lengths))
	{
	AVSerror("Wind max must not be equal to zero.");
	return(0);
	}

obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
in = 0;
for (k = ZCOORD_MIN; k <= ZCOORD_MAX; ++k)
        {
        for (j = YCOORD_MIN; j <= YCOORD_MAX; ++j)
                {
                for (i = XCOORD_MIN; i <= XCOORD_MAX; ++i)
			{
			x = INPUT;
			++in;
			y = INPUT;
			++in;
			r = INPUT;
			++in;

			if (fixed_lengths)
				XARROWHEADSIZE = YARROWHEADSIZE =
					DEFAULT_ARROW_SIZE;	
			else
				XARROWHEADSIZE = YARROWHEADSIZE =
				((plot_every * r)/(*wind_max)) * MAXLENGTH/2.0;

		
/* For the alpha prototype, there is one more dimension on x and y for
wind data than for concentration data.  Therefore, the cells won't be
centered but are located at the edges.  This logic works only with
plot_every = 1.  Otherwise, the lengths are too long.  More work should
be done on this.
*/
			if ((!(i % plot_every)) && (!(j % plot_every)))
				{
				x0 = i;
				y0 = j;
				z0 = z1 = ((float) k);

				if (fixed_lengths)
					{
					x1 = x0 + MAXLENGTH *
					 	(plot_every * x/(r));
					y1 = y0 + MAXLENGTH *
					 	(plot_every * y/(r));
					}
				else
					{
					x1 = x0 + MAXLENGTH *
					 	(plot_every * x/(*wind_max));
					y1 = y0 + MAXLENGTH *
					 	(plot_every * y/(*wind_max));
					}

				verts[0] = x0;
				verts[1] = y0;
				verts[2] = z0;
				verts[3] = x1;
				verts[4] = y1;
				verts[5] = z1;

				if (input_color_map != NULL)
					{
					color_index = AVScmap_index(input_color_map, r);
					hsv2rgb(input_color_map->hue[color_index] * 360.0,
						input_color_map->saturation[color_index],
						input_color_map->value[color_index],
						&red, &green, &blue);
					colors[0] = colors[3] = red;
					colors[1] = colors[4] = green;
					colors[2] = colors[5] = blue; 
					GEOMadd_disjoint_line(obj, verts, colors, 2,
						GEOM_COPY_DATA);
					}
				else
					GEOMadd_disjoint_line(obj, verts, GEOM_NULL, 2,
						GEOM_COPY_DATA);
				
				if ((draw_arrows) &&
					(slice_axis == SLICE_ZAXIS))
					{
					get_arrow(x0, y0, x1, y1,  
						&xarrow0, &yarrow0, &xarrow1, &yarrow1,
						plot_every);

					verts[0] = x1 + xarrow0;
					verts[1] = y1 + yarrow0;
					verts[3] = x1;
					verts[4] = y1;

					if (input_color_map != NULL)
						GEOMadd_disjoint_line(obj, verts, colors, 2,
							GEOM_COPY_DATA);
					else
						GEOMadd_disjoint_line(obj, verts, GEOM_NULL, 2,
							GEOM_COPY_DATA);

					verts[0] = x1 + xarrow1;
					verts[1] = y1 + yarrow1;

					if (input_color_map != NULL)
						GEOMadd_disjoint_line(obj, verts, colors, 2,
							GEOM_COPY_DATA);
					else
						GEOMadd_disjoint_line(obj, verts, GEOM_NULL, 2,
							GEOM_COPY_DATA);
					}
				}
			}
		}
	}
*geom_output = GEOMinit_edit_list(*geom_output) ;
GEOMedit_geometry(*geom_output, "geom_output", obj) ;
GEOMdestroy_obj(obj);
return(1);
}

#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
WIND_PLOT_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif

get_arrow(x0, y0, x1, y1, xarrow0, yarrow0, xarrow1, yarrow1, every)
float x0, y0, x1, y1;
float *xarrow0, *yarrow0, *xarrow1, *yarrow1;
int every;
{
double dx, dy;
double xa0, ya0;
double xa1, ya1;
double xtemp, ytemp;
double d, theta;

dx = x1 - x0;
dy = y1 - y0;
d = sqrt(dx * dx + dy * dy);
theta = (acos(dx/d))/RADIAN;
if (dy < 0.)
	theta = 360. - theta;
xa0 = xa1 = -(XARROWHEADSIZE * every);
ya0 = (YARROWHEADSIZE * every)/2.0;
ya1 = -ya0;

rotate(xa0, ya0, theta, &xtemp, &ytemp);
*xarrow0 = xtemp;
*yarrow0 = ytemp;

rotate(xa1, ya1, theta, &xtemp, &ytemp);
*xarrow1 = xtemp;
*yarrow1 = ytemp;

}

rotate(x, y, theta, xr, yr)
double x, y, theta;
double *xr, *yr;
{
double angle;

angle = theta * RADIAN;

*xr = x * cos(angle) - y * sin(angle);
*yr = x * sin(angle) + y * cos(angle);
}

