/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* From Foley & van Dam, 2nd edition, p. 592 (RGB_To_HSV) and
	p. 593 (HSV_To_RGB)

While hue is classically UNDEFINED when saturation is zero, to make these
routines work correctly with the standard AVS greyscale map that has
saturation values of zero and corresponding hues of zero, hue is set to
zero instead of UNDEFINED in those cases.
*/ 



#include <avs/port.h>
#include <stdio.h>

rgb2hsv(r, g, b, h, s, v)
float r, g, b;			/* range [0, 1] */
float *h, *s, *v;		/* range h [0, 360], s [0, 1], v [0, 1] */
{
float min, max, delta;

min = r;			/* get min(r, g, b) */
if (g < min)
	min = g;
if (b < min)
	min = b;

max = r;			/* get max(r, g, b) */
if (g < max)
	max = g;
if (b < max)
	max = b;

*v = max;			/* value */

if (max != 0.0)
	*s = (max - min)/max;	/* saturation */
else
	*s = 0.0;		/* saturation = 0 ==> r, g, b all zero */

if (*s == 0.0)
	*h = 0.0;
else
	{
	delta = max - min;
	if (r == max)
		*h = (g - b)/delta;	/* hue between yellow & magenta */
	else if (g == max)
		*h = 2 + (b - r)/delta;	/* hue is between cyan & yellow */
	else if (b == max)
		*h = 4 + (r - g)/delta;	/* hue is between magenta & cyan */

	*h = *h * 60;			/* convert hue to degrees */
	if (*h < 0.0)
		*h = *h + 360.0;	
	}
}

hsv2rgb(h, s, v, r, g, b)
float h, s, v;				/* range h [0,360], s [0,1], v [0,1] */ 
float *r, *g, *b;			/* range [0, 1] */
{
float p, q, t, f, htmp;
int i;

if (s == 0.0)				/* color on black-white center line */
	{
	*r = v;
	*g = v;
	*b = v;
	}
else					/* chromatic color -- this is a hue */
	{
	htmp = h;
	if (htmp == 360.0)
		htmp = 0.0;
	htmp = htmp/60.0;		/* h now in [0,6) range */

	i = (int) (htmp);		/* largest integer <= h */

	f = htmp - i;			/* fractional part of h */

	p = v * (1.0 - s);
	q = v * (1.0 - (s * f));
	t = v * (1.0 - (s * (1.0 - f)));
	
	switch(i)
		{
		case 0:	{*r = v; *g = t; *b = p; break;}
		case 1:	{*r = q; *g = v; *b = p; break;}
		case 2:	{*r = p; *g = v; *b = t; break;}
		case 3:	{*r = p; *g = q; *b = v; break;}
		case 4:	{*r = t; *g = p; *b = v; break;}
		case 5:	{*r = v; *g = p; *b = q; break;}
		}
	}
}

/* shove the rgb values into bytes and merge into one unsigned integer */
 
hsv2rgb_byte(h, s, v, rgb_byte)
float h, s, v;				/* range h [0,360], s [0,1], v [0,1] */ 
unsigned int *rgb_byte;
{
float p, q, t, f, htmp;
float r, g, b;
int ir, ig, ib;
int i;

if (s == 0.0)				/* color on black-white center line */
	{
	r = v;
	g = v;
	b = v;
	}
else					/* chromatic color -- this is a hue */
	{
	htmp = h;
	if (htmp == 360.0)
		htmp = 0.0;
	htmp = htmp/60.0;		/* h now in [0,6) range */

	i = (htmp);		/* largest integer <= h */

	f = htmp - i;			/* fractional part of h */

	p = v * (1.0 - s);
	q = v * (1.0 - (s * f));
	t = v * (1.0 - (s * (1.0 - f)));
	
	switch(i)
		{
		case 0:	{r = v; g = t; b = p; break;}
		case 1:	{r = q; g = v; b = p; break;}
		case 2:	{r = p; g = v; b = t; break;}
		case 3:	{r = p; g = q; b = v; break;}
		case 4:	{r = t; g = p; b = v; break;}
		case 5:	{r = v; g = p; b = q; break;}
		}
	}
ir = (int) (r * 255.0);
ig = (int) (g * 255.0);
ib = (int) (b * 255.0);
*rgb_byte = (unsigned int)
    ((ir << AVS_RED_SHIFT) | (ig << AVS_GREEN_SHIFT) | (ib << AVS_BLUE_SHIFT));
}
