/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce bivar.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  bivar.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  bivar.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     bivar.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
bivar.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov

    19 June 1991

    This AVS module will do 2 variable resampling of scattered
    data.

    The algorithm is essentially to weight the value at each output
    grid point as a function of any number of input points which
    lie within a user-specified "search radius".
*/

#include <stdio.h>
#include <math.h>
#include <avs/avs.h>
#include <avs/field.h>

AVSinit_modules()
{
    int bivar();
    AVSmodule_from_desc(bivar);
}

bivar()
{
    int p,bivar_p();

    AVSset_module_name("bivar",MODULE_MAPPER);
    AVScreate_input_port("input_field","field 1D irregular scalar float",REQUIRED);
    AVScreate_output_port("output_field","field 2D irregular scalar float");

    p=AVSadd_parameter("dummy1","string","Interpolation Range Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_float_parameter("Xmin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Xmax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    
    p=AVSadd_float_parameter("Ymin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Ymax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");

    p=AVSadd_parameter("dummy2","string","Output Grid Resolution","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_parameter("Xsamples","integer",20,10,1000);
    AVSconnect_widget(p,"idial");
    p=AVSadd_parameter("Ysamples","integer",20,10,1000);
    AVSconnect_widget(p,"idial");

    p=AVSadd_parameter("dummy3","string","Algorithmic Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_float_parameter("Search Radius",1.0,0.0,100000.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Weight Function",1.0,0.0,100.0);
    AVSconnect_widget(p,"dial");
    p=AVSadd_float_parameter("Undefined Value",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");

    AVSset_compute_proc(bivar_p);
}

bivar_p(inf,outf,dummy1,xmin,xmax,ymin,ymax,dummy2,xs,ys,dummy3,sr,weight_function,undef_value)
AVSfield_float *inf,**outf;
char *dummy1,*dummy2,*dummy3;
float *xmin,*xmax,*ymin,*ymax,*sr,*weight_function,*undef_value;
int xs,ys;
{
    AVSfield_float template;
    int dims[3];
    int bivar_work_routine();

    /**
      * check for following error conditions:
      * 1. field data dimensions greater than one
      *
      * degenerate conditions:
      * 1. 3-d coordinates.  this module will assume the z-coords are
      *    constant. (use the trivar module for 3d interpolation)
    **/

    memset((char *)&template,0,sizeof(AVSfield_float));
    
    if (inf->ndim > 1)
    {
	AVSwarning(" Only 1-d scatter fields are presently allowed.");
	return(0);
    }

    template.ndim = 2;  /* take 1-d scatter data, interpolate in 2-d */
    template.nspace = 2;
    template.veclen = 1;
    template.type = AVS_TYPE_REAL;
    template.uniform = IRREGULAR; /* could probably get by on RECTILINEAR? */
    template.size = sizeof(float);
    dims[0] = xs;
    dims[1] = ys;
    if (*outf)
	AVSfield_free(*outf);
    *outf = (AVSfield_float *)AVSfield_alloc(&template,dims);
    if (*outf == NULL)
    {
	AVSwarning(" Output Field malloc error.");
	return(0);
    }
    
    if (bivar_work_routine(inf,*outf,xmin,xmax,ymin,ymax,xs,ys,sr,
		  weight_function,undef_value))
	return(1);
    else
	return(0);
}

int
bivar_work_routine(inf,outf,xmin,xmax,ymin,ymax,xs,ys,search_radius,
		   weight_function,undef_value)
AVSfield_float *inf,*outf;
float *xmin,*xmax,*ymin,*ymax,*search_radius,*weight_function,*undef_value;
int xs,ys;
{
    extern double sqrt(),pow();
    double xdist,sr,wf,t;
    int i,j,l;
    int inpoints,outpoints;
    float X,dX,Y,dY,*xptr,*yptr,*f;
    float *x,*xg,*y,*yg,*z,*zg;
    float *xp,*yp;
    float xnumer,xdenom;
    int direct_hit;

    inpoints = inf->dimensions[0];
    xptr = inf->points;
    yptr = xptr + inpoints;
    f = inf->data;

    /**
      * this routine just gets stuff set up.
    **/
	
    /**
      * now, we will evaluate the function at the desired number
      * of locations.
    **/
    X = *xmin;
    dX = (*xmax - *xmin)/(double)(xs - 1);
    Y = *ymin;
    dY = (*ymax - *ymin)/(double)(ys - 1);
/*    Z = *(yptr + n);  /* some arbitrary Z value */

    xp = outf->points;
    yp = outf->points + (outf->dimensions[0]*outf->dimensions[1]);

    /* load the coordinate values for the output grid. */
    Y = *ymin;
    for (j=0;j<ys;j++,Y += dY)
    {
	X = *xmin;
	for (i=0;i<xs;i++,X += dX)
	{
	    *xp++ = X;
	    *yp++ = Y;
	}
    }

    outpoints = outf->dimensions[0]*outf->dimensions[1];
    inpoints = inf->dimensions[0];
    sr = *search_radius;
    wf = *weight_function;
    xg = outf->points;
    yg = xg + outpoints;
    x = inf->points;
    y = x + inpoints;

    z = f;
    zg = outf->data;

    for (j=0;j<outpoints;j++)
    {
        xnumer = 0.;
	xdenom = 0.;
	direct_hit = 0;
	l=0;
	for (i=0;i<inpoints;i++)
	{
	    
	    t = (xg[j]-x[i])*(xg[j]-x[i]) + (yg[j]-y[i])*(yg[j]-y[i]);
	    
	    xdist = sqrt(t);

	    if (xdist < 1e-6)
	    {
		direct_hit = 1;
		zg[j] = f[i];
		break;
	    }

	    if (xdist < sr)
	    {
		l++;
		xnumer = xnumer+((1./pow(xdist,wf)) * f[i]);
		xdenom = xdenom+(1./pow(xdist,wf));
	    }
	}
#if 0
	if (l < 2)
	    ;
	    /* possible error condition ?? */
#endif
	if (direct_hit != 1)
	{
	    if (l == 0)
		zg[j] = *undef_value;
	    else
		zg[j] = xnumer/xdenom;
	}
    }
    
    return(1);
}
