/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
     (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE,
INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST
PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
*****************************************************************************

/*   This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce color_legend.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  color_legend.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  color_legend.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     color_legend.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
color_legend.c, or any part thereof.

Summer 1991  wes bethel  ewbethel@lbl.gov    
17 July 1992 john tee mod for Vistra - byte ordering in last source line
*/

/* BUGS fixed : 22.01.1993

   1- offset[3] array from color_legend_p() function must be 
      initialized with 0.0

   2- the decimal_precision variable has to be between 0 and 9
      not between 0 and 10( 10+0x30 isn't a digit).

   -Ion Barosan,  Computing Center, University of Technology Eindhoven
                  email: rcion@urc.tue.nl
*/

/********************************************************************************************/
/*                                                                                          */
/*THIS MODULE IS A MODIFICATION OF THE COLOR LEGEND MODULE BY LAWRENCE BERKELEY LABORATORY  */
/*                                                                                          */
/*  The modification is done by Konstantinis G. Kakoulis and Yihsing Song, under the        */
/*  supervision of Dr. Susanna Wei, Department of Mathematics and Computer Science,         */
/*  Saint Joseph's University, Philadelphia, Pennsylvania.                                  */
/*  This modification includes:                                                             */
/*   1. An added input port of type FIELD 1D; The minimum value, maximum value and the      */
/*               visibility of the color legend are defined by the first, second,           */
/*               and third element of the field, respectively.                              */
/*   2. Two additional parameters:                                                          */
/*       a. LEGEND WIDTH, defines the width of the color legend.                            */
/*       b. LEGEND HEIGHT, defines the height of the color legend.                          */
/*   3. The geometry produced by the module is NOT TRANSFORMABLE.                           */
/*   4. The first and the last labels of the color legend are not displayed on the screen.  */
/********************************************************************************************/    

 
#include <stdio.h>
#include <avs/avs.h>
#include <avs/colormap.h>
#include <avs/geom.h>
#include <field.h>

#define MIN(a,b) (((a)<(b))?(a):(b))

static char
    scale_name[] = {"color_legend"},
    boundary_name[] = {"color_boundary"},
    labels_name[] = {"legend_labels"},
    label_b_name[] = {"label_bounaries"};

char *parent_name = scale_name;

    
AVSinit_modules()
{
    int color_legend();
    AVSmodule_from_desc(color_legend);
}

int
color_legend()
{
    int color_legend_p(),p;

    AVSset_module_name("col_legend2",MODULE_MAPPER);
    AVScreate_input_port("Input Color Scale", "colormap", REQUIRED);
/*********************************************************************/
/* The added input port.                                             */
/*********************************************************************/
    AVScreate_input_port("Input X Scale", "field 1D", REQUIRED);

    AVScreate_output_port("Output Scale","geom");

    p=AVSadd_float_parameter("X Offset",-0.92,-1.,1.);
    AVSconnect_widget(p,"slider");
    p=AVSadd_float_parameter("Y Offset",-0.83,-1.,1.);
    AVSconnect_widget(p,"slider");

/*******************************************************************/
/* Two additional parameters that manipulate the size of the legend*/
/*******************************************************************/ 
    p=AVSadd_float_parameter("legend width",0.08,0.01,1.0);
    AVSconnect_widget(p,"slider");
    p=AVSadd_float_parameter("legend heigth",1.61,0.01,3.5);
    AVSconnect_widget(p,"slider");

    p=AVSadd_parameter("dummy1","string","Boundary Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Boundary on/off","boolean",1,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",2);
    p=AVSadd_parameter("Boundary Gray Level","integer",255,0,255);
    AVSconnect_widget(p,"islider");
    
    p=AVSadd_parameter("dummy2","string","Label Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Labels on/off","boolean",1,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",2);

    p=AVSadd_parameter("Label Density","integer",12,12,12);
    AVSconnect_widget(p,"islider");
    p=AVSadd_float_parameter("Label Height",0.08,0.001,0.2);
    AVSconnect_widget(p,"slider");
/**********************************************************************/
/*     - Ion Barosan  22.01.93                                      ***/
    p=AVSadd_parameter("Decimal Precision","integer",2,0,9);
/**********************************************************************/
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Label Gray Level","integer",255,0,255);
    AVSconnect_widget(p,"islider");
    p=AVSadd_parameter("Label Font","integer",3,0,21);
    AVSconnect_widget(p,"islider");
    
    p=AVSadd_parameter("dummy2a","string","Label Boundary Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Label Boundaries on/off","boolean",1,0,1);
    AVSconnect_widget(p,"toggle");
    AVSadd_parameter_prop(p,"width","integer",3);

    p=AVSadd_parameter("dummy3","string","Misc. Control Parameters","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p = AVSadd_parameter("Reverse Colors","boolean",0,0,1);
    AVSconnect_widget(p,"toggle");
    
    p=AVSadd_parameter("dummy4","string","Legend Orientation Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Orientation","choice","vertical","vertical!horizontal","!");
    AVSconnect_widget(p,"radio_buttons");

    AVSset_compute_proc(color_legend_p);
}

#define USIZE 2

color_legend_p(cmap,xinput,og,
            xoffset,yoffset,xwidth,yheight,
            dummy1,do_boundary,boundary_gray,
            dummy2,do_labels,label_density,label_height,
            precision,label_gray,font_number,
            dummy2a,do_lb,
            dummy3,flip,
            dummy4,orientation)
char *dummy1,*dummy2,*dummy3,*orientation,*dummy4,*dummy2a;
AVScolormap *cmap;
AVSfield_float  *xinput;
GEOMedit_list *og;
float *xoffset,*yoffset,*xwidth,*yheight;
int flip,do_boundary,do_labels,precision,label_gray,boundary_gray,font_number;
int do_lb;
float *label_height;
{
    GEOMobj *scale,*boundary,*labels,*label_boundaries;
    
    float *normals;
    unsigned long *colors;
    float *vertices;
    float *b_vertices,*b_colors;
    int nblocks;
    int make_normals();
    float xsize,ysize;
    float ref_point[3],offset[3],height,label_color[3];
    char this_label[128],sprintf_arg[5];
    float lv,dlv,lp,dlp;
    int i;
    float *extent = NULL;
    int vertical_flag = AVSchoice_number("Orientation",orientation)-1;
    int do_legend;
    
    *og = GEOMinit_edit_list(*og);
    nblocks = cmap->size;
   /* draw the legend or not. Added by kostas Kakoulis*/
   do_legend = (int)(xinput->data[2]);   
   

    /* first, make the color scale itself. */
   
    vertices = (float *)ALLOC_LOCAL(sizeof(float)*nblocks*USIZE*3);
    normals = (float *)ALLOC_LOCAL(sizeof(float)*nblocks*USIZE*3);
    colors = (unsigned long *)ALLOC_LOCAL(sizeof(unsigned long)*nblocks*USIZE);

    /* the following sets the proportions for the width vs height
       for the color legend. */
/**************************************************************/
/*The size of the color legend is not fixed anymore.          */
/**************************************************************/    
    xsize = *xwidth;
    ysize = *yheight;

    if (vertical_flag == 0)   
make_vertices_vertical(vertices,&xsize,&ysize,cmap->size,USIZE,xoffset,yoffset);
    else
     make_vertices_horiz(vertices,&ysize,&xsize,cmap->size,USIZE,xoffset,yoffset);
                 
    make_normals(normals,cmap->size,USIZE);
    
    make_colors(colors,cmap,cmap->size,USIZE,flip);

  
  

    scale = GEOMcreate_mesh_with_data(GEOM_NULL,vertices,normals, 
     colors,cmap->size,USIZE,GEOM_COPY_DATA);  
    GEOMnormalize_normals(scale);
  /*********************************************************/
  /*The visibility of the color legend is controlled by the*/
  /*third element of the field 1D -in the added input port.  */
  /*********************************************************/ 
    GEOMedit_visibility(*og,parent_name, do_legend );
    GEOMedit_geometry(*og,parent_name,scale);
  /*********************************************************/
  /* The color legend becomes NOT TRANSFORMABLE.           */
  /*********************************************************/
    GEOMedit_transform_mode(*og,parent_name,"locked");
    GEOMedit_selection_mode(*og,parent_name,"ignore",0);
    GEOMdestroy_obj(scale);
    FREE_LOCAL(vertices);
    FREE_LOCAL(normals);
    FREE_LOCAL(colors);
    
    /* create a boundary (if the user requested it) to go around
       the color scale */
    boundary = GEOMcreate_obj(GEOM_POLYTRI,extent);
    if (do_boundary) 
    {
     b_vertices = (float *)malloc(sizeof(float)*5*3);
     b_colors = (float *)malloc(sizeof(float)*5*3);
     if (vertical_flag == 0)  /* vertical */
         make_boundary_vertices(b_vertices,&xsize,&ysize,xoffset,yoffset);
     else /* horizontal */
         make_boundary_vertices(b_vertices,&ysize,&xsize,xoffset,yoffset);
         
     /* set the boundary color to some shade of gray. */
     for (i=0;i<5*3;i++)
         *(b_colors+i) = (double)boundary_gray/255.0;
     GEOMadd_polyline(boundary,b_vertices,b_colors,5,GEOM_COPY_DATA);
     
     FREE_LOCAL(b_vertices);
     FREE_LOCAL(b_colors);
    }
    GEOMedit_geometry(*og,boundary_name,boundary);
    GEOMedit_selection_mode(*og,boundary_name,"ignore",0);
    GEOMedit_parent(*og,boundary_name,parent_name);
    GEOMdestroy_obj(boundary);

    /* ok, now we're done with the color scale part. so, we will
       move onto the labels. */

    labels = GEOMcreate_obj(GEOM_LABEL,extent);

    /**
      * NOTE: if you change the way the label positioning is done,
      * you'll need to make corresponding changes below where the
      * label boundary coordinates are computed.
    **/
    
    if (do_labels)     
     {
     /* Set the number of digits to the right of the decimal */
     sprintf_arg[0] = '%';
     sprintf_arg[1] = '.';
     sprintf_arg[2] = precision + 0x30;
     sprintf_arg[3] = 'f';
     sprintf_arg[4] = '\0';

     label_color[0] = label_color[1] = label_color[2] = (double)label_gray / 255.0;
     
     ref_point[0] = ref_point[1] = ref_point[2] = 0.0;
     height = *label_height;


     lv = xinput->data[0];
     dlv = (xinput->data[1] -   xinput->data[0]) /((double)(label_density-1));

     ref_point[2] = 0.0;
/*****************************************************************/
/**                  -Ion Barosan, 22.01.93                     **/

     offset[0]=offset[1]=offset[2]=0.0;

/****************************************************************/


if (vertical_flag == 0) /* vertical */
  {


     if (flip)
     {
         lp = ysize + *yoffset;
         dlp = -1. * ysize/((double)(label_density-1));
     }
     else
     {
         lp = *yoffset;
         dlp = ysize/((double)(label_density-1));
     }
  

     for (i=0;i<label_density - 1;i++,lv+=dlv,lp+=dlp)
     {
          if ( i )
         sprintf(this_label,sprintf_arg,lv);

          ref_point[0] = 0.066 + *xoffset + xsize;
          ref_point[1] = lp - 0.20*height;
           if(i)
          GEOMadd_label(labels,this_label,ref_point,offset,height,
                     label_color,
                    
GEOMcreate_label_flags(font_number,0,0,0,GEOM_LABEL_LEFT,0));
         }
   }
else
  {


     if (flip)
     {
         lp = *xoffset + ysize;
         dlp = -1. * ysize/((double)(label_density-1));
     }
     else
     {
         lp = *xoffset ;
         dlp = ysize/((double)(label_density-1));
     }

               
     for (i=0;i<label_density - 1;i++,lv+=dlv,lp+=dlp)
     {
           if (i)
         sprintf(this_label,sprintf_arg,lv);

          ref_point[1] = -0.066 + *yoffset;
          ref_point[0] = lp - 0.20*height;
         if (i)
          GEOMadd_label(labels,this_label,ref_point,offset,height,
                     label_color,
                    
GEOMcreate_label_flags(font_number,0,0,0,GEOM_LABEL_CENTER,0));
         }
         
     }
    }
    GEOMedit_geometry(*og,labels_name,labels);
    GEOMedit_selection_mode(*og,labels_name,"ignore",0);
    GEOMedit_parent(*og,labels_name,parent_name);
    GEOMdestroy_obj(labels);

    /* do the label boundaries, if requested. */
    label_boundaries = GEOMcreate_obj(GEOM_POLYTRI,extent);
    b_vertices = (float *)malloc(sizeof(float)*2*3);
    b_colors = (float *)malloc(sizeof(float)*2*3);
    if (do_lb) 
    {

     
     lv = xinput->data[0];
     dlv = (xinput->data[1] - xinput->data[0])/((double)(label_density-1));

     for (i=0;i<6;i++)
         *(b_colors+i) = (double)label_gray/255.0;



      if (vertical_flag == 0) /* vertical */
       {



          if (flip)
            {
                lp =  *yoffset + ysize;
                dlp = -1. * ysize/((double)(label_density-1));
             }
          else
            {
                lp = *yoffset;
                dlp = ysize/((double)(label_density-1));
            }

         *(b_vertices+2) = *(b_vertices+5) = 0.;
     
         for (i=0;i<label_density;i++,lv+=dlv,lp+=dlp)
          {
 
          *(b_vertices) = *xoffset;
          *(b_vertices+1) = lp; /*  - 0.20*height; */
          *(b_vertices+3) = *xoffset +  xsize;
          *(b_vertices+4) = lp; /*  - 0.20*height; */
      GEOMadd_polyline(label_boundaries,b_vertices,b_colors,2,GEOM_COPY_DATA);
          }
       }


    else
      {
     if (flip)
     {
         lp =  *xoffset + ysize;
         dlp = -1. * ysize/((double)(label_density-1));
     }
     else
     {
         lp = *xoffset;
         dlp = ysize/((double)(label_density-1));
     }

         *(b_vertices+2) = *(b_vertices+5) = 0.;

         for (i=0;i<label_density;i++,lv+=dlv,lp+=dlp)
             {

          *(b_vertices) = lp; /* - 0.20*height; */
          *(b_vertices+1) = *yoffset;
          *(b_vertices+3) = lp; /* - 0.20*height; */
          *(b_vertices+4) = *yoffset + xsize;
     GEOMadd_polyline(label_boundaries,b_vertices,b_colors,2,GEOM_COPY_DATA);
         }
         }
         
     
    }
    FREE_LOCAL(b_vertices);
    FREE_LOCAL(b_colors);
    GEOMedit_geometry(*og,label_b_name,label_boundaries);
    GEOMedit_selection_mode(*og,label_b_name,"ignore",0);
    GEOMedit_parent(*og,label_b_name,parent_name);
    GEOMdestroy_obj(label_boundaries);
    
    return(1);
}

make_boundary_vertices(bv,xn,yn,xoffset,yoffset)
float *bv;
float *xn,*yn;
float *xoffset,*yoffset;
{
    int i;

    for (i=0;i<5;i++)
     *(bv+(i*3)+2) = 0.;  /* z ==  0. */
    *bv =  *xoffset;
    *(bv+1) = *yoffset;
    *(bv+3) = *xn + *xoffset;
    *(bv+4) = *yoffset;
    *(bv+6) = *xn + *xoffset;
    *(bv+7) = *yn  + *yoffset;
    *(bv+9) = *xoffset;
    *(bv+10) = *yn + *yoffset;
    *(bv+12) = *xoffset;
    *(bv+13) = *yoffset;
}


static int
make_colors(dest,src,size,usize,flip)
unsigned long *dest;
AVScolormap *src;
int size,flip,usize;
{
    int i,j,index;
    unsigned int temp;

    for (j=0;j<usize;j++)
     for (i=0;i<size;i++)
     {
         if (flip)
          index = size - 1 - (MIN(i,255));
         else
          index = i;
        
PIXELhsva_to_pixel(&temp,src->hue[index],src->saturation[index],src->value[index],src->alpha
[index]);
         *dest++ = temp;
     }
}

static int
make_vertices_vertical(v,xs,ys,cmapsize,width,xoffset,yoffset)
float *v;
float *xs,*ys;
float *xoffset,*yoffset;
int cmapsize,width;
{
    int i,j;
    double x,dx,y,dy;

    dx = *xs/(double)(width-1);
    dy = *ys/(double)(cmapsize-1);

    for (j=0,x=*xoffset;j<width;j++,x+=dx)
    {
     for (i=0,y=*yoffset;i<cmapsize;i++,y+=dy)
     {
         *v++ = (float)x;
         *v++ = (float)y;
         *v++ = 0.;
     }
    }
 
}
static int
make_vertices_horiz(v,xs,ys,cmapsize,width ,xoffset,yoffset)
float *v;
float *xs,*ys;
float *xoffset,*yoffset;
int cmapsize,width;
{
    int i,j;
    double x,dx,y,dy;

    dx = *xs/(double)(cmapsize-1);
    dy = *ys/(double)(width-1);

    for (j=0,y=*yoffset;j<width;j++,y+=dy)
    {
     for (i=0,x=*xoffset;i<cmapsize;i++,x+=dx)
     {
         *v++ = (float)x;
         *v++ = (float)y;
         *v++ = 0.;
     }
    }
}
static int
make_normals(v,size,usize)
float *v;
int size,usize;
{
    int i,j;

    for (j=0;j<usize;j++)
     for (i=0;i<size;i++)
     {
         *v++ = 0.;
         *v++ = 0.;
         *v++ = 1.;
     }
}

