/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/colormap.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/flow.h>

extern int FlowVerbose;

/* Used for AVSmessage() */
static char file_version[] = "contour to postscript v1.05 14/02/92";

#define GAMMA 1.4
#define MAXCHR 255
#define max(a, b) ((a) > (b) ? (a) : (b))

#ifndef HEADER
#  define HEADER "header.ps"
#endif
static char *headerfile = HEADER;

/* Operators are handled in iinit.c. */
#define oper_(defs)

static FILE *pf;
static int slice;
static float scale, off1, off2;

cont2post()
{
  int parm,contour_p();

  AVSset_module_name("contour to postscript",MODULE_MAPPER);

  AVScreate_input_port("InputField","field 2D 3-coordinate scalar float",
                       REQUIRED);

  AVScreate_input_port("InputCmap","colormap",OPTIONAL);

  AVScreate_output_port("OutputGeom","geom");

  parm=AVSadd_parameter("level choice", "choice", "min/max scale",
                        "auto scale|min/max scale|type in", "|");
  AVSconnect_widget(parm,"radio_buttons");

  parm=AVSadd_parameter("Boundary On/Off","boolean",1,0,1);
  AVSconnect_widget(parm,"toggle");

  parm=AVSadd_parameter("nr of levels","integer",2,INT_UNBOUND,INT_UNBOUND);
  AVSconnect_widget(parm,"typein_integer");

  parm=AVSadd_parameter("min/max format","string", "%7.3f", "", "");
  AVSconnect_widget(parm,"typein");

  parm=AVSadd_parameter("output statistics","string_block", "", "", "");
  AVSconnect_widget(parm,"textblock");
  AVSadd_parameter_prop(parm,"width", "integer", 4);
  AVSadd_parameter_prop(parm,"height", "integer", 6);

/*           Postscript output      */
  parm=AVSadd_parameter("Postscript output","boolean",0,0,1);
  AVSconnect_widget(parm,"toggle");
  parm=AVSadd_parameter("Postscript file ","string","/usr/tmp/Post.ps", 0,"");
  AVSconnect_widget(parm, "typein");
  parm=AVSadd_float_parameter("max size in cm",19.,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");
/*           end Postscript output      */

  parm=AVSadd_float_parameter("minimum level",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"dial");

  parm=AVSadd_float_parameter("maximum level",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"dial");

  parm=AVSadd_float_parameter("level 1",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 2",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 3",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 4",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 5",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 6",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 7",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 8",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 9",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  parm=AVSadd_float_parameter("level 10",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
  AVSconnect_widget(parm,"typein_real");

  AVSset_compute_proc(contour_p);
}

contour_p(InFld, CMap, OutGeom, LevChoice, Bound, NLevels, MMfmt, OutStat,
          PSoutput, PSfile, PSsize,
          MinVal, MaxVal, TLevel1, TLevel2, TLevel3, TLevel4, TLevel5,
          TLevel6, TLevel7, TLevel8, TLevel9, TLevel10)
AVSfield_float *InFld;
AVScolormap    *CMap;
GEOMedit_list  *OutGeom;
int            LevChoice, Bound, NLevels, PSoutput;
char           *MMfmt, *OutStat, *PSfile;
float          *PSsize, *MinVal, *MaxVal;
float          *TLevel1, *TLevel2, *TLevel3, *TLevel4, *TLevel5,
               *TLevel6, *TLevel7, *TLevel8, *TLevel9, *TLevel10;
{
  AVSfield_float *IrFld;
  GEOMobj *contour_obj;
  float contour_shade[3];
  int LevMethod;
  float MinFld, MaxFld, MinLev, MaxLev, *CLevel;
  float xmax, xmin, ymax, ymin, zmax, zmin, xsize, ysize, zsize;
  int i, index, done;
  int dims[2], NNode;
  float step;
  char buff[128], outstat[512], statfmt[128], fnam[64];

/*
 *  If the input field is already irregular we can use it.
 *  If the input field is not irregular we have to allocate an irregular
 *  field and map our field onto this irregular field
 */
  if (InFld->uniform == IRREGULAR) {
    IrFld = InFld;
  } else {
    dims[0] = MAXX(InFld);
    dims[1] = MAXY(InFld);
    IrFld = (AVSfield_float *)AVSdata_alloc(
          "field 2D 3-coordinate scalar float irregular",dims);
    (void) make_irregular(InFld, IrFld);
  }

/*
 *  Determine level choice mechanism
 *    1: automatic scaling between maximum and minimum field data levels
 *    2: uniform scaling between given maximum and minimum levels
 *    3: contours on type-in levels
 *  Adjust parameters in control panel accordingly
 */
  LevMethod = AVSchoice_number("level choice", LevChoice);

  if (LevMethod == 1) {
    AVSparameter_visible("minimum level", 0);
    AVSparameter_visible("maximum level", 0);
    for (i=1; i<11; i++) {
      sprintf(buff, "level %d", i);
      AVSparameter_visible(buff, 0);
    }
    AVSparameter_visible("output statistics", 1);
    AVSparameter_visible("min/max format", 1);
  } else if (LevMethod == 2) {
    AVSparameter_visible("minimum level", 1);
    AVSparameter_visible("maximum level", 1);
    for (i=1; i<11; i++) {
      sprintf(buff, "level %d", i);
      AVSparameter_visible(buff, 0);
    }
    AVSparameter_visible("output statistics", 1);
    AVSparameter_visible("min/max format", 1);
  } else if (LevMethod == 3) {
    AVSparameter_visible("minimum level", 0);
    AVSparameter_visible("maximum level", 0);
    AVSparameter_visible("output statistics", 0);
    AVSparameter_visible("min/max format", 0);
    if (NLevels > 10) {
      AVSmessage(file_version, AVS_Warning, AVSmodule, "field to contour",
                 "OK", "Maximum typein levels = 10!");
      NLevels = 10;
      AVSmodify_parameter("nr of levels", AVS_VALUE, 10, 0, 10);
    }
    for (i=1; i<=NLevels; i++) {
      sprintf(buff, "level %d", i);
      AVSparameter_visible(buff, 1);
    }
    for (i=NLevels+1; i<=10; i++) {
      sprintf(buff, "level %d", i);
      AVSparameter_visible(buff, 0);
    }
  }

  NNode = MAXX(IrFld) * MAXY(IrFld);
  field_get_minmax(IrFld->data, NNode, &MinFld, &MaxFld);

  if (LevMethod == 1) {
    MinLev = MinFld;
    MaxLev = MaxFld;
  } else if (LevMethod == 2) {
    MinLev = *MinVal;
    MaxLev = *MaxVal;
  }

/*
 *  Allocate contour levels and fill with (auto)scaled or typein values
 *  1st contour level = MinLev   \
 *             .                  \
 *  inbetween equally spaced       > scaled contour levels
 *             .                  /
 *  last contour level = MaxLev  /
 */
  CLevel = (float *)ALLOC_LOCAL(NLevels*sizeof(float));
  if ((LevMethod == 1) | (LevMethod == 2)) {
    if (NLevels > 1) {
      step = (MaxLev - MinLev) / (float)(NLevels-1);
      for (i=0; i<NLevels; i++) {
        CLevel[i] = MinLev + i*step;
      }
    } else if (NLevels > 0) {
      CLevel[0] = (MaxLev + MinLev)/2.;
    }
  } else if (LevMethod == 3) {
    if (NLevels > 0) CLevel[0] = *TLevel1;
    if (NLevels > 1) CLevel[1] = *TLevel2;
    if (NLevels > 2) CLevel[2] = *TLevel3;
    if (NLevels > 3) CLevel[3] = *TLevel4;
    if (NLevels > 4) CLevel[4] = *TLevel5;
    if (NLevels > 5) CLevel[5] = *TLevel6;
    if (NLevels > 6) CLevel[6] = *TLevel7;
    if (NLevels > 7) CLevel[7] = *TLevel8;
    if (NLevels > 8) CLevel[8] = *TLevel9;
    if (NLevels > 9) CLevel[9] = *TLevel10;
  }

  sprintf(statfmt,"minimum field value:  %s\nmaximum field value: %s\n",
                  MMfmt, MMfmt);
  sprintf(outstat, statfmt, MinFld, MaxFld);
  sprintf(buff,"contours: ");
  strcat(outstat, buff);
  sprintf(statfmt,"%s ", MMfmt);
  if (NLevels < 31) {
     for (i=0; i<NLevels; i++) {
       sprintf(buff, statfmt, CLevel[i]);
       strcat(outstat, buff);
       if (((i+1)%3) == 0) {
         sprintf(buff, "\n               ");
         strcat(outstat, buff);
       }
     }
  }
  else {
     sprintf(buff,"too much levels\n               for printout");
     strcat(outstat, buff);
  }

  AVSmodify_parameter("output statistics", AVS_VALUE, outstat, 0, 0);

/* initialize edit list.... */
  *OutGeom = GEOMinit_edit_list(*OutGeom);
  if (!CMap)
    contour_shade[0] = -1.0;

/*  Postscript output startup */
  if (PSoutput) {
     AVSparameter_visible("Postscript file ", 1);
     AVSparameter_visible("max size in cm", 1);

/* find minimum and maximum values for x, y and z coordinates */
     field_get_extend(IrFld->points, NNode, &xmax, &xmin);
     field_get_extend(IrFld->points+NNode, NNode, &ymax, &ymin);
     field_get_extend(IrFld->points+2*NNode, NNode, &zmax, &zmin);

/* determine which index is constant */
     xsize=xmax-xmin; ysize=ymax-ymin; zsize=zmax-zmin;
     if (zsize < xsize && zsize < ysize) {
        slice = 1;
        scale=9000./max(xsize,ysize);
        off1=xmin;
        off2=ymin;
     }
     if (ysize < xsize && ysize < zsize) {
        slice = 2;
        scale=9000./max(xsize,zsize);
        off1=xmin;
        off2=zmin;
     }
     if (xsize < ysize && xsize < zsize) {
        slice = 3;
        scale=9000./max(ysize,zsize);
        off1=ymin;
        off2=zmin;
     }

/* open file and write header */
     sprintf(buff,"rm -f %s",PSfile);
     system(buff);
     sprintf(fnam, "%s", tmpnam(NULL));
     pf = fopen(fnam, "w");
     fprintf(pf,"%.3f %.3f scale\n",.06* *PSsize/19.,.06* *PSsize/19.);
     fprintf(pf,"14 setlinewidth\n[] 0 setdash\nnewpath");
  }
  else {
     AVSparameter_visible("Postscript file ", 0);
     AVSparameter_visible("max size in cm", 0);
     slice=0;
  }
  

/* CREATE the contours */
  for (i=0; i<NLevels; i++){

    contour_obj = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);

/* determine the color associated with this level value....*/
    if (CMap) {
      index = AVScmap_index(CMap,CLevel[i]);
      (void) hsv_to_rgb(contour_shade,contour_shade+1,contour_shade+2,
                 CMap->hue[index],CMap->saturation[index],CMap->value[index]);
    }

/* process the input field.....*/

    build_contour_list(contour_obj, IrFld, &CLevel[i], contour_shade);

    GEOMedit_geometry(*OutGeom,"contour",contour_obj);
    GEOMdestroy_obj(contour_obj);

    done = ((i+1)*100)/NLevels;
    AVSmodule_status("contour", done);
  }

  if (Bound == 1) {
    contour_obj = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);
    build_boundary_list(contour_obj,IrFld);
    GEOMedit_geometry(*OutGeom,"contour",contour_obj);
    GEOMdestroy_obj(contour_obj);
  }

  if (InFld->uniform != IRREGULAR)
    AVSfield_free(IrFld);
  FREE_LOCAL(CLevel);

  if (PSoutput) {
     fprintf(pf,"\nstroke\nshowpage");
     fclose(pf);
     sprintf(buff,
     "cat %s %s > %s; rm -f %s", headerfile, fnam, PSfile, fnam);
     system(buff);
  }
  return(1);
}

build_contour_list(obj,inf,lev,shade)
GEOMobj *obj;
AVSfield_float *inf;
float *lev,*shade;
{
  int i, j, offset0, offset1, imax, jmax;
  float *d;
  int opcode;
  int THRESHCROSS();
  int find_corner();

  d = inf->data;
  imax = MAXX(inf);
  jmax = MAXY(inf);

  for (j=0;j<jmax-1;j++) {
    offset0 = j*imax;
    offset1 = (j+1)*imax;
    for (i=0;i<imax-1;i++) {

/*
 *  opcode determines the number of crossings found
 */
      opcode = 0;
      if (THRESHCROSS(d+offset0+i,d+offset0+i+1,lev))
        opcode += 1;
      if (THRESHCROSS(d+offset0+i+1,d+offset1+i+1,lev))
        opcode += 2;
      if (THRESHCROSS(d+offset1+i+1,d+offset1+i,lev))
        opcode += 4;
      if (THRESHCROSS(d+offset1+i,d+offset0+i,lev))
        opcode += 8;

/*
 *  find crossings with opcode and make vertices
 *  only even # of crossings possible
 */
      if (opcode == 3) {
        do_corner(offset0+i,offset0+i+1,offset1+i+1,inf,lev,obj,shade);
      } else if (opcode == 5) {
        do_block(offset0+i,offset0+i+1,offset1+i+1,offset1+i,inf,lev,obj,shade);
      } else if (opcode == 6) {
        do_corner(offset0+i+1,offset1+i+1,offset1+i,inf,lev,obj,shade);
      } else if (opcode == 9) {
        do_corner(offset1+i,offset0+i,offset0+i+1,inf,lev,obj,shade);
      } else if (opcode == 10) {
        do_block(offset0+i+1,offset1+i+1,offset1+i,offset0+i,inf,lev,obj,shade);
      } else if (opcode == 12) {
        do_corner(offset1+i+1,offset1+i,offset0+i,inf,lev,obj,shade);
      } else if (opcode == 15) {
        if (find_corner(offset0+i,offset0+i+1,offset1+i+1,offset1+i,inf,lev)) {
          do_corner(offset0+i,offset0+i+1,offset1+i+1,inf,lev,obj,shade);
          do_corner(offset1+i+1,offset1+i,offset0+i,inf,lev,obj,shade);
        } else {
          do_corner(offset1+i,offset0+i,offset0+i+1,inf,lev,obj,shade);
          do_corner(offset0+i+1,offset1+i+1,offset1+i,inf,lev,obj,shade);
        }
      } else if ((opcode ==  1) || (opcode ==  2) || (opcode ==  4) ||
                 (opcode ==  8) || (opcode ==  7) || (opcode == 11) ||
                 (opcode == 13) || (opcode == 14)) {
          fprintf(stderr,"impossible situation\n"); /* no odd # of crossings */
      }
    }
  }
  return(1);
}

do_corner(p0,p1,p2,inf,thresh,obj,shade)
int p0,p1,p2;
AVSfield_float *inf;
float *thresh;
GEOMobj *obj;
float *shade;
{
  double u,v;
  float verts[6];
  float *xp, *yp, *zp;

  xp = inf->points;
  yp = xp + MAXX(inf)*MAXY(inf);
  zp = yp + MAXX(inf)*MAXY(inf);

  u = (*thresh - *(inf->data + p0))/(*(inf->data+p1) - *(inf->data+p0));
  verts[0] = *(xp+p0) + u*(*(xp+p1)- *(xp+p0));
  verts[1] = *(yp+p0) + u*(*(yp+p1)- *(yp+p0));
  verts[2] = *(zp+p0) + u*(*(zp+p1)- *(zp+p0));

  v = (*thresh - *(inf->data + p1))/(*(inf->data+p2) - *(inf->data+p1));
  verts[3] = *(xp+p1) + v*(*(xp+p2)- *(xp+p1));
  verts[4] = *(yp+p1) + v*(*(yp+p2)- *(yp+p1));
  verts[5] = *(zp+p1) + v*(*(zp+p2)- *(zp+p1));

  ADD_SEGMENT(verts,shade,obj);
}

do_block(p0,p1,p2,p3,inf,thresh,obj,shade)
int p0,p1,p2,p3;
AVSfield_float *inf;
float *thresh;
GEOMobj *obj;
float *shade;
{
  double u,v;
  float verts[6];
  float *xp, *yp, *zp;

  xp = inf->points;
  yp = xp + MAXX(inf)*MAXY(inf);
  zp = yp + MAXX(inf)*MAXY(inf);

  u = (*thresh - *(inf->data + p0))/(*(inf->data+p1) - *(inf->data+p0));
  verts[0] = *(xp+p0) + u*(*(xp+p1)- *(xp+p0));
  verts[1] = *(yp+p0) + u*(*(yp+p1)- *(yp+p0));
  verts[2] = *(zp+p0) + u*(*(zp+p1)- *(zp+p0));

  v = (*thresh - *(inf->data + p2))/(*(inf->data+p3) - *(inf->data+p2));
  verts[3] = *(xp+p2) + v*(*(xp+p3)- *(xp+p2));
  verts[4] = *(yp+p2) + v*(*(yp+p3)- *(yp+p2));
  verts[5] = *(zp+p2) + v*(*(zp+p3)- *(zp+p2));

  ADD_SEGMENT(verts,shade,obj);
}

find_corner(p0,p1,p2,p3,inf,thresh)
int p0,p1,p2,p3;
AVSfield_float *inf;
float *thresh;
{
  double u;
  float *xp, *yp, *zp;
  float cp1x, cp1y, cp1z, cp2x, cp2y, cp2z,
        cp3x, cp3y, cp3z, cp4x, cp4y, cp4z,
         d12,  d23,  d34,  d41, dir0, dir1;

  xp = inf->points;
  yp = xp + MAXX(inf)*MAXY(inf);
  zp = yp + MAXX(inf)*MAXY(inf);

/*  crossing point between p0 & p1  */
  u = (*thresh - *(inf->data + p0))/(*(inf->data+p1) - *(inf->data+p0));
  cp1x = *(xp+p0) + u*(*(xp+p1)- *(xp+p0));
  cp1y = *(yp+p0) + u*(*(yp+p1)- *(yp+p0));
  cp1z = *(zp+p0) + u*(*(zp+p1)- *(zp+p0));

/*  crossing point between p1 & p2  */
  u = (*thresh - *(inf->data + p1))/(*(inf->data+p2) - *(inf->data+p1));
  cp2x = *(xp+p1) + u*(*(xp+p2)- *(xp+p1));
  cp2y = *(yp+p1) + u*(*(yp+p2)- *(yp+p1));
  cp2z = *(zp+p1) + u*(*(zp+p2)- *(zp+p1));

/*  crossing point between p2 & p3  */
  u = (*thresh - *(inf->data + p2))/(*(inf->data+p3) - *(inf->data+p2));
  cp3x = *(xp+p2) + u*(*(xp+p3)- *(xp+p2));
  cp3y = *(yp+p2) + u*(*(yp+p3)- *(yp+p2));
  cp3z = *(zp+p2) + u*(*(zp+p3)- *(zp+p2));

/*  crossing point between p3 & p0  */
  u = (*thresh - *(inf->data + p3))/(*(inf->data+p0) - *(inf->data+p3));
  cp4x = *(xp+p3) + u*(*(xp+p0)- *(xp+p3));
  cp4y = *(yp+p3) + u*(*(yp+p0)- *(yp+p3));
  cp4z = *(zp+p3) + u*(*(zp+p0)- *(zp+p3));

/*  now, determine distances between cp1&cp2, cp1&cp4, cp2&cp3, cp3&cp4  */
  d12  = (cp1x - cp2x)*(cp1x - cp2x) + (cp1y - cp2y)*(cp1y - cp2y) +
         (cp1z - cp2z)*(cp1z - cp2z);
  d41  = (cp4x - cp1x)*(cp4x - cp1x) + (cp4y - cp1y)*(cp4y - cp1y) +
         (cp4z - cp1z)*(cp4z - cp1z);
  d23  = (cp2x - cp3x)*(cp2x - cp3x) + (cp2y - cp3y)*(cp2y - cp3y) +
         (cp2z - cp3z)*(cp2z - cp3z);
  d34  = (cp3x - cp4x)*(cp3x - cp4x) + (cp3y - cp4y)*(cp3y - cp4y) +
         (cp3z - cp4z)*(cp3z - cp4z);

/*  shortest distance determines which lines are drawn  */
  dir1 = d12;
  if (d34 < dir1) dir1 = d34;
  dir0 = d41;
  if (d23 < dir0) dir0 = d23;

  if (dir1 < dir0) return(1);
  return(0);
}

THRESHCROSS(v1,v2,thresh)
float *v1,*v2,*thresh;
{
  float t,d1,d2,r1,r2;

  t = *thresh;
  d1 = *v1;
  d2 = *v2;

  r1 = d1 - t;
  r2 = d2 - t;

  if ((r1 > 0.) && (r2 <= 0.))
    return(1);
  if ((r1 <= 0.) && (r2 > 0.))
    return(1);

  return(0);
}

hsv_to_rgb(R,G,B,h,s,v)
float *R,*G,*B;
float h,s,v;
{
  float f, p, q, t;
  float r, g, b;
  float ht;
  int i;

/*  Make sure not to trash the input colormap */
  ht = h;

  if (v == 0.) {
    r=0.;
    g=0.;
    b=0.;
  } else if (s == 0.) {
    r = v;
    g = v;
    b = v;
  } else {
    ht = ht * 6.0;
    if (ht >= 6.0) ht = 0.0;

    i = ht;
    f = ht - i;
    p = v*(1.0-s);
    q = v*(1.0-s*f);
    t = v*(1.0-s*(1.0-f));
      
    if (i == 0) {
      r = v;
      g = t;
      b = p;
    } else if (i == 1) {
      r = q;
      g = v;
      b = p;
    } else if (i == 2) {
      r = p;
      g = v;
      b = t;
    } else if (i == 3) {
      r = p;
      g = q;
      b = v;
    } else if (i == 4) {
      r = t;
      g = p;
      b = v;
    } else if (i == 5) {
      r = v;
      g = p;
      b = q;
    }
  }
  *R = r;
  *G = g;
  *B = b;
}

build_boundary_list(contour_obj,inf)
AVSfield_float *inf;
GEOMobj *contour_obj;
{
  int i, imax, jmax;
  int offset,delta;
  float shade[3];
  float verts[6];
  float *xp, *yp, *zp;

  imax = MAXX(inf);
  jmax = MAXY(inf);

  xp = inf->points;
  yp = xp + imax*jmax;
  zp = yp + imax*jmax;
  shade[0] = -1.0;

/* do boundary of v=0 */
  for (i=0;i<imax-1;i++) {
    verts[0] = *(xp+i);
    verts[1] = *(yp+i);
    verts[2] = *(zp+i);
    verts[3] = *(xp+i+1);
    verts[4] = *(yp+i+1);
    verts[5] = *(zp+i+1);
    ADD_SEGMENT(verts,shade,contour_obj);
  }
    
/* do boundary of v=1 */
  offset = imax*(jmax-1);
  for (i=0;i<imax-1;i++) {
    verts[0] = *(xp+offset+i);
    verts[1] = *(yp+offset+i);
    verts[2] = *(zp+offset+i);
    verts[3] = *(xp+offset+i+1);
    verts[4] = *(yp+offset+i+1);
    verts[5] = *(zp+offset+i+1);
    ADD_SEGMENT(verts,shade,contour_obj);
  }

/* do boundary of u=0 */
  offset = 0;
  delta = imax;
  for (i=0;i<jmax-1;i++,offset+=delta) {
    verts[0] = *(xp+offset);
    verts[1] = *(yp+offset);
    verts[2] = *(zp+offset);
    verts[3] = *(xp+offset+delta);
    verts[4] = *(yp+offset+delta);
    verts[5] = *(zp+offset+delta);
    ADD_SEGMENT(verts,shade,contour_obj);
  }

/* do boundary of u = 1 */
  offset = imax-1;
  delta = imax;
  for (i=0;i<jmax-1;i++,offset+=delta) {
    verts[0] = *(xp+offset);
    verts[1] = *(yp+offset);
    verts[2] = *(zp+offset);
    verts[3] = *(xp+offset+delta);
    verts[4] = *(yp+offset+delta);
    verts[5] = *(zp+offset+delta);
    ADD_SEGMENT(verts,shade,contour_obj);
  }
}

ADD_SEGMENT(verts,shade,obj)
float *verts,*shade;
GEOMobj *obj;
{
  float colors[6];

  if (shade[0] >= 0.) {
    colors[0] = colors[3] = shade[0];
    colors[1] = colors[4] = shade[1];
    colors[2] = colors[5] = shade[2];

    GEOMadd_polyline(obj,verts,colors,2,GEOM_COPY_DATA);
  } else {
    GEOMadd_polyline(obj,verts,GEOM_NULL,2,GEOM_COPY_DATA);
  }

/* Postscript output */
  if (slice > 0) {
     if (slice==1) 
        fprintf(pf,"\n%d %d moveto\n%d %d lineto",
            (int)((verts[0]-off1)*scale), (int)((verts[1]-off2)*scale),
            (int)((verts[3]-off1)*scale), (int)((verts[4]-off2)*scale) );
     if (slice==2) 
        fprintf(pf,"\n%d %d moveto\n%d %d lineto",
            (int)((verts[0]-off1)*scale), (int)((verts[2]-off2)*scale),
            (int)((verts[3]-off1)*scale), (int)((verts[5]-off2)*scale) );
     if (slice==3) 
        fprintf(pf,"\n%d %d moveto\n%d %d lineto",
            (int)((verts[1]-off1)*scale), (int)((verts[2]-off2)*scale),
            (int)((verts[4]-off1)*scale), (int)((verts[5]-off2)*scale) );
  }
}

make_irregular(infld, irfld)
AVSfield_float *infld, *irfld;
{
  int i,j;
  int imax, jmax;
  float z_val=0.;
  float *xpst, *ypst, *zpst, *data, *datain;

  imax = MAXX(irfld);
  jmax = MAXY(irfld);

  if (infld->uniform == RECTILINEAR) {
    xpst = irfld->points;
    ypst = xpst + imax*jmax;
    zpst = ypst + imax*jmax;

    data = irfld->data;
    datain = infld->data;

    for (j=0; j<jmax; j++) 
    for (i=0; i<imax; i++) 
      *xpst++ = infld->points[i] ;

    for (j=0; j<jmax; j++) 
    for (i=0; i<imax; i++) 
      *ypst++ = infld->points[imax+j] ;

    for (i=0; i<imax*jmax; i++) 
      *zpst++ = z_val ;

    for (i=0; i<imax*jmax; i++) 
      *data++ = *datain++;

  } else if (infld->uniform == UNIFORM) {
    xpst = irfld->points;
    ypst = xpst + imax*jmax;
    zpst = ypst + imax*jmax;

    data = irfld->data;
    datain = infld->data;

    for (j=0; j<jmax; j++)
    for (i=0; i<imax; i++) 
      *xpst++ = (float) (i);

    for (j=0; j<jmax; j++)
    for (i=0; i<imax; i++) 
      *ypst++ = (float) (j);

    for (i=0; i<imax*jmax; i++) 
      *zpst++ = z_val ;

    for (i=0; i<imax*jmax; i++) 
      *data++ = *datain++;
  }
  return(1);
}

field_get_minmax(data, n, minim, maxim)
float  *data;
  int  n;
float  *minim, *maxim;
{
  int   i;

  *minim = *maxim = data[0];
  for (i=0; i<n; i++) {
    if (data[i] < *minim)
      *minim = data[i];
    else if (data[i] > *maxim)
      *maxim = data[i];
  }
  return(1);
}

field_get_extend(data, n, lmax, lmin)
float  *data;
  int  n;
float  *lmax, *lmin;
{
  int   i;

  *lmax = data[0];
  *lmin = data[0];
  for (i=0; i<n; i++) {
    if (data[i] > *lmax)
      *lmax = data[i];
    if (data[i] < *lmin)
      *lmin = data[i];
  }
  return(1);
}


/*
 * initialise the module contained in this file
 */

int ((*data_mod_list[])()) = {
  cont2post,
};

#define NMODS sizeof(data_mod_list) / sizeof(char *) 

AVSinit_modules()
{
  AVSinit_from_module_list(data_mod_list, NMODS);
}
