C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C ****************************************
C  Module Specification
C ****************************************
       integer function ortho_spec()
       implicit none
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'

       integer in_port, out_port, param
       external ortho_compute
       integer ortho_compute

       call AVSset_module_name('crop and slice', 'mapper')
       call AVSset_module_flags(single_arg_data)

C	Input Port Specifications
       in_port=AVScreate_input_port('indata','field',REQUIRED)

C	Output Port Specifications
       out_port = AVScreate_output_port('outdata1', 'field')
       out_port = AVScreate_output_port('outdata2', 'field')

C	Parameter Specifications
       param = AVSadd_parameter('SHOW MASK (right port)','boolean',0,0,1
     $)
       call AVSconnect_widget(param,'toggle')
       call AVSadd_parameter_prop(param,'width', 'integer', 4)
       param = AVSadd_parameter('mode 1', 'choice', 'crop 1', 'crop 1.sl
     $ice 1','.')
       call AVSconnect_widget(param, 'radio_buttons')
       call AVSadd_parameter_prop(param, 'columns', 'integer', 2)
       param = AVSadd_parameter('dim 1 begin', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 1 end', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 1 center', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 1 width', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('mode 2', 'choice', 'crop 2', 'crop 2.sl
     $ice 2','.')
       call AVSconnect_widget(param, 'radio_buttons')
       call AVSadd_parameter_prop(param, 'columns', 'integer', 2)
       param = AVSadd_parameter('dim 2 begin', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 2 end', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 2 center', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 2 width', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('mode 3', 'choice', 'crop 3', 'crop 3.sl
     $ice 3','.')
       call AVSconnect_widget(param, 'radio_buttons')
       call AVSadd_parameter_prop(param, 'columns', 'integer', 2)
       param = AVSadd_parameter('dim 3 begin', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 3 end', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 3 center', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 3 width', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('mode 4', 'choice', 'crop 4', 'crop 4.sl
     $ice 4','.')
       call AVSconnect_widget(param, 'radio_buttons')
       call AVSadd_parameter_prop(param, 'columns', 'integer', 2)
       param = AVSadd_parameter('dim 4 begin', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 4 end', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 4 center', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')
       param = AVSadd_parameter('dim 4 width', 'integer', 1, 1, 1)
       call AVSconnect_widget(param, 'islider')

       call AVSset_compute_proc(ortho_compute)
C ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)
C <---- END OF USER-SUPPLIED CODE SECTION #2
       ortho_spec = 1
       return
       end

C ****************************************
C Module Compute Routine
C ****************************************
       integer function ortho_compute(indata, outdata1, outdata2, show,
     $ m1,b1,e1,c1,w1,m2,b2,e2,c2,w2,m3,b3,e3,c3,w3,m4,b4,e4,c4,w4)
       implicit none
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
       integer indata
       integer outdata1
       integer outdata2
       integer show
       integer b1,e1,c1,w1
       integer b2,e2,c2,w2
       integer b3,e3,c3,w3
       integer b4,e4,c4,w4
       CHARACTER*(*) m1,m2,m3,m4

C ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)

      INTEGER iresult
      INTEGER kernel_compute1, kernel_compute2
      EXTERNAL kernel_compute1, kernel_compute2
      INTEGER flags, colldim
      INTEGER i
      INTEGER offseti, offseto1, offseto2

C Input field 
      BYTE    bi(1)
      INTEGER ii(1)
      REAL*4  ri(1)
      REAL*8  di(1)
      INTEGER comdimi, dimsi(4), ifield, veclen
      INTEGER datatype
      INTEGER datasize
      EQUIVALENCE (bi,ii,ri,di)

C Output template
      INTEGER template

C Output field(s)
      INTEGER comdimo
      INTEGER ofield1
      INTEGER ofield2, dimso(4)
      BYTE    bo1(1),bo2(1)
      INTEGER io1(1),io2(1)
      REAL*4  ro1(1),ro2(1)
      REAL*8  do1(1),do2(1)
      EQUIVALENCE(bo1,io1,ro1,do1)
      EQUIVALENCE(bo2,io2,ro2,do2)

C Find dimensions and set dimension choices

      IF (AVSinput_changed('indata',1).GT.0) THEN

        comdimi = AVSfield_get_int(indata, avs_field_ndim)
        veclen  = AVSfield_get_int(indata, avs_field_veclen)
	datatype = AVSfield_get_int(indata, avs_field_type)
        iresult = AVSfield_get_dimensions(indata, dimsi)
	IF (datatype.EQ.0) THEN
	  datasize = 1
	ELSEIF (datatype.EQ.1) THEN
	  datasize = 4
	ELSEIF (datatype.EQ.2) THEN
	  datasize = 4
	ELSEIF (datatype.EQ.3) THEN
	  datasize = 8
	ENDIF

        flags = IOR(avs_minval, avs_maxval)
        CALL AVSmodify_parameter('dim 1 begin', flags,1,1,dimsi(1))
        CALL AVSmodify_parameter('dim 1 end',   flags,dimsi(1),1,dimsi(1
     $))
        CALL AVSmodify_parameter('dim 1 center',flags,dimsi(1)/2,1,dimsi
     $(1))
        CALL AVSmodify_parameter('dim 1 width', flags,dimsi(1),1,dimsi(1
     $))
        CALL AVSmodify_parameter('dim 2 begin', flags,1,1,dimsi(2))
        CALL AVSmodify_parameter('dim 2 end',   flags,dimsi(2),1,dimsi(2
     $))
        CALL AVSmodify_parameter('dim 2 center',flags,dimsi(2)/2,1,dimsi
     $(2))
        CALL AVSmodify_parameter('dim 2 width', flags,dimsi(2),1,dimsi(2
     $))
        CALL AVSmodify_parameter('dim 3 begin', flags,1,1,dimsi(3))
        CALL AVSmodify_parameter('dim 3 end',   flags,dimsi(3),1,dimsi(3
     $))
        CALL AVSmodify_parameter('dim 3 center',flags,dimsi(3)/2,1,dimsi
     $(3))
        CALL AVSmodify_parameter('dim 3 width', flags,dimsi(3),1,dimsi(3
     $))
        CALL AVSmodify_parameter('dim 4 begin', flags,1,1,dimsi(4))
        CALL AVSmodify_parameter('dim 4 end',   flags,dimsi(4),1,dimsi(4
     $))
        CALL AVSmodify_parameter('dim 4 center',flags,dimsi(4)/2,1,dimsi
     $(4))
        CALL AVSmodify_parameter('dim 4 width', flags,dimsi(4),1,dimsi(4
     $))

      ENDIF

C DIM 1

      IF (m1.EQ.'crop 1') THEN
        CALL AVSparameter_visible('dim 1 begin',1)
        CALL AVSparameter_visible('dim 1 end',1)
        CALL AVSparameter_visible('dim 1 width',1)
      ELSE
        CALL AVSparameter_visible('dim 1 begin',0)
        CALL AVSparameter_visible('dim 1 end',0)
        CALL AVSparameter_visible('dim 1 width',0)
      ENDIF
      IF (AVSparameter_changed('dim 1 begin').GT.0) THEN
	IF (b1.GT.e1) THEN
	  b1 = e1
	  c1 = b1
	  w1 = 1
	  CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 width' ,AVS_VALUE,w1,1,1)
	ELSE
	  c1 = (b1+e1)/2
	  w1 = e1 - b1 + 1
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 width' ,AVS_VALUE,w1,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 1 end').GT.0) THEN
	IF (e1.LT.b1) THEN
	  e1 = b1
	  c1 = b1
	  w1 = 1
	  CALL AVSmodify_parameter('dim 1 end',AVS_VALUE,e1,1,1)
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 width' ,AVS_VALUE,w1,1,1)
	ELSE
	  c1 = (b1+e1)/2
	  w1 = e1 - b1 + 1
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 width' ,AVS_VALUE,w1,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 1 center').GT.0) THEN
	IF (c1-((w1-1)/2).LT.1) THEN
	  c1 = 1 + ((w1-1)/2)
	  b1 = 1
	  e1 = w1 
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ELSEIF (c1+(w1/2).GT.dimsi(1)) THEN
	  c1 = dimsi(1) - (w1/2)
	  b1 = dimsi(1) - w1 + 1
	  e1 = dimsi(1)
          CALL AVSmodify_parameter('dim 1 center',AVS_VALUE,c1,1,1)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ELSE
	  b1 = c1 - ((w1-1)/2)
	  e1 = c1 + (w1/2)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 1 width').GT.0) THEN
	IF (c1-((w1-1)/2).LT.1) THEN
	  w1 = 2*c1 - 1
	  b1 = 1
	  e1 = w1
          CALL AVSmodify_parameter('dim 1 width',AVS_VALUE,w1,1,1)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ELSEIF (c1+(w1/2).GT.dimsi(1)) THEN
	  w1 = 2*(dimsi(1)-c1) + 1
	  b1 = dimsi(1) - w1 + 1
	  e1 = dimsi(1)
          CALL AVSmodify_parameter('dim 1 width',AVS_VALUE,w1,1,1)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ELSE
	  b1 = c1 - ((w1-1)/2)
	  e1 = c1 + (w1/2)
          CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
          CALL AVSmodify_parameter('dim 1 end'  ,AVS_VALUE,e1,1,1)
	ENDIF
      ENDIF

C DIM 2

      IF (comdimi.GE.2) THEN
      CALL AVSparameter_visible('mode 2',1)
      CALL AVSparameter_visible('dim 2 center',1)
      IF (m2.EQ.'crop 2') THEN
        CALL AVSparameter_visible('dim 2 begin',1)
        CALL AVSparameter_visible('dim 2 end',1)
        CALL AVSparameter_visible('dim 2 width',1)
      ELSE
        CALL AVSparameter_visible('dim 2 begin',0)
        CALL AVSparameter_visible('dim 2 end',0)
        CALL AVSparameter_visible('dim 2 width',0)
      ENDIF
      IF (AVSparameter_changed('dim 2 begin').GT.0) THEN
	IF (b2.GT.e2) THEN
	  b2 = e2
	  w2 = 1
	  c2 = e2
	  CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 width' ,AVS_VALUE,w2,1,1)
	ELSE
	  c2 = (b2+e2)/2
	  w2 = e2 - b2 + 1
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 width' ,AVS_VALUE,w2,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 2 end').GT.0) THEN
	IF (e2.LT.b2) THEN
	  e2 = b2
	  w2 = 1
	  c2 = b2
	  CALL AVSmodify_parameter('dim 2 end',AVS_VALUE,e2,1,1)
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 width' ,AVS_VALUE,w2,1,1)
	ELSE
	  c2 = (b2+e2)/2
	  w2 = e2 - b2 + 1
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 width' ,AVS_VALUE,w2,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 2 center').GT.0) THEN
	IF (c2-((w2-1)/2).LT.1) THEN
	  c2 = 1 + ((w2-1)/2)
	  b2 = 1
	  e2 = w2
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ELSEIF (c2+(w2/2).GT.dimsi(2)) THEN
	  c2 = dimsi(2) - (w2/2)
	  b2 = dimsi(2)-w2+1
	  e2 = dimsi(2)
          CALL AVSmodify_parameter('dim 2 center',AVS_VALUE,c2,1,1)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ELSE
	  b2 = c2 - ((w2-1)/2)
	  e2 = c2 + (w2/2)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 2 width').GT.0) THEN
	IF (c2-((w2-1)/2).LT.1) THEN
	  w2 = 2*c2 - 1
	  b2 = 1
	  e2 = w2
          CALL AVSmodify_parameter('dim 2 width',AVS_VALUE,w2,1,1)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ELSEIF (c2+(w2/2).GT.dimsi(2)) THEN
	  w2 = 2*(dimsi(2)-c2) + 1
	  b2 = dimsi(2)-w2+1
	  e2 = dimsi(2)
          CALL AVSmodify_parameter('dim 2 width',AVS_VALUE,w2,1,1)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ELSE
	  b2 = c2 - ((w2-1)/2)
	  e2 = c2 + (w2/2)
          CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
          CALL AVSmodify_parameter('dim 2 end'  ,AVS_VALUE,e2,1,1)
	ENDIF
      ENDIF
      ELSE
      CALL AVSparameter_visible('mode 2',0)
      CALL AVSparameter_visible('dim 2 begin',0)
      CALL AVSparameter_visible('dim 2 end',0)
      CALL AVSparameter_visible('dim 2 center',0)
      CALL AVSparameter_visible('dim 2 width',0)
      b2 = 1
      e2 = 1
      c2 = 1
      w2 = 1
      ENDIF

C DIM 3

      IF (comdimi.GE.3) THEN
      CALL AVSparameter_visible('mode 3',1)
      CALL AVSparameter_visible('dim 3 center',1)
      IF (m3.EQ.'crop 3') THEN
        CALL AVSparameter_visible('dim 3 begin',1)
        CALL AVSparameter_visible('dim 3 end',1)
        CALL AVSparameter_visible('dim 3 width',1)
      ELSE
        CALL AVSparameter_visible('dim 3 begin',0)
        CALL AVSparameter_visible('dim 3 end',0)
        CALL AVSparameter_visible('dim 3 width',0)
      ENDIF
      IF (AVSparameter_changed('dim 3 begin').GT.0) THEN
	IF (b3.GT.e3) THEN
	  b3 = e3
	  c3 = e3
	  w3 = 1
	  CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 width' ,AVS_VALUE,w3,1,1)
	ELSE
	  c3 = (b3+e3)/2
	  w3 = e3 - b3 + 1
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 width' ,AVS_VALUE,w3,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 3 end').GT.0) THEN
	IF (e3.LT.b3) THEN
	  e3 = b3
	  c3 = b3
	  w3 = 1
	  CALL AVSmodify_parameter('dim 3 end',AVS_VALUE,e3,1,1)
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 width' ,AVS_VALUE,w3,1,1)
	ELSE
	  c3 = (b3+e3)/2
	  w3 = e3 - b3 + 1
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 width' ,AVS_VALUE,w3,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 3 center').GT.0) THEN
	IF (c3-((w3-1)/2).LT.1) THEN
	  c3 = 1 + ((w3-1)/2)
	  b3 = 1
	  e3 = w3
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ELSEIF (c3+(w3/2).GT.dimsi(3)) THEN
	  c3 = dimsi(3) - (w3/2)
	  b3 = dimsi(3) - w3 + 1
	  e3 = dimsi(3)
          CALL AVSmodify_parameter('dim 3 center',AVS_VALUE,c3,1,1)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ELSE
	  b3 = c3 - ((w3-1)/2)
	  e3 = c3 + (w3/2)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 3 width').GT.0) THEN
	IF (c3-((w3-1)/2).LT.1) THEN
	  w3 = 2*c3 - 1
	  b3 = 1
	  e3 = w3
          CALL AVSmodify_parameter('dim 3 width',AVS_VALUE,w3,1,1)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ELSEIF (c3+(w3/2).GT.dimsi(3)) THEN
	  w3 = 2*(dimsi(3)-c3) + 1
	  b3 = dimsi(3) - w3 + 1
	  e3 = dimsi(3)
          CALL AVSmodify_parameter('dim 3 width',AVS_VALUE,w3,1,1)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ELSE
	  b3 = c3 - ((w3-1)/2)
	  e3 = c3 + (w3/2)
          CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
          CALL AVSmodify_parameter('dim 3 end'  ,AVS_VALUE,e3,1,1)
	ENDIF
      ENDIF
      ELSE
      CALL AVSparameter_visible('mode 3',0)
      CALL AVSparameter_visible('dim 3 begin',0)
      CALL AVSparameter_visible('dim 3 end',0)
      CALL AVSparameter_visible('dim 3 center',0)
      CALL AVSparameter_visible('dim 3 width',0)
      b3 = 1
      e3 = 1
      c3 = 1
      w3 = 1
      ENDIF

C DIM 4

      IF (comdimi.GE.4) THEN
      CALL AVSparameter_visible('mode 4',1)
      CALL AVSparameter_visible('dim 4 center',1)
      IF (m4.EQ.'crop 4') THEN
        CALL AVSparameter_visible('dim 4 begin',1)
        CALL AVSparameter_visible('dim 4 end',1)
        CALL AVSparameter_visible('dim 4 width',1)
      ELSE
        CALL AVSparameter_visible('dim 4 begin',0)
        CALL AVSparameter_visible('dim 4 end',0)
        CALL AVSparameter_visible('dim 4 width',0)
      ENDIF
      IF (AVSparameter_changed('dim 4 begin').GT.0) THEN
	IF (b4.GT.e4) THEN
	  b4 = e4
	  w4 = 1
	  c4 = e4
	  CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 width' ,AVS_VALUE,w4,1,1)
	ELSE
	  c4 = (b4+e4)/2
	  w4 = e4 - b4 + 1
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 width' ,AVS_VALUE,w4,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 4 end').GT.0) THEN
	IF (e4.LT.b4) THEN
	  e4 = b4
	  w4 = 1
	  c4 = b4
	  CALL AVSmodify_parameter('dim 4 end',AVS_VALUE,e4,1,1)
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 width' ,AVS_VALUE,w4,1,1)
	ELSE
	  c4 = (b4+e4)/2
	  w4 = e4 - b4 + 1
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 width' ,AVS_VALUE,w4,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 4 center').GT.0) THEN
	IF (c4-((w4-1)/2).LT.1) THEN
	  c4 = 1 + ((w4-1)/2)
	  b4 = 1
	  e4 = w4
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ELSEIF (c4+(w4/2).GT.dimsi(4)) THEN
	  c4 = dimsi(4) - (w4/2)
	  b4 = dimsi(4) - w4 + 1
	  e4 = dimsi(4)
          CALL AVSmodify_parameter('dim 4 center',AVS_VALUE,c4,1,1)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ELSE
	  b4 = c4 - ((w4-1)/2)
	  e4 = c4 + (w4/2)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ENDIF

      ELSEIF (AVSparameter_changed('dim 4 width').GT.0) THEN
	IF (c4-((w4-1)/2).LT.1) THEN
	  w4 = 2*c4 - 1
	  b4 = 1
	  e4 = w4
          CALL AVSmodify_parameter('dim 4 width',AVS_VALUE,w4,1,1)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ELSEIF (c4+(w4/2).GT.dimsi(4)) THEN
	  w4 = 2*(dimsi(4)-c4) + 1
	  b4 = dimsi(4) - w4 + 1
	  e4 = dimsi(4)
          CALL AVSmodify_parameter('dim 4 width',AVS_VALUE,w4,1,1)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ELSE
	  b4 = c4 - ((w4-1)/2)
	  e4 = c4 + (w4/2)
          CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
          CALL AVSmodify_parameter('dim 4 end'  ,AVS_VALUE,e4,1,1)
	ENDIF
      ENDIF
      ELSE
      CALL AVSparameter_visible('mode 4',0)
      CALL AVSparameter_visible('dim 4 begin',0)
      CALL AVSparameter_visible('dim 4 end',0)
      CALL AVSparameter_visible('dim 4 center',0)
      CALL AVSparameter_visible('dim 4 width',0)
      b4 = 1
      e4 = 1
      c4 = 1
      w4 = 1
      ENDIF

C If you slice a dimension, it must have width 1

      IF (m1.EQ.'slice 1'.AND.w1.GT.1) THEN
	w1 = 1
	b1 = c1
	e1 = c1
	CALL AVSmodify_parameter('dim 1 begin',AVS_VALUE,b1,1,1)
        CALL AVSmodify_parameter('dim 1 end',  AVS_VALUE,e1,1,1)
        CALL AVSmodify_parameter('dim 1 width',AVS_VALUE,w1,1,1)
      ENDIF
      IF (m2.EQ.'slice 2'.AND.w2.GT.1) THEN
	w2 = 1
	b2 = c2
	e2 = c2
	CALL AVSmodify_parameter('dim 2 begin',AVS_VALUE,b2,1,1)
        CALL AVSmodify_parameter('dim 2 end',  AVS_VALUE,e2,1,1)
        CALL AVSmodify_parameter('dim 2 width',AVS_VALUE,w2,1,1)
      ENDIF
      IF (m3.EQ.'slice 3'.AND.w3.GT.1) THEN
	w3 = 1
	b3 = c3
	e3 = c3
	CALL AVSmodify_parameter('dim 3 begin',AVS_VALUE,b3,1,1)
        CALL AVSmodify_parameter('dim 3 end',  AVS_VALUE,e3,1,1)
        CALL AVSmodify_parameter('dim 3 width',AVS_VALUE,w3,1,1)
      ENDIF
      IF (m4.EQ.'slice 4'.AND.w4.GT.1) THEN
	w4 = 1
	b4 = c4
	e4 = c4
	CALL AVSmodify_parameter('dim 4 begin',AVS_VALUE,b4,1,1)
        CALL AVSmodify_parameter('dim 4 end',  AVS_VALUE,e4,1,1)
        CALL AVSmodify_parameter('dim 4 width',AVS_VALUE,w4,1,1)
      ENDIF

C Make sure they all aren't slice (-=> a 0 dimensional field!)

      IF (m1.EQ.'slice 1'.AND.m2.EQ.'slice 2'.AND.
     +    m3.EQ.'slice 3'.AND.m4.EQ.'slice 4') THEN
	m1 = 'crop 1'
	CALL AVSmodify_parameter('mode 1',AVS_VALUE,m1,' ',' ')
      ENDIF

C Set up output #2 dimensions

      comdimo = 0
      IF (m1.EQ.'crop 1') THEN
	comdimo = comdimo + 1
	dimso(comdimo) = w1
      ENDIF
      IF (comdimi.GT.1.AND.m2.EQ.'crop 2') THEN
	comdimo = comdimo + 1
	dimso(comdimo) = w2
      ENDIF
      IF (comdimi.GT.2.AND.m3.EQ.'crop 3') THEN
	comdimo = comdimo + 1
	dimso(comdimo) = w3
      ENDIF
      IF (comdimi.GT.3.AND.m4.EQ.'crop 4') THEN
	comdimo = comdimo + 1
	dimso(comdimo) = w4
      ENDIF

C Make template for first output data (same size as indata)
      IF (show) THEN
        iresult = AVSfield_make_template(indata, template)
        if (outdata1 .ne. 0) call AVSfield_free(outdata1)
        outdata1 = AVSfield_alloc(template, dimsi)
	IF (datatype.EQ.0) THEN
          iresult = AVSfield_data_offset(outdata1, bo1, ofield1)
	ELSEIF (datatype.EQ.1) THEN
          iresult = AVSfield_data_offset(outdata1, io1, ofield1)
	ELSEIF (datatype.EQ.2) THEN
          iresult = AVSfield_data_offset(outdata1, ro1, ofield1)
	ELSEIF (datatype.EQ.3) THEN
          iresult = AVSfield_data_offset(outdata1, do1, ofield1)
	ENDIF
      ENDIF

C Make template for second output data
      iresult = AVSfield_make_template(indata, template)
      iresult = AVSfield_set_int(template, avs_field_ndim, comdimo)
      if (outdata2 .ne. 0) call AVSfield_free(outdata2)
      outdata2 = AVSfield_alloc(template, dimso)

      IF (datatype.EQ.0) THEN
        iresult = AVSfield_data_offset(indata, bi, ifield)
        iresult = AVSfield_data_offset(outdata2, bo2, ofield2)
      ELSEIF (datatype.EQ.1) THEN
        iresult = AVSfield_data_offset(indata, ii, ifield)
        iresult = AVSfield_data_offset(outdata2, io2, ofield2)
      ELSEIF (datatype.EQ.2) THEN
        iresult = AVSfield_data_offset(indata, ri, ifield)
        iresult = AVSfield_data_offset(outdata2, ro2, ofield2)
      ELSEIF (datatype.EQ.3) THEN
        iresult = AVSfield_data_offset(indata, di, ifield)
        iresult = AVSfield_data_offset(outdata2, do2, ofield2)
      ENDIF

      DO i = comdimi+1, 4
	dimsi(i) = 1
      ENDDO

      IF (show) THEN
	offseti  = 1+(ifield*datasize)
	offseto1 = 1+(ofield1*datasize)
        iresult = kernel_compute1(bi(offseti), bo1(offseto1),
     +              dimsi(1),dimsi(2),dimsi(3),dimsi(4),
     +              datasize*veclen,b1,e1,b2,e2,b3,e3,b4,e4)
      ELSE
	CALL AVSmark_output_unchanged('outdata1')
      ENDIF

      offseti =  1+(ifield*datasize)
      offseto2 = 1+(ofield2*datasize)
      iresult = kernel_compute2(bi(offseti), bo2(offseto2),
     +          dimsi(1),dimsi(2), dimsi(3), dimsi(4),
     +          datasize*veclen,w1,w2,w3,w4,b1,e1,b2,e2,b3,e3,b4,e4)
 
      ortho_compute = 1
      return
      end

C **********************************************************************
      INTEGER FUNCTION kernel_compute1(xi, xo, res1, res2, res3, res4,
     +                 veclen, b1,e1,b2,e2,b3,e3,b4,e4)
      IMPLICIT NONE
      INTEGER res1, res2, res3, res4, veclen
      BYTE  xi(veclen,res1,res2,res3,res4)
      BYTE  xo(veclen,res1,res2,res3,res4)
      INTEGER i,j,k,l,m
      INTEGER b1,e1,b2,e2,b3,e3,b4,e4

      DO l = 1, res4
	DO k = 1, res3
	  DO j = 1, res2
	    DO i = 1, res1
	      DO m = 1, veclen
		xo(m,i,j,k,l) = xi(m,i,j,k,l)
	      ENDDO
	    ENDDO
	  ENDDO
	ENDDO
      ENDDO

      DO l = b4, e4
	DO k = b3, e3
	  DO j = b2, e2
	    DO i = b1, e1
	      DO m = 1, veclen
		xo(m,i,j,k,l) = 0
	      ENDDO
	    ENDDO
	  ENDDO
	ENDDO
      ENDDO

      kernel_compute1 = 1
      return
      end
C **********************************************************************
 
C **********************************************************************
      INTEGER FUNCTION kernel_compute2(xi, xo, res1, res2, res3, res4,
     +                 veclen, reso1, reso2, reso3, reso4,
     +                 b1,e1,b2,e2,b3,e3,b4,e4)

      IMPLICIT NONE
      INTEGER res1, res2, res3, res4, veclen
      INTEGER reso1, reso2, reso3, reso4
      BYTE    xi(veclen,res1,res2,res3,res4)
      BYTE    xo(veclen,reso1,reso2,reso3,reso4)
      INTEGER i,j,k,l,m
      INTEGER ii,jj,kk,ll
      INTEGER b1,e1,b2,e2,b3,e3,b4,e4

      DO l = b4, e4
	ll = l+1-b4
	DO k = b3, e3
	  kk = k+1-b3
	  DO j = b2, e2
	    jj = j+1-b2
	    DO i = b1, e1
	      ii = i+1-b1
	      DO m = 1, veclen
		xo(m,ii,jj,kk,ll) = xi(m,i,j,k,l)
	      ENDDO
	    ENDDO
	  ENDDO
	ENDDO
      ENDDO

      kernel_compute2 = 1
      return
      end
C **********************************************************************
 
C **********************************************************************
C Initialization for modules contained in this file.
C **********************************************************************
       subroutine AVSinit_modules
C   IAC CODE CHANGE :        include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'

       external ortho_spec
       integer ortho_spec
       call AVSmodule_from_desc(ortho_spec)
       end

 
C ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)
C <---- END OF USER-SUPPLIED CODE SECTION #4
