/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* Module Name: "draw_tracks" (Mapper) (Subroutine)                      */
/* Author: John Tee                                                      */
/* Date Created: Wed Dec  2 11:45:28 1992                                */
/* extended by IanC, June 93
 *  for colormap on lines
 */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/udata.h>
#include <avs/colormap.h>
 
#define MAXTRACKS 200
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int draw_tracks_desc()
{

	int in_port, out_port, param;
	extern int draw_tracks_compute();

	AVSset_module_name("draw tracks", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input", "field float", 
		REQUIRED);

	in_port = AVScreate_input_port("pick information",
		        "struct upstream_geom", OPTIONAL | INVISIBLE);
	AVSset_input_class(in_port,"upstream_geom");

        in_port = AVScreate_input_port("Input Colormap",
                      "colormap", OPTIONAL );

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("tracks", "geom");
	param = AVSadd_parameter("info","string","","","");
	AVSadd_parameter_prop(param,"width","integer",4);

	AVSset_compute_proc(draw_tracks_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int draw_tracks_compute( input, pick_info, colormap, tracks, info)
	AVSfield_float *input;
	upstream_geom *pick_info;
        AVScolormap *colormap;
	GEOMedit_list *tracks;
	char *info;
{

GEOMobj *obj[MAXTRACKS], *sphere, *tether;
float *verts,* colors;
float *dataptr;
static float radius[1] = {0.02};
static float red[3] = {1.0, 0.0, 0.0};
static float yellow[3] = {1.0, 1.0, 0.0};
static float blue[3] = {0.0, 0.0, 1.0};
static float z_offset = 0.1;
int i,j,b,flags,npoints,ntracks,ndim,dims[10];
char trackname[50], message[20];
float *track_colors;
int    indexer;

/* write something in the text field */
	sprintf(message,"picked position");
	info = message;
	AVSmodify_parameter("info",AVS_VALUE,info,"","");

/* Interpret the input track field */
	ndim = AVSfield_get_int(input,AVS_FIELD_NDIM);
	AVSfield_get_dimensions(input,dims);
	npoints = dims[0];
	if(ndim > 1) ntracks = dims[1];
	else ntracks = 1;

/* allocate local storage */
        verts  = (float *) malloc ( sizeof(float) * npoints * 3 );
        colors = (float *) malloc ( sizeof(float) * npoints * 3 );


/* set up the colour mapping table 
 * use table driven color table for speed
 */
        if ( colormap )
        {
            track_colors = (float *)malloc(3 * sizeof(float) *
                            colormap->size);

            for (i = 0; i < colormap->size; i++)
            FILTERhsv_to_rgb (&(track_colors[i*3+0]),
                      &(track_colors[i*3+1]),
                      &(track_colors[i*3+2]),
                      colormap->hue[i],
                      colormap->saturation[i],
                      colormap->value[i]);
        }

/* Deal with upstream data */
	*tracks = GEOMinit_edit_list(*tracks);
	flags = BUTTON_DOWN;
	GEOMedit_selection_mode(*tracks, "%top", "notify", flags);
	if (pick_info != NULL) {
	   sprintf(message,"(%f,%f)\n",pick_info->vertex[0],
					pick_info->vertex[1]);
	   AVSmodify_parameter("info",AVS_VALUE,info,"","");
	}

/* Draw the tracks */
	for (j=0; j<ntracks; j++) {
	   obj[j] = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);
	   sprintf(trackname,"track%d",j);
	   dataptr = input->data + (input->veclen)*j*npoints;
	   for (i=0; i<npoints; i++) {
	      verts[i*3+0] = *(dataptr);
	      verts[i*3+1] = *(dataptr+1);
	      verts[i*3+2] = 0;
	      if ((pick_info != NULL) &&
	          (strncmp(trackname,pick_info->picked_obj,6) == 0))
	                for (b=0; b<3; b++) colors[i*3+b] = red[b];
	      else
              {
	          if ( colormap && input->veclen >= 3 )
                   map_data_to_colours ( 
                        colormap->lower, colormap->upper,
                        *( dataptr+2 ),
                        &colors[i*3+0],
                        &colors[i*3+1],
                        &colors[i*3+2],
                        track_colors );
                  else
                      /* make them all the same color */
                      for (b=0; b<3; b++) colors[i*3+b] = yellow[b];
              }
              dataptr += input->veclen;
	   }
	   GEOMadd_polyline(obj[j],verts,colors,npoints,GEOM_COPY_DATA);
	   GEOMedit_geometry(*tracks,trackname,obj[j]);
	}
/*
   Draw a sphere above the picked point, and join to the vertex with a line
*/
	if (pick_info != NULL) {
           verts[0*3+0] = pick_info->vertex[0];
           verts[0*3+1] = pick_info->vertex[1];
           verts[0*3+2] = z_offset;
           verts[1*3+0] = pick_info->vertex[0];
           verts[1*3+1] = pick_info->vertex[1];
           verts[1*3+2] = 0.0;
	   tether = GEOMcreate_obj(GEOM_POLYTRI,GEOM_NULL);
	   GEOMadd_disjoint_line(tether,verts,blue,2, GEOM_COPY_DATA);
	   GEOMedit_geometry(*tracks,"tether",tether);
	   sphere = GEOMcreate_sphere(GEOM_NULL,verts,radius,GEOM_NULL,
						GEOM_NULL,1,GEOM_COPY_DATA);
	   GEOMadd_float_colors(sphere,blue,1,GEOM_COPY_DATA);
	   GEOMedit_geometry(*tracks,"sphere",sphere);
	   GEOMdestroy_obj(tether);
	   GEOMdestroy_obj(sphere);
	}
	for (j=0; j<ntracks; j++) {
	   GEOMdestroy_obj(obj[j]);
	}


/* IAC CODE CHANGE :         if ( verts ) free ( verts ); */
        if ( verts )  free(verts );

/* IAC CODE CHANGE :         if ( colors ) free ( colors ); */
        if ( colors )  free(colors );


	return(1);
}
 

/*-----------------------------------------------------*
 *                                                     *
 *             ****  map_data_to_colours  ****         *
 *                                                     *
 *-----------------------------------------------------*/

map_data_to_colours ( vmin, vmax, val, red, green, blue,
                      track_colors )

float vmin;   /* range min */
float vmax;   /* range max */
float val;    /* input value to color */
float *red;   /* output color for sample */
float *green; /* output color for sample */
float *blue;  /* output color for sample */
float *track_colors; /* table */

{

  int index;
  float scale, offset;

  if (vmax != vmin)
    scale =  (float)( BYTE_TABLE - 1) / (vmax - vmin);
  else
    scale = 0.0;

  index = (int)((val - vmin) * scale);

  if ( index < 0 ) index = 0;
  else if ( index >= BYTE_TABLE ) index = BYTE_TABLE -1;

  *red      = track_colors[index * 3];
  *green    = track_colors[index * 3 + 1];
  *blue     = track_colors[index * 3 + 2];

}


/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	draw_tracks_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
