/*******************************************************************************
 *
 *  These are a set of utility FLOAT3 routines that can be used by 
 *  user-written AVS modules.
 *
 *	29 Mar 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	10 Jul 92  Phil McDonald		Add from_str.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Add one FLOAT3 to another.
 *
 */

void	UTILS_float3_add (pf3_1, pf3_2)

FLOAT3		pf3_1, pf3_2;
{

    if ((pf3_1 != NULL) && (pf3_2 != NULL))
    {
        pf3_1[0] += pf3_2[0], pf3_1[1] += pf3_2[1], pf3_1[2] += pf3_2[2];
    }

    return;
}



/*******************************************************************************
 *
 *  Check two FLOAT3s to see if they are the same.
 *
 */

int	UTILS_float3_are_same (p1, p2)

FLOAT3		p1, p2;

{

    if ((p1 == NULL) || (p2 == NULL)) return (FALSE);
    if (p1[0] != p2[0]) return (FALSE);
    if (p1[1] != p2[1]) return (FALSE);
    if (p1[2] != p2[2]) return (FALSE);

    return (TRUE);

}



/*******************************************************************************
 *
 *  Copy one FLOAT3 to another.
 *
 */

void	UTILS_float3_copy (p1, p2)

FLOAT3		p1, p2;
{

    if ((p1 != NULL) && (p2 != NULL)) 
        p2[0] = p1[0], p2[1] = p1[1], p2[2] = p1[2];

    return;
}



/*******************************************************************************
 *
 *  Divide one FLOAT3 by another.
 *
 */

void	UTILS_float3_div (pf3_1, pf3_2)

FLOAT3		pf3_1, pf3_2;
{

    if ((pf3_1 != NULL) && (pf3_2 != NULL))
    {
        pf3_1[0] /= pf3_2[0], pf3_1[1] /= pf3_2[1], pf3_1[2] /= pf3_2[2];
    }

    return;
}



/*******************************************************************************
 *
 *  Return the values of a FLOAT3.
 *
 */

void	UTILS_float3_get (p_f3, p_x, p_y, p_z)

FLOAT3		p_f3;
float		*p_x, *p_y, *p_z;
{

    if (p_f3 != NULL) *p_x = p_f3[0], *p_y = p_f3[1], *p_z = p_f3[2];

    return;
}



/*******************************************************************************
 *
 *  Read the values of a FLOAT3 from a string.
 *
 */

int	UTILS_float3_from_str (str, pf3)

char		*str;
FLOAT3		pf3;
{
    register int	i, j, n;
    int			nn;

    n = 0;

    for (i = 0; i < 3; i++) pf3[i] = 0.0;

    if (str != NULL)
    {
        for (i = j = nn = 0; i < 3; i++, j += nn)
            if (sscanf ((str+j), "%f%n", &pf3[i], &nn) == 1) n++;
    }


    return (n);
}



/*******************************************************************************
 *
 *  Multiply one FLOAT3 by another.
 *
 */

void	UTILS_float3_mul (pf3_1, pf3_2)

FLOAT3		pf3_1, pf3_2;
{

    if ((pf3_1 != NULL) && (pf3_2 != NULL))
    {
        pf3_1[0] *= pf3_2[0], pf3_1[1] *= pf3_2[1], pf3_1[2] *= pf3_2[2];
    }

    return;
}



/*******************************************************************************
 *
 *  Set the values of a FLOAT3.
 *
 */

void	UTILS_float3_set (x, y, z, pf3)

float		x, y, z;
FLOAT3		pf3;
{

    if (pf3 != NULL) pf3[0] = x, pf3[1] = y, pf3[2] = z;

    return;
}



/*******************************************************************************
 *
 *  Return the square root of the sums of the squares of a FLOAT3.
 *
 */

float	UTILS_float3_sqrt (pf3)

FLOAT3		pf3;
{

    if (pf3 == NULL) return (0.0);

    if ((pf3[0] == 0.0) && (pf3[1] == 0.0) && (pf3[2] == 0.0)) return (0.0);

    return (sqrt (((double) (pf3[0] * pf3[0])) + ((double) (pf3[1] * pf3[1])) +
                  ((double) (pf3[2] * pf3[2]))));
}



/*******************************************************************************
 *
 *  Subtract one FLOAT3 from another.
 *
 */

void	UTILS_float3_sub (pf3_1, pf3_2)

FLOAT3		pf3_1, pf3_2;
{

    if ((pf3_1 != NULL) && (pf3_2 != NULL))
    {
        pf3_1[0] -= pf3_2[0], pf3_1[1] -= pf3_2[1], pf3_1[2] -= pf3_2[2];
    }

    return;
}



/*******************************************************************************
 *
 *  Swap one FLOAT3 with another.
 *
 */

void	UTILS_float3_swap (pf3_1, pf3_2)

FLOAT3		pf3_1, pf3_2;
{

    FLOAT3	pf3_x;

    if ((pf3_1 != NULL) && (pf3_2 != NULL))
    {
        UTILS_float3_copy (pf3_1, pf3_x);
        UTILS_float3_copy (pf3_2, pf3_1);
        UTILS_float3_copy (pf3_x, pf3_2);
    }

    return;
}
