


#define		INTERP_FUZZ		1.0e-05



/******************************************************************************/

interp_bi (p_zin, nx, ny, xx, yy, p_zout)

float		*p_zin;
int		nx, ny;
float		xx, yy, *p_zout;
{
    register int	maxx, maxy, ix1, ix2, iy1, iy2, i1, i2, i3, i4;
    register double	x, y, dx, dy, z1, z2, dz;

    maxx = nx - 1, maxy = ny - 1;

    x = (xx < 0.0) ? 0.0 : (xx > maxx) ? maxx : xx;
    y = (yy < 0.0) ? 0.0 : (yy > maxy) ? maxy : yy;

    ix1 = ix2 = x, iy1 = iy2 = y;
    if (ix2 < maxx) ix2++;
    if (iy2 < maxy) iy2++;

    dx = x - (double) ix1, dy = y - (double) iy1;

    i1 = ix1 + (nx * iy1);
    i2 = ix2 + (nx * iy1);
    i3 = ix1 + (nx * iy2);
    i4 = ix2 + (nx * iy2);

    if ((dx <= INTERP_FUZZ) && (dy <= INTERP_FUZZ))

        *p_zout = p_zin[i1];

    else
    {
        dz = p_zin[i2] - p_zin[i1];
        z1 = p_zin[i1] + (dz * dx);

        dz = p_zin[i4] - p_zin[i3];
        z2 = p_zin[i3] + (dz * dx);

        dz = z2 - z1;

        *p_zout = z1 + (dz * dy);
    }


    return;
}



/******************************************************************************/

interp_tri (p_zin, nx, ny, xx, yy, p_zout, flag)

float		*p_zin;
int		nx, ny;
float		xx, yy, *p_zout;
int		flag;
{
    register int	maxx, maxy, ix1, ix2, iy1, iy2, i1, i2, i3, i4;
    register double	x, y, dx, dy, z1, z2, z3, z4, za, zb, zc;

    maxx = nx - 1, maxy = ny - 1;

    x = (xx < 0.0) ? 0.0 : (xx > maxx) ? maxx : xx;
    y = (yy < 0.0) ? 0.0 : (yy > maxy) ? maxy : yy;

    ix1 = ix2 = x, iy1 = iy2 = y;
    if (ix2 < maxx) ix2++;
    if (iy2 < maxy) iy2++;

    dx = x - (double) ix1, dy = y - (double) iy1;

    i1 = ix1 + (nx * iy1);
    i2 = ix2 + (nx * iy1);
    i3 = ix1 + (nx * iy2);
    i4 = ix2 + (nx * iy2);

    if ((dx <= INTERP_FUZZ) && (dy <= INTERP_FUZZ))

        *p_zout = p_zin[i1];

    else
    {
        if (flag > 0)
        {
            z1 = p_zin[i1];
            z2 = p_zin[i2];
            z3 = p_zin[i4];
            z4 = p_zin[i3];
        }
        else
        {
            z1 = dx, dx = 1.0 - dy, dy = z1;
            z1 = p_zin[i3];
            z2 = p_zin[i1];
            z3 = p_zin[i2];
            z4 = p_zin[i4];
        }

        if (dy <= dx)
            za = z1, zb = z2, zc = z3;
        else
            za = z3, zb = z4, zc = z1, dx = 1.0 - dx, dy = 1.0 - dy;

        z1 = za + ((zb - za) * dx);
        z2 = za + ((zc - za) * dx);

        *p_zout = z1 + ((z2 - z1) * (dy / dx));
    }


    return;
}
