/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* Copyright (C) 1993 by John Tee.  All Rights Reserved.		 */
/* Use, duplication or disclosure is prohibited                          */
/* unless authorised by John Tee.                                        */
/* Module Name: "irreg2map" (Mapper) (Subroutine)                        */
/* Author: John Tee                                                      */
/* Date Created: Sat Jan 23 11:14:46 1993                                */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#define COORD_X_2D(field, i, j) \
        ((field)->uniform == UNIFORM ? (i) : \
         (field)->uniform == RECTILINEAR ? (field)->points[(i)] : \
         (((field)->points)[ ((field)->dimensions[0] * (j)) + (i) ]))

#define COORD_Y_2D(field, i, j) \
        ((field)->uniform == UNIFORM ? (j) : \
         (field)->uniform == RECTILINEAR ? \
            (field)->points[(field)->dimensions[0] + (j)] : \
         (((field)->points)[ ((field)->dimensions[0] * \
                                 ((field)->dimensions[1] + (j))) + (i) ]))


/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int irreg2map_desc()
{

	int in_port, out_port, param, iresult;
	extern int irreg2map_compute();

	AVSset_module_name("irreg2map", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input", 
		"field 2D scalar irregular float", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output", 
		"field 2D 2-space uniform byte");

	/* Parameter Specifications                */
	param =
          AVSadd_parameter("Row/Col", "choice", "Column", "Row!Column", "!");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_parameter("Row/Col No", "integer", 0, 0, 500);
	AVSconnect_widget(param, "idial");
	param = AVSadd_float_parameter("Max Int", 50.0000, 0.00000, 100.000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Min Int", 50.0000, 0.00000, 100.000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("X step", 0.1, 0.01, 1.0);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Y step", 0.1, 0.01, 1.0);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("X start", -1.0, -1.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Y start", -1.0, -1.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("X stop", 1.0, -1.0, 1.0);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("Y stop", 1.0, -1.0, 1.0);
	AVSconnect_widget(param, "typein_real");

	AVSset_compute_proc(irreg2map_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int irreg2map_compute( input, output,  RC_choice, RC_No, Max_Int, Min_Int,
                       X_step, Y_step, X_start, Y_start, X_stop, Y_stop)
	AVSfield_float *input;
	AVSfield_char **output;
	float *X_step;
	float *Y_step;
	float *X_start;
	float *Y_start;
	float *X_stop;
	float *Y_stop;
	float *Max_Int;
	float *Min_Int;
	char *RC_choice;
	int RC_No;
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
  unsigned char *odptr;
  char  RC_char, text[30];
  int   i, j, ix, iy, size, status, dimso[2];
  float data_max, data_min, gain, x, y, val;
  float data_min_min, data_max_max, temp;
  float X_max, X_min, Y_max, Y_min;
  int AVS_ALL3 = AVS_VALUE | AVS_MINVAL | AVS_MAXVAL;
  RC_char = RC_choice[0];
/*
 * If input field has changed, set some dials to match the data
*/
  if(AVSinput_changed("input",0)) {
/*
 *	re-calculate max and min intensities and reset dials
 *	re-calculate range of coordinate values
*/
     data_max = X_max = Y_max = -1000.;
     data_min = X_min = Y_min = 1000.;
     for (j=0; j<MAXY(input); j++) {
        for (i=0; i<MAXX(input); i++) {
           if(I2D(input,i,j) > data_max) data_max = I2D(input,i,j);
           if(I2D(input,i,j) < data_min) data_min = I2D(input,i,j);
           if(COORD_X_2D(input,i,j) > X_max) X_max = COORD_X_2D(input,i,j);
           if(COORD_X_2D(input,i,j) < X_min) X_min = COORD_X_2D(input,i,j);
           if(COORD_Y_2D(input,i,j) > Y_max) Y_max = COORD_Y_2D(input,i,j);
           if(COORD_Y_2D(input,i,j) < Y_min) Y_min = COORD_Y_2D(input,i,j);
        }
     }
/* Round the values so that the widget labels are legible */
     sprintf(text,"%.2f",data_max);
     sscanf(text,"%f",&data_max);
     sprintf(text,"%.2f",data_min);
     sscanf(text,"%f",&data_min);
     sprintf(text,"%.2f",X_max);
     sscanf(text,"%f",&X_max);
     sprintf(text,"%.2f",X_min);
     sscanf(text,"%f",&X_min);
     sprintf(text,"%.2f",Y_max);
     sscanf(text,"%f",&Y_max);
     sprintf(text,"%.2f",Y_min);
     sscanf(text,"%f",&Y_min);
     data_min_min = 2 * data_min - data_max;
     data_max_max = 2 * data_max - data_min;
     AVSmodify_float_parameter
	("Min Int",AVS_ALL3, data_min, data_min_min, data_max);
     *Min_Int = data_min;
     AVSmodify_float_parameter
	("Max Int",AVS_ALL3, data_max, data_min, data_max_max);
     *Max_Int = data_max;
     AVSmodify_float_parameter ("X start",AVS_ALL3, X_min, X_min, X_max);
     *X_start = X_min;
     AVSmodify_float_parameter ("X stop",AVS_ALL3, X_max, X_min, X_max);
     *X_stop = X_max;
     AVSmodify_float_parameter ("Y start",AVS_ALL3, Y_min, Y_min, Y_max);
     *Y_start = Y_min;
     AVSmodify_float_parameter ("Y stop",AVS_ALL3, Y_max, Y_min, Y_max);
     *Y_stop = Y_max;
  }
/*
 * set the index dial to match the number of columns of input data
 */
  if ((AVSinput_changed("input",0)) || (AVSparameter_changed("Row/Col"))) {
     switch (RC_char) {
        case 'R':
        AVSmodify_parameter("Row/Col No",AVS_MAXVAL, NULL, NULL, MAXY(input));
        break;
        default:
        AVSmodify_parameter("Row/Col No",AVS_MAXVAL, NULL, NULL, MAXX(input));
        break;
     }
  }

/*
 * If resolution has changed, or output image does not exist, allocate it
 */
  if((AVSparameter_changed("X step")) || (AVSparameter_changed("Y step")) ||
     (AVSparameter_changed("X start")) || (AVSparameter_changed("Y start")) ||
     (AVSparameter_changed("X stop")) || (AVSparameter_changed("Y stop")) ||
     !(*output)) {
     dimso[0] = (int )((*X_stop - *X_start) / *X_step);
     dimso[1] = (int )((*Y_stop - *Y_start) / *Y_step);
     *output = (AVSfield_char *)
                AVSdata_alloc("field 2D 2-space uniform scalar byte",dimso);
     if (*output == NULL) {
        AVSerror("Alocation of output field failed.");
       return(0);
     }
  }

/*
 * Clear output image  and set intensity gain
 */
  size = dimso[0] * dimso[1];
  odptr = (unsigned char *)(*output)->data;
  for (i=0; i<size; i++) odptr[i] = 0;
  gain = (255. / (*Max_Int - *Min_Int));

  switch (RC_char) {
     case 'R':
/* For each element in this row ... */
        for (i=0; i< MAXX(input); i++) {
           x = COORD_X_2D(input, i, RC_No);
           if((x >= *X_start) && (x <= *X_stop)) {
              y = COORD_Y_2D(input, i, RC_No);
              if((y >= *Y_start) && (y <= *Y_stop)) {
                 val = (I2D(input, i, RC_No) - *Min_Int ) * gain;
                 if (val > 255) val = 255;
                 if (val < 0)   val = 0;
                 ix = (int )((x - *X_start) / *X_step);
                 iy = (int )((y - *Y_start) / *Y_step);
                 I2D(*output,ix,iy) = (unsigned char )val;
              }
           }
        }
     break;
     default:
/* For each element in this column ... */
        for (j=0; j< MAXY(input); j++) {
           x = COORD_X_2D(input, RC_No, j);
           if((x >= *X_start) && (x <= *X_stop)) {
              y = COORD_Y_2D(input, RC_No, j);
              if((y >= *Y_start) && (y <= *Y_stop)) {
                 val = (I2D(input, RC_No, j) - *Min_Int ) * gain;
                 if (val > 255) val = 255;
                 if (val < 0)   val = 0;
                 ix = (int )((x - *X_start) / *X_step);
                 iy = (int )((y - *Y_start) / *Y_step);
                 I2D(*output,ix,iy) = (unsigned char )val;
              }
           }
        }
     break;
  }

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	irreg2map_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
