/*******************************************************************************
 *
 *  These are a set of utility choice widget control routines that can be 
 *  used by user-written AVS modules.
 *
 *	10 Sep 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	04 Sep 92  Phil McDonald		Added text_file.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Return the set of choices from the choices file for the specified choice
 *  in the specified choices file.
 *
 */

char	*UTILS_choice_file_find (choices_file, choice)

char	*choices_file, *choice;
{
    register int	i, n;
    register char	str[256];
    register FILE	*file;

    if ((file = fopen (choices_file, "r")) == NULL) return (NULL);

    if (choice == NULL) return (NULL);

    n = 0;
    while ((i = fgetc (file)) != EOF)
    {
        str[n++] = i;
        if ((i == CHOICE_DELIMITER) || (i == '0'))
        {
            if (strncmp (str, choice, --n) == 0)
            {
                n = 0;
                while ((i = fgetc (file)) != '\n')
                    if (!isspace (i)) str[n++] = i;
                fclose (file);
            }
            else
            {
                while (fgetc (file) != '\n');
                n = 0;
            }
        }
    }
    str[n] = '\0';
    fclose (file);

    if (n <= 0) return (NULL);

    return (UTILS_choice_file_read (str));
}



/*******************************************************************************
 *
 *  Return the longest set of choices for all of the specified choices in the
 *  specified choices file.
 *
 */

char	*UTILS_choice_file_find_max (choices_file, choices)

char	*choices_file, *choices;
{
    register int	i, j, n, max;
    register char	*max_choices, *next_choices;

    max_choices = NULL;

    max = 0;
    i   = 0;
    while (i < strlen (choices))
    {
        j = i;
        while ((choices[j] != CHOICE_DELIMITER) && (choices[j] != '\0')) j++;
        if ((next_choices = UTILS_choice_file_find (choices_file, (choices+i)))
            != NULL)
        {
            n = strlen (next_choices);
            if (n > max)
            {
                if (max_choices != NULL) free (max_choices);
                max         = n;
                max_choices = next_choices;
            }
        }
        i = j + 1;
    }

    return (max_choices);
}



/*******************************************************************************
 *
 *  Return the set of choices in the specified choices file.
 *
 */

char	*UTILS_choice_file_read (choices_file)

char	*choices_file;
{
    register int	n;
    register char	*choices, chr;
    register FILE	*file;

    if ((file = fopen (choices_file, "r")) == NULL) return (NULL);

    n = 0;
    while ((chr = fgetc (file)) != EOF)
    {
        if (chr == CHOICE_DELIMITER) while (fgetc (file) != '\n');
        n++;
    }

    if ((choices = (char *) malloc (n)) != NULL)
    {
        rewind (file);
        n = 0;
        while ((chr = fgetc (file)) != EOF)
        {
            if (chr == CHOICE_DELIMITER) while (fgetc (file) != '\n');
            choices[n++] = chr;
        }
        choices[--n] = '\0';	/* Backup over last CHOICE_DELIMITER	*/
    }

    fclose (file);


    return (choices);
}



/*******************************************************************************
 *
 *  Set an AVS choice widget to the specified integer value.
 *
 */

void	UTILS_choice_int_set (parm_name, int_val)

char		*parm_name;
int		int_val;
{

    char		value_str[11];

    sprintf (value_str, "%d", int_val);

    AVSmodify_parameter (parm_name, AVS_VALUE, value_str, NULL, NULL);

    return;
}



/*******************************************************************************
 *
 *  Copy the contents of a file to a choice browser.
 *
 */

FILE	*UTILS_choice_text_file (p_file_name, parm_choices, choice, n_choices,
                                 err_msg, close)

char		**p_file_name, *parm_choices, *choice;
int		*n_choices;
char		*err_msg;
int		close;
{

    register int	nbytes, n, ichr;
    register char	*choices;
    register FILE	*file;

    *n_choices = 0;

    if ((file = UTILS_file_name_check (p_file_name, "r", err_msg)) == NULL)
    {
        if (choice != NULL) choice[0] = '\0';
        choices = (char *) calloc (1, 1);
    }
    else
    {
        fseek (file, 0L, 2);
        nbytes  = ftell (file);
        choices = (char *) calloc ((nbytes + 1), 1);

        rewind (file);
        n = 0;
        while ((ichr = fgetc (file)) != EOF)
        {
            if (ichr == '\n')
            {
                ichr = CHOICE_DELIMITER;
                (*n_choices)++;
            }
            choices[n++] = ichr;
        }
        choices[n] = '\0';


        if (close)
            fclose (file);
        else
            rewind (file);
    }

    AVSmodify_parameter (parm_choices, AVS_VALUE | AVS_MINVAL | AVS_MAXVAL,
                         choice, choices, CHOICE_DELIMITER_STR);


    return (file);
}
