/*******************************************************************************
 *
 *  Include file for use with AVS utility (UTILS) geometry routines.
 *
 *	20 Aug 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	16 Feb 93  Phil McDonald		Remove "norm" funcs.  Add
 *						freeze funcs.
 *
 ******************************************************************************/



#ifndef GEOM_H_STUFF

#define GEOM_H_STUFF



#define		GEOM_EDIT_GEOMETRY		0
#define		GEOM_EDIT_SET_MATRIX		1
#define		GEOM_EDIT_CONCAT_MATRIX		2
#define		GEOM_EDIT_COLOR			3
#define		GEOM_EDIT_RENDER_MODE		4
#define		GEOM_EDIT_VISIBILITY		5
#define		GEOM_EDIT_LIGHT			6
#define		GEOM_EDIT_PROPERTIES		7
#define		GEOM_EDIT_PARENT		8
#define		GEOM_EDIT_TRANSFORM_MODE	9
#define		GEOM_EDIT_SELECTION_MODE	10
#define		GEOM_EDIT_CENTER		11
#define		GEOM_EDIT_POSITION		12
#define		GEOM_EDIT_WINDOW		13
#define		GEOM_EDIT_TEXTURE		14
#define		GEOM_EDIT_PROJECTION		15

#define		GEOM_MAX_VERTS			200



float		*frozen_xform;
float		 frozen_mat[4][4];
float		*freeze_xform;
float		 freeze_mat[4][4];



void		 UTILS_geom_edlist_adopt ();
void		 UTILS_geom_edlist_delete ();
void		 UTILS_geom_edlist_name_set ();
void		 UTILS_geom_edlist_visibility_set ();
float		*UTILS_geom_freeze_check ();
void		 UTILS_geom_freeze_xyz ();
int		 UTILS_geom_polyline_add_pt ();
GEOMobj		*UTILS_geom_polyline_from_text_file ();
void		 UTILS_geom_polytri_tri_get ();



#endif GEOM_H_STUFF
