


#include	<stdio.h>
#include	"data_weave.h"


/*
 *  Reweave vector data that is sequential to interlaced or vice versa.
 */

unsigned char	*data_weave (p_data, n_data, n_vecs, n_byte, out_seq, free_old)

unsigned char	*p_data;
long		n_data;
int		n_vecs, n_byte, out_seq, free_old;
{

    register int		i, j, k, n_vec, n_byt;
    register long		n_dat, n_jmp;
    register unsigned char	*p_old, *p_out, *p_new, *p_tmp;

    if (p_data == NULL) return (p_data);
    if (n_data <=    1) return (p_data);
    if (n_vecs <=    1) return (p_data);
    if (n_byte <=    0) return (p_data);

    n_dat = n_data;
    n_vec = n_vecs;
    n_byt = n_byte;


    p_old = p_data;
    p_new = p_out = (unsigned char *) calloc ((n_dat * n_vec), n_byt);

    if (p_out != NULL)
    {
        n_jmp = (n_dat - 1) * n_byt;

        if (out_seq) /* Reweave from interlaced to sequential */
        {
           for (i = 0; i < n_dat; i++)
           {
               p_tmp = p_new;
               for (j = 0; j < n_vec; j++)
               {
                   for (k = 0; k < n_byt; k++) *(p_new++) = *(p_old++);

                   p_new += n_jmp;
               }
               p_new = p_tmp + n_byt;
           }
        }

        else /* Reweave from sequential to interlaced */
        {
           for (i = 0; i < n_dat; i++)
           {
               p_tmp = p_old;
               for (j = 0; j < n_vec; j++)
               {
                   for (k = 0; k < n_byt; k++) *(p_new++) = *(p_old++);

                   p_old += n_jmp;
               }
               p_old = p_tmp + n_byt;
           }
        }

        if (free_old) free (p_data);
    }


    return (p_out);
}
