/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/* mod_gen Version 1                                                     */
/* Module Name: "local_coord" (Mapper) (Subroutine)                      */
/* Author: John Stephen (Tessella) 0235-555511                           */
/* Date Created: Tue Nov  3 09:37:39 1992                                */

	/****************************************************/
	/* set up a local coordinate system for the control */
	/* of geometry such as a probe or cropper.          */ 
	/****************************************************/
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "template object" string REQUIRED                             */
/* input 1 "upstream tr" upstream_transform OPTIONAL | INVISIBLE         */
/* input 2 "target object" string REQUIRED                               */
/* output 0 "output matrix buf" string                                   */
/* param 2 "X centre" typein 0 -100 100                                  */
/* param 3 "Y centre" typein 0 -100 100                                  */
/* param 4 "Z centre" typein 0 -100 100                                  */
/* param 5 "Degrees in XY" dial 0 0 360                                  */
/* param 6 "Degrees in XZ" dial 0 0 360                                  */
/* param 7 "Degrees in YZ" dial 0 0 360                                  */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <time.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#define MEM_DEFS_ENABLE 1
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include <avs/udata.h>
 

 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int local_coord_desc()
{

	int in_port, out_port, param;
	extern int local_coord_compute();

	AVSset_module_name("local_coord", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("viewer", "string", REQUIRED);
	in_port = AVScreate_input_port("template object", "string", REQUIRED);
	in_port = AVScreate_input_port("target object", "string", REQUIRED);

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("X centre", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Y centre", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Z centre", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Degrees in XY", 0., 0., 360.);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Degrees in XZ", 0., 0., 360.);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Degrees in YZ", 0., 0., 360.);
	AVSconnect_widget(param, "dial");
	param = AVSadd_float_parameter("Move new X", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Move new Y", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Move new Z", 0., FLOAT_UNBOUND, FLOAT_UNBOUND);
	param = AVSadd_float_parameter("Scale", 1., 0.001, 1000.);

	AVSset_compute_proc(local_coord_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int local_coord_compute( 
	viewer, template_object, target_object, 
	X_centre, Y_centre, Z_centre, 
	Degrees_in_XY, Degrees_in_XZ, Degrees_in_YZ, 
	Move_new_X, Move_new_Y, Move_new_Z,
	Scale)


	char *viewer;
	char *template_object;
	char *target_object;
	float *X_centre;
	float *Y_centre;
	float *Z_centre;
	float *Degrees_in_XY;
	float *Degrees_in_XZ;
	float *Degrees_in_YZ;
	float *Move_new_X;
	float *Move_new_Y;
	float *Move_new_Z;
	float *Scale;
{
	char command[256], *output, *error, str[30];
	FILE *fp;
	float matrix[16];
	float *mp;
	float mat3x3[3][3];
	float newX;
	float newY;
	float newZ;
	float oldSum, newSum;
	int i,j,k;

	/****************************************************/
	/* set up a local coordinate system for the control */
	/* of geometry such as a probe or cropper.          */ 
	/****************************************************/


	/* set the view */
	sprintf(command,"geom_set_scene -module %s\n",viewer);
	AVScommand("kernel",command,&output,&error);

	/* reset the target object */
	sprintf(command,"geom_reset -object %s \n ",target_object);
	AVScommand("kernel",command,&output,&error);

	/* get the global transformation matrix of  */
	/* the template object; output it to a file *
	sprintf(command,"geom_get_matrix -object %s ", template_object); 
	AVScommand("kernel",command,&output,&error);

	/* read the matrix from the file and use it as the */
	/* basis for the target object matrix              */
	for(i=0, mp= &(matrix[0]); i<16; i++, mp++)sscanf(output,"%f",mp);
	sprintf(command,"geom_set_matrix -object %s -mat 1. 0. 0. 0.  0. 1. 0. 0.  0. 0. 1. 0.  0. 0. 0. 1.  ",target_object);
	AVScommand("kernel",command,&output,&error);

	/* translation to the new local origin       */
	sprintf(command,"geom_concat_matrix -object %s -tx %f ",target_object,*X_centre);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -ty %f ",target_object,*Y_centre);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -tz %f ",target_object,*Z_centre);
	AVScommand("kernel",command,&output,&error);

	/* now rotate the new local coordinates */
	sprintf(command,"geom_concat_matrix -object %s -rx %f ",target_object,*Degrees_in_YZ);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -ry %f ",target_object,*Degrees_in_XZ);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -rz %f ",target_object,*Degrees_in_XY);
	AVScommand("kernel",command,&output,&error);


	/* now advance along the new Z; calculate the new Z vector via the target 4x4 */
	/* begin by getting hold of the matrix */
	sprintf(command,"geom_get_matrix -object %s ", target_object); 
	AVScommand("kernel",command,&output,&error);
	for(i=0, mp= &(matrix[0]); i<16; i++, mp++)sscanf(output,"%f",mp);
	mat3x3[0][0] = matrix[0];	mat3x3[0][1] = matrix[1];	mat3x3[0][2] = matrix[2];
	mat3x3[1][0] = matrix[4];	mat3x3[1][1] = matrix[5];	mat3x3[1][2] = matrix[6];
	mat3x3[2][0] = matrix[8];	mat3x3[2][1] = matrix[9];	mat3x3[2][2] = matrix[10];
	newX =    (*Move_new_X * mat3x3[0][0]) 
		+ (*Move_new_Y * mat3x3[1][0]) 
		+ (*Move_new_Z * mat3x3[2][0]);
	newY =    (*Move_new_X * mat3x3[0][1]) 
		+ (*Move_new_Y * mat3x3[1][1]) 
		+ (*Move_new_Z * mat3x3[2][1]);
	newZ =    (*Move_new_X * mat3x3[0][2]) 
		+ (*Move_new_Y * mat3x3[1][2]) 
		+ (*Move_new_Z * mat3x3[2][2]);
	oldSum = *Move_new_X + *Move_new_Y + *Move_new_Z;
	newSum = newX + newY + newZ;
	if(newSum > 0.00001) {
		newX = newX * oldSum / newSum;
		newY = newY * oldSum / newSum;
		newZ = newZ * oldSum / newSum;
	}
	sprintf(command,"geom_concat_matrix -object %s -tx %f ",target_object,newX);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -ty %f ",target_object,newY);
	AVScommand("kernel",command,&output,&error);
	sprintf(command,"geom_concat_matrix -object %s -tz %f ",target_object,newZ);
	AVScommand("kernel",command,&output,&error);

	/* now rescale the probe */
	sprintf(command,"geom_concat_matrix -object %s -sxyz %f ", target_object, *Scale);
	AVScommand("kernel",command,&output,&error);

	/* set the CLI's current object to "top" */
	sprintf(command,"geom_set_cur_cli_obj \"top\" \n");
	AVScommand("kernel",command,&output,&error);
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	local_coord_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
