/*******************************************************************************
 *
 *  Include file for use with AVS utility (UTILS) fld_file routines.
 *
 *	29 May 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#ifndef FLD_FILE_H_STUFF

#define FLD_FILE_H_STUFF



#define		FLD_FILE_MAX_DIMS		10

#define		FLD_FILE_HDR_OK			0
#define		FLD_FILE_HDR_COMMENT		1
#define		FLD_FILE_HDR_END		2

#define		FLD_FILE_HDR_DATA_N		5
#define		FLD_FILE_HDR_DATA_L             8
#define		FLD_FILE_HDR_DATA_BYTE		0
#define		FLD_FILE_HDR_DATA_INTEGER	1
#define		FLD_FILE_HDR_DATA_FLOAT		2
#define		FLD_FILE_HDR_DATA_REAL		3
#define		FLD_FILE_HDR_DATA_DOUBLE	4

#define		FLD_FILE_HDR_GRID_N		3
#define		FLD_FILE_HDR_GRID_L		12
#define		FLD_FILE_HDR_GRID_UNIFORM	0
#define		FLD_FILE_HDR_GRID_RECTILINEAR	1
#define		FLD_FILE_HDR_GRID_IRREGULAR	2

#define		FLD_FILE_HDR_PARM_N		7
#define		FLD_FILE_HDR_PARM_L		7
#define		FLD_FILE_HDR_PARM_NDIM		0
#define		FLD_FILE_HDR_PARM_DIM		1
#define		FLD_FILE_HDR_PARM_NSPACE	2
#define		FLD_FILE_HDR_PARM_VECLEN	3
#define		FLD_FILE_HDR_PARM_DATA		4
#define		FLD_FILE_HDR_PARM_FIELD		5
#define		FLD_FILE_HDR_PARM_POINTS	6



AVSfield	*UTILS_fld_file_read ();
unsigned char	*UTILS_fld_file_read_bin ();
unsigned char	*UTILS_fld_file_read_dat ();
AVSfield	*UTILS_fld_file_read_hdr();
int		 UTILS_fld_file_read_hdr_atom_get ();
int		 UTILS_fld_file_read_hdr_line ();
int		 UTILS_fld_file_read_hdr_match ();
float		*UTILS_fld_file_read_pts ();
float		*UTILS_fld_file_read_pts_check ();
float		*UTILS_fld_file_read_pts_file ();



static char	fld_file_hdr_data[FLD_FILE_HDR_DATA_N][FLD_FILE_HDR_DATA_L] = 
						{"byte",
						 "integer",
						 "float",
						 "real",
						 "double"};

static char	fld_file_hdr_grid[FLD_FILE_HDR_GRID_N][FLD_FILE_HDR_GRID_L] =
						{"uniform",
						 "rectilinear",
						 "irregular"};

static char	fld_file_hdr_parm[FLD_FILE_HDR_PARM_N][FLD_FILE_HDR_PARM_L] =
						{"ndim",
						 "dim",
						 "nspace",
						 "veclen",
						 "data",
						 "field",
                                                 "points"};

static int	fld_file_hdr_type[FLD_FILE_HDR_DATA_N] =
						 {AVS_TYPE_BYTE,
						  AVS_TYPE_INTEGER,
						  AVS_TYPE_REAL,
						  AVS_TYPE_REAL,
						  AVS_TYPE_DOUBLE};



#endif FLD_FILE_H_STUFF
