#include	"clip.h"



int	clip_init (xmin, ymin, xmax, ymax)

float		xmin, ymin, xmax, ymax;
{

    clip_xmin = xmin;
    clip_ymin = ymin;
    clip_xmax = xmax;
    clip_ymax = ymax;


    return (CLIP_OK);
}




int	clip_stat (xyz)

float		xyz[3];
{

    register int	xstat, ystat;

    xstat = (xyz[0] < clip_xmin) ? CLIP_PTX_LO :
            (xyz[0] > clip_xmax) ? CLIP_PTX_HI : CLIP_OK;

    ystat = (xyz[1] < clip_ymin) ? CLIP_PTY_LO :
            (xyz[1] > clip_ymax) ? CLIP_PTY_HI : CLIP_OK;


    return (xstat | ystat);
}




int	clip_line (xyz0, xyz1)

float		xyz0[3], xyz1[3];
{

    register int	i, pt_stat[2], line_stat, moved;
    register float	xyz[2][3], *pt_xyz[2], x, y, abc[3];

    for (i = 0; i < 3; i++) xyz[0][i] = xyz0[i], xyz[1][i] = xyz1[i];
    pt_xyz[0] = &xyz[0][0], pt_xyz[1] = &xyz[1][0];

    pt_stat[0] = clip_stat (pt_xyz[0]);
    pt_stat[1] = clip_stat (pt_xyz[1]);

    line_stat  = CLIP_OK;
    if (pt_stat[0] == CLIP_OK) line_stat |= CLIP_LINE_PT1_IN;
    if (pt_stat[1] == CLIP_OK) line_stat |= CLIP_LINE_PT2_IN;
    if (line_stat  == CLIP_OK) line_stat = CLIP_LINE_OUT;

    if (line_stat != CLIP_LINE_IN)
    {

        if (!line_2d_eqn (pt_xyz[0], pt_xyz[1], abc)) return (line_stat);

        moved = 0;
        while ((pt_stat[0] != pt_stat[1]) && ((pt_stat[0] & pt_stat[1]) == 0))
        {
            i = (pt_stat[0] != CLIP_OK) ? 0 : 1;

            moved = (i == 0) ? moved | 1 : moved | 2;

            if ((pt_stat[i] & CLIP_PTX_MASK) != 0)
            {
                x = ((pt_stat[i] & CLIP_PTX_LO) != 0) ? clip_xmin : clip_xmax;
                y = (abc[1] == 0.0) ? xyz[i][1] :
                                      -(abc[2] + (abc[0] * x)) / abc[1];
            }
            else
            {
                y = ((pt_stat[i] & CLIP_PTY_LO) != 0) ? clip_ymin : clip_ymax;
                x = (abc[0] == 0.0) ? xyz[i][0] :
                                      -(abc[2] + (abc[1] * y)) / abc[0];
            }
            xyz[i][0] = x, xyz[i][1] = y;

            pt_stat[i] = clip_stat (pt_xyz[i]);
        }

        if (moved | 1)
            xyz0[0] = xyz[0][0], xyz0[1] = xyz[0][1], xyz0[2] = xyz[0][2];

        if (moved | 2)
            xyz1[0] = xyz[1][0], xyz1[1] = xyz[1][1], xyz1[2] = xyz[1][2];

        if (moved == 3) line_stat = CLIP_LINE_IN_OUT;

    }


    return (line_stat);
}
