/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce matrixop.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  matrixop.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  matrixop.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     matrixop.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
matrixop.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>

#include "defs.h"
#include "stuff.h"

extern double sqrt();

Flt VecLen(A)
Vec A; 
{
   double x;
   x = A[0]*A[0] + A[1]*A[1] + A[2]*A[2];
   x = sqrt(x);
   return(x); 
}

Flt VecDot(a,b)
Vec a,b;
{
   return(a[0]*b[0] + a[1]*b[1] + a[2]*b[2]);
}

void
VecCopy(a,b)
Vec a,b;
{
   b[0] = a[0];
   b[1] = a[1];
   b[2] = a[2];
}

void
VecAdd(a,b,c)
Vec a,b,c;
{
   c[0] = a[0] + b[0];
   c[1] = a[1] + b[1];
   c[2] = a[2] + b[2];
}

void
VecSub(a,b,c)
Vec a,b,c;
{
   c[0] = a[0] - b[0];
   c[1] = a[1] - b[1];
   c[2] = a[2] - b[2];
}

void
VecComb(a,A,b,B,C)
Flt a,b;
Vec A,B,C;
{
   C[0] = a*A[0] + b*B[0];
   C[1] = a*A[1] + b*B[1];
   C[2] = a*A[2] + b*B[2];
}

void
VecAddS(a,A,B,C)
Flt a;
Vec A,B,C;
{
   C[0] = a*A[0] + B[0];
   C[1] = a*A[1] + B[1];
   C[2] = a*A[2] + B[2];
}


Flt 
VecUnit(A,B)
Vec A,B;
{
   Flt x;
   x = VecLen(A);
   x = 1/x;
   B[0] = A[0]* x;
   B[1] = A[1]* x;
   B[2] = A[2]* x;
   return(x);
}

void
make_identity_matrix(m)
Matrix m;
{
   register int i,j;

   for (i=0;i<4;i++)
      for (j=0;j<4;j++)
	 if (i==j)
	    m[i][j] = 1.0;
	 else
	    m[i][j] = 0.0;
}

void
VecNegate(A,B)
Flt *A, *B;
{
   register int i;

   for (i=0;i<3;i++)
      *B++ = *A++ * -1.0;
}

void
VecCrossProd(A,B,C)
Vec A,B,C;
{
   C[0] = A[1]*B[2] - A[2]*B[1];
   C[1] = A[2]*B[0] - A[0]*B[2];
   C[2] = A[0]*B[1] - A[1]*B[0];
}
