/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce new_abuffer.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  new_abuffer.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  new_abuffer.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     new_abuffer.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
new_abuffer.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/


/**
  *  this file contains the routines necessary to interface the
  *  new abuffer code into the avs environment.
**/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/colormap.h>
#include "defs.h"

AVSinit_modules()
{
    int new_abuffer();
    AVSmodule_from_desc(new_abuffer);
}

new_abuffer()
{
    int new_abuffer_compute();
    int p,inp,outp;

    AVSset_module_name("new abuffer",MODULE_MAPPER);
    inp = AVScreate_input_port("input field","field 3D 4-vector byte",REQUIRED);
    outp = AVScreate_output_port("output image","field 2D 4-vector float");
    AVSautofree_output(outp);

    p=AVSadd_parameter("dummy1","string","Volume Transformations","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p = AVSadd_float_parameter("X Rotation",0.,-360.,360.);
    p = AVSadd_float_parameter("Y Rotation",0.,-360.,360.);
    p = AVSadd_float_parameter("Z Rotation",0.,-360.,360.);
    p = AVSadd_float_parameter("Scale",1.,0.,4.0);

    p = AVSadd_parameter("dummy2","string","Image Size","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("Image Size","integer",128,32,1024);

    p = AVSadd_parameter("dummy3","string","Antialias Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("AntialiasOpts","choice","off","off!on","!");
    AVSconnect_widget(p,"radio buttons");
    
    p = AVSadd_parameter("dummy4","string","Projection Type","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p=AVSadd_parameter("ProjectionOpts","choice","parallel","parallel!perspective","!");
    AVSconnect_widget(p,"radio buttons");

    p = AVSadd_parameter("dummy5","string","Hull Rendering Options","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    p = AVSadd_parameter("RenderingOpts","choice","volume only","volume only!hull only!volume & hull","!");
    AVSconnect_widget(p,"radio buttons");
    AVSset_compute_proc(new_abuffer_compute);

}

static char fname[64];
static char BASE_FILENAME[] = {"/tmp/avs_new_abuf.XXXXXX"};

new_abuffer_compute(inf,of,dummy1,xr,yr,zr,scale,
		    dummy2,img_size,
		    dummy3,antialias_choice,
		    dummy4,projection_choice,
		    dummy5,rendering_mode)
AVSfield_char *inf;
AVS_IMAGE_FIELD **of;
float *xr,*yr,*zr,*scale;
int img_size;
char *rendering_mode;
char *antialias_choice;
char *projection_choice;
char *dummy1,*dummy2,*dummy3,*dummy4,*dummy5;
{
    AVSfield_char template;
    int dims[8];
    int input_dims[3];
    unsigned char *volume_data;
    IMAGE_TYPE *image_data;
    FILE *f;
    int render_choice = AVSchoice_number("RenderingOpts",rendering_mode);
    int antialias_flag = AVSchoice_number("AntialiasOpts",antialias_choice);
    int projection_type = AVSchoice_number("ProjectionOpts",projection_choice);
    int do_hull,do_volume;
    int anti,persp;
    
    render_choice--;
    /** NOTE:
      * for render_choice:
      * 0 = volume only,
      * 1 = hull only,
      * 2 = volume and hull together.


    **/

    if (render_choice == 0)  /* volume only */
    {
	do_hull = 0;
	do_volume = 1;
    }
    else if (render_choice == 1)  /* hull only */
    {
	do_hull = 1;
	do_volume = 0;
    }
    else /* assume hull and volume */
    {
	do_hull = do_volume = 1;
    }

    /**
      * for antialiasing, if antialias_flag == 0, then don't do it.
    **/
    anti = antialias_flag-1;


    /**
      * persp (0=parallel,1=perspective) is indicate the type of
      * projection the user has requested. at the lowest level in
      * this module, the raytracer/compositer doesn't care.  what
      * we do is transform the faces which bound the volume using
      * a perspective transformation.  the volume data "fills" the
      * void within the bounding hull, so it doesn't matter if
      * the hull reflects a parallel or perspective projection.
    **/
    persp = projection_type - 1;
    
    /* take care of output field */
    if (*of != NULL)
	AVSfield_free(*of);

    memset((char *)&template,0,sizeof(AVSfield_char));
    
    template.ndim = 2;
    template.nspace = 0;
    template.veclen = 4;
    template.type = IMAGE_TYPE_AVS;
    template.size = sizeof(IMAGE_TYPE);
    template.uniform = UNIFORM;
    
    dims[0] = dims[1] = img_size;
    *of = (AVS_IMAGE_FIELD *)AVSfield_alloc(&template,dims);
    clear_imgbuf((*of)->data,img_size,img_size);

    /* generate bounding volume polygon list for raytracer */
    /* create a temporary file which will hold the polygon list
       defining the bounding hull of the volume */

    if ((f=tmpfile())==NULL)
    {
	AVSerror("Can't open temporary file %s.\n",fname);
	return(0);
    }
    build_volume_faces(xr,yr,zr,scale,inf->dimensions,f,persp);

    rewind(f);

    volume_data = inf->data;
    image_data = (*of)->data;
    
    if (do_volume == 1)
	raytrace_volume(volume_data,image_data,anti,(*of)->dimensions,inf->dimensions,f);

    if (do_hull)
    {
	rewind(f);
	render_hull(*of,f,anti);
    }

    fclose(f);
    return(1);
}

clear_imgbuf(img,xwidth,yheight)
IMAGE_TYPE *img;
int xwidth,yheight;
{
    register IMAGE_TYPE *d,data=0.;
    register int cnt,i;

    d = img;
    cnt = xwidth * yheight * 4;
    for (i=0;i<cnt;i++)
	*d++ = data;
}

