/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce screen.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  screen.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  screen.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     screen.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
screen.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "defs.h"
#include "stuff.h"

#define min(a,b) (((a) < (b)) ? (a) : (b))
static IMAGE_TYPE pbuf[4*1024];  /* allows for up to 1k scanlines */
static double perturb_scale;

void
screen(imgdata,display,anti)
IMAGE_TYPE *imgdata;
DISPLAY *display;
int anti; /* if nonzero, indicates number of samples/pix to shoot */
{
   int xstart, xend, ystart, yend;
   register int x,y;
   Color color;
   Ray RAY;
   Ray *r = &RAY;
   static void make_ray();
   void trace();
   static void loadpbuf();
   Flt X,Y,dX,dY;
   extern long random();
   Vec over_samples[MAXANTI];
#ifdef AVS3
   double percent,dp;
   int ipercent;
#endif

   load_table_indeces();
   
   r->P[0] = 0.0;
   r->P[1] = 0.0;
   r->P[2] = -3.0;   /* same origin for all rays. */
   r->D[2] = 1.0;   /* all origin rays shoot in +z direction */

   xstart = 0;
   xend = display->xres;
   ystart = 0;
   yend = display->yres;
   dX = 2.0/(Flt)(display->xres-1);
   dY = 2.0/(Flt)(display->yres-1);
   perturb_scale = dX;
   
#ifdef AVS3
   percent = 0.0;
   dp = 1./(double)(yend - ystart + 1);
   ipercent = 0;
   AVSmodule_status("New Abuffer : Running",ipercent);
#endif

   for (y=yend-1;y>=ystart;y--)
   {
       Y = ((Flt)y +0.5) * dY - 1.0;
       for (x=xstart;x<xend;x++)
       {
	   X = ((Flt)x + 0.5) * dX - 1.0;
	   make_ray(X,Y,r);	/* shoot ray in middle of pixel */
	   trace(0, 1., r, color,anti);
	   loadpbuf(&pbuf[0],color,x);
      }
      dump_pbuf(imgdata,pbuf,(int)(display->xres)); 
      imgdata += (display->xres * 4);
#ifdef AVS3
      percent += dp;
      ipercent = (int)(percent * 100.0);
      AVSmodule_status("New Abuffer : Running",ipercent);
#endif
   }
   free_table_indeces();
}

dump_pbuf(imgdata,pbuf,xval)
unsigned char *imgdata;
int xval;
char *pbuf;
{
    memcpy((char *)imgdata,pbuf,xval*4*sizeof(IMAGE_TYPE));
}

static void
make_ray(x,y,r)
Flt x,y;
Ray *r;
{
   Vec j;

   j[0] = x;
   j[1] = y;
   j[2] = 2.0;
   VecUnit(j,r->D);
}

static void
loadpbuf(pbuf,color,x)
IMAGE_TYPE pbuf[];
Color color;
int x;
{
#if 0
    extern int halfXres;
   x = x + halfXres;
#endif
   x = x<<2;
   pbuf[x++] = color[0];
   pbuf[x++] = color[1];
   pbuf[x++] = color[2];
   pbuf[x++] = color[3];
}

perturb_ray(r,new_ray)
Ray *r,*new_ray;
{
    double drand48();
    double new_x,new_y;

    new_x = drand48()-0.5;
    new_y = drand48()-0.5;

    /* these numbers are in the range [-0.5..0.5) */
    new_x *= perturb_scale;
    new_y *= perturb_scale;

    *new_ray = *r;
    
    new_ray->D[0] = r->D[0]+new_x;
    new_ray->D[1] = r->D[1]+new_y;

}
