/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce shade.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  shade.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  shade.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     shade.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
shade.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include "defs.h"
#include "stuff.h"

extern int num_scene_lights;
extern LightSource scene_lights[MAXLIGHTS];
static int *xytable,*xtable;

void
Shade(l,w,P,N,I,hit,col,s,hits,anti)
int l;
Flt w;
Point P, N, I;
Isect *hit;
Color col;
Surf *s;
int hits;
int anti;  /* antialias flag; 0==don't, 1==do */
{
   Color tcol;
   register int i;
   Vec L;
   void SpecularDirection(), RefractedDirection();
   double alpha = 0.;

   col[0] = col[1] = col[2] = col[3] =0.0;

   /**     * for volume rendering, assume that have one ray intersecting
     * two surfaces.  want to do a shading through volume along
     * this ray.
     *
     * for test pictures, determine the "percentage" of the volume
     * penetrated by this ray.
   **/

   if (hits == 2)
   {
       /**
	 * this branch of code is entered if only one of the
	 * six volume bounding faces is intersected.  more generally,
	 * it represents a "failure" of the intersection
	 * routine in polygon.c.  occasionally, this will happen.
	 * however, this test also occurs somewhere else in the
	 * code (in inter.c), and if detected, some attempt is made
	 * to avoid this condition by "jittering" the ray around
	 * in hopes of overcoming the numerical problems which
	 * resulted in this problem in the first place.  i haven't
	 * seen this error message since installing that piece
	 * of code (in inter.c).   w.bethel  10 may 1991
       **/
#if 0
       fprintf(stderr," error condition in shade \n");
       col[0] = col[1] = 1.0; /* make it red */
#endif
       return;
   }

   beam_composite(hit,hits,col,anti,&alpha);
   
   /* now composite with the background color */
   composite_with_background(col,&alpha);

   for (i=0;i<4;i++)
   {
      if (col[i] < 0.)
	 col[i] = 0.;
      else if (col[i] > 1.)
	 col[i] = 1.;
   }
}


composite_with_background(col,alpha)
double *alpha;
Color col;
{
    /* in this case, the background color is black.  this
       could be changed by entering:
       col[i] = col[i]*alpha + (background_color[i]*(1-alpha));
    */
    col[0] = *alpha;
    col[1] = col[1]*(*alpha);
    col[2] = col[2]*(*alpha);
    col[3] = col[3]*(*alpha);
}

void
SpecularDirection(I,N,R)
Point I, N, R;
{
   Flt x;

   x = -2.0 * VecDot(I,N);
   VecAddS(x,I,N,R);
   R[2] *= -1.0;
}

void
RefractedDirection(I,N,R,r)
Point I, N, R;
Flt r;
{
    /* the blatant fudge in this routine is that there is only one
       index of refraction passed in.  there in fact should be two;
       one for the medium which we're exiting and one for the
       media which we're entering. */
    Flt c1,c2,x;
    int i;
    Vec INDot;
    Vec LocI;

    VecCopy(I,LocI);
    VecNegate(LocI,LocI);
    c1 = VecDot(LocI,N);
    c2 = 1.-((r*r)*(1.-c1*c1));
    if (c2 < 0.)
    {
	R[0] = R[1] = R[2] = 0.;  /* pathalogic case */
	return;
    }
    else
        c2 = sqrt(c2);

    x = r*c1 - c2;
    for (i=0;i<3;i++)
    {
	LocI[i] = r*I[i] + x*N[i];
    }
    
    VecCopy(LocI,R);
    VecUnit(R,R);
}


/**
  * the component faces of the volume are organized thusly (assuming
  * unit sizes)
  *
  * face 0: xy face at z=0
  * face 1: yz face at x=1
  * face 2: xz face at y=1
  * face 3: yz face at x=0
  * face 4: xy face at z=1
  * face 5: xz fact at y=0
**/
#define INV255 0.003921568

beam_composite(hit,nhits,col,anti,alpha)
Isect *hit;
int nhits;
Color col;
int anti;
double *alpha;
{
    extern int totalsize;
    int in_index,out_index;
    int count,xcount,ycount,zcount;
    int i;
    int enter_index,exit_index;
    double xstart,ystart,zstart,dx,dy,dz,xend,yend,zend,x,y,z;
    double Red,Green,Blue,Alpha;
    double Vred,Vgreen,Vblue,Valpha;
    extern int Xwidth,Yheight,Zdepth,Xsize,XYsize;
    extern unsigned char *Vdata;
    extern double sqrt();

    enter_index = 0;
    exit_index = nhits-1;
    in_index = face_lookup(hit+enter_index,nhits);
    out_index = face_lookup(hit+exit_index,nhits);

    
    if ((in_index == -1) || (out_index == -1))  /* error condition */
	return;
    if ((in_index == 0) || (in_index == 4))  /* front or back face */
    {
	xstart = hit->U * (Xwidth-1);
	ystart = hit->V * (Yheight-1);
	if (in_index == 4)
	    zstart = Zdepth-1;
	else
	    zstart = 0.;
    }
    else if ((in_index == 3) || (in_index == 1)) /* left or right face */
    {
	ystart = hit->V * (Yheight-1);
	zstart = hit->U * (Zdepth-1);
	if (in_index == 1)
	    xstart = Xwidth-1;
	else
	    xstart = 0.;
    }
    else if ((in_index == 2) || (in_index == 5)) /* top or bottom face */
    {
	xstart = hit->U * (Xwidth-1);
	zstart = hit->V * (Zdepth-1);
	if (in_index == 5)
	    ystart = 0.;
	else
	    ystart = Yheight-1;
    }
    
    if ((out_index == 0) || (out_index == 4))  /* front or back face */
    {
	xend = (hit+exit_index)->U * (Xwidth-1);
	yend = (hit+exit_index)->V * (Yheight-1);
	if (out_index == 4)
	    zend = Zdepth-1;
	else
	    zend = 0.;
    }
    else if ((out_index == 3) || (out_index == 1)) /* left or right face */
    {
	yend = (hit+exit_index)->V * (Yheight-1);
	zend = (hit+exit_index)->U * (Zdepth-1);
	if (out_index == 1)
	    xend = Xwidth-1;
	else
	    xend = 0.;
    }
    else if ((out_index == 2) || (out_index == 5)) /* top or bottom face */
    {
	xend = (hit+exit_index)->U * (Xwidth-1);
	zend = (hit+exit_index)->V * (Zdepth-1);
	if (out_index == 5)
	    yend = 0.;
	else
	    yend = Yheight-1;
    }
    
    
    xcount= fabs(xend-xstart)+1;
    ycount = fabs(yend-ystart)+1;
    zcount = fabs(zend-zstart)+1;

    dx = xcount*xcount + ycount*ycount + zcount*zcount;
    
    count = (int)sqrt(dx);
    dx = dy = dz = 1./(count);
    dx *= xcount;

    if ((xend-xstart) < 0)
	dx *= -1.;

    dy *= (yend-ystart);
#if 0
    if (yend-ystart < 0)
	dy *= -1.;
#endif
    dz *= zcount;

    if ((zend-zstart) < 0)
	dz *= -1.;

    x = xstart;
    y = ystart;
    z = zstart;

    Red = Green = Blue = Alpha = 0.;
    for (i=0;i<count;i++)
    {
	
	load_voxel(x,y,z,&Valpha,&Vred,&Vgreen,&Vblue);

	if (anti != 0)
	    LocalAverage(&x,&y,&z,&Valpha,&Vred,&Vgreen,&Vblue);
	
	Red = Red*Alpha + Vred*(1.-Alpha);
	Green = Green*Alpha + Vgreen*(1.-Alpha);
	Blue = Blue*Alpha + Vblue * (1.-Alpha);
	Alpha = Alpha + (1.-Alpha)*Valpha;
	
	if (Alpha >= 1.)
	    break;
	
	z += dz;
	y += dy;
	x += dx;
    }

    col[0] = *alpha = Alpha;
    col[1] = Red;
    col[2] = Green;
    col[3] = Blue;
}

LocalAverage(x,y,z,a,r,g,b)
double *x,*y,*z,*a,*r,*g,*b;
{
    extern unsigned char *Vdata;
    double plus_x,plus_y,plus_z;
    int x_ok,y_ok,z_ok;
    double X,Y,Z,A,R,G,B;
    extern int Xwidth,Yheight,Zdepth,Xsize,XYsize;
    double lookup_root(),load_interp_value();
    double weight;
    double sx,sy,sz;
    double sa,sr,sg,sb;

    X = *x;
    Y = *y;
    Z = *z;
#if 0
    sa = A = *a;
    sr = R = *r;
    sg = G = *g;
    sb = B = *b;
#endif
    sa = *a;
    sr = *r;
    sg = *g;
    sb = *b;
    A = R = G = B = 0.;
    
    if ((X - floor(X)) >= 0.5)
	plus_x = 1.;
    else
	plus_x = -1.;
    sx = fabs(X-floor(X));
    sx = fabs(0.5 - sx);
    sx = 1.-sx;

    if ((Y - floor(Y)) >= 0.5)
	plus_y = 1.;
    else
	plus_y = -1.;
    sy = fabs(Y-floor(Y));
    sy = fabs(0.5 - sy);
    sy = 1.-sy;
    
    if ((Z - floor(Z)) >= 0.5)
	plus_z = 1.;
    else
	plus_z = -1.;
    sz = fabs(Z-floor(Z));
    sz = fabs(0.5 - sz);
    sz = 1.-sz;

    if (((X+plus_x) < (Xwidth-1)) && ((X+plus_x) >= 0))
	x_ok = 1;
    else
	x_ok = 0;
    
    if (((Y+plus_y) < (Yheight-1)) && ((Y+plus_y) >= 0))
	y_ok = 1;
    else
	y_ok = 0;
    
    if (((Z+plus_z) < (Zdepth-1)) && ((Z+plus_z) >= 0))
	z_ok = 1;
    else
	z_ok = 0;
    
    /* case 0. default A,R,G,B for voxel we're in has already been loaded. */
    /* contribution of source voxel */
    weight = sx * sy * sz;
    A = weight * sa;
    R = weight * sr;
    G = weight * sg;
    B = weight * sb;

    /* contribution of +/-1 in x */
    if (x_ok)
    {
	weight = (1. - sx) * sy * sz;
	load_voxel(X+plus_x,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = (1. - sx) * sy * sz;
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }

    /* contribution of +/-1 in y */
    if (y_ok)
    {
	weight = sx * (1. - sy) * sz;
	load_voxel(X,Y+plus_y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = sx * (1. - sy) * sz;
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    
    /* contribution of +/-1 in z */
    if (z_ok)
    {
	weight = sx * sy * (1.-sz);
	load_voxel(X,Y,Z+plus_z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = sx * sy * (1.-sz);
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    
    /* contribution of +/-1 in x,y */
    if ((x_ok) && (y_ok))
    {
	weight = (1. - sx) * (1. - sy) * sz;
	load_voxel(X+plus_x,Y+plus_y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = (1. - sx) * (1. - sy) * sz;
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    
    /* contribution of +/-1 in x,z */
    if ((x_ok) && (z_ok))
    {
	weight = (1. - sx) * sy * (1. - sz);
	load_voxel(X+plus_x,Y,Z+plus_z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = (1. - sx) * sy * (1. - sz);
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    
    /* contribution of +/-1 in y,z */
    if ((y_ok) && (z_ok))
    {
	weight = sx * (1. - sy) * (1. - sz);
	load_voxel(X,Y+plus_y,Z+plus_z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = sx * (1. - sy) * (1. - sz);
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    
    /* contribution of +/-1 in x,y,z */
    if ((x_ok) && (y_ok) && (z_ok))
    {
	weight = (1. - sx) * (1. - sy) * (1. - sz);
	load_voxel(X+plus_x,Y+plus_y,Z+plus_z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }
    else
    {
	weight = (1. - sx) * (1. - sy) * (1. - sz);
	load_voxel(X,Y,Z,&sa,&sr,&sg,&sb);
	A += weight * sa;
	R += weight * sr;
	G += weight * sg;
	B += weight * sb;
    }

    *a = A;
    *r = R;
    *g = G;
    *b = B;
}

load_voxel(x,y,z,a,r,g,b)
double x,y,z;
double *a,*r,*g,*b;
{
    register int index,ix;
    int iy,iz;
    extern int XYsize,Xsize;
    extern unsigned char *Vdata;

    ix = (int)x;
    iy = (int)y;
    iz = (int)z;

    index = *(xytable+iz)+ *(xtable+iy) + (ix<<2);

    ix = *(Vdata+index++);
    *a = (double)ix * INV255;
    ix = *(Vdata+index++);
    *r = (double)ix * INV255;
    ix = *(Vdata+index++);
    *g = (double)ix * INV255;
    ix = *(Vdata+index++);
    *b = (double)ix * INV255;
}

int
face_lookup(I,n)
Isect *I;
int n;
{
    Prim *p;
    int i;
    
    extern Prim *list[MAXOBJECTS];

    p = I->prim;
    for (i=0;i<6;i++)  /* hard-coded : simplifying assumption */
	if (p == list[i])
	    return(i);
    return(-1);
}

load_table_indeces()
{
    extern int Xwidth,Yheight,Zdepth,Xsize,XYsize;
    int i,j;
    
    xtable = (int *)malloc(sizeof(int)*Xwidth);
    xytable = (int *)malloc(sizeof(int)*Yheight);

    for (i=0,j=0;i<Xwidth;i++,j+=Xsize)
	*(xtable+i) = j;
    for (i=0,j=0;i<Yheight;i++,j+=XYsize)
	*(xytable+i) = j;
    
}
free_table_indeces()
{

/* IAC CODE CHANGE :     free((char *)xtable); */

/* IAC CODE CHANGE :      free(xtable); */

/* IAC CODE CHANGE :       free(xtable); */
       free(xtable);

/* IAC CODE CHANGE :     free((char *)xytable); */

/* IAC CODE CHANGE :      free(xytable); */

/* IAC CODE CHANGE :       free(xytable); */
       free(xytable);
}
