/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce volfaces.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  volfaces.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  volfaces.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     volfaces.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
volfaces.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "gmatrix.h"
#include "defs.h"
#include "stuff.h"

#define MAX(a,b) ((a) > (b)) ? (a) : (b)
#define NUM_DATA_PTS 24
/**
  * this filter will generate the vertices/faces which define the
  * bounding hull for a volume of data.  this data will be passed
  * off to a raytracing volume renderer which will perform
  * texture mapping (more or less) in a volumetric fashion.
  *
**/

static int xrot=0,yrot=0,zrot=0;
static int xwidth,yheight,zdepth;
vector4 *data;

build_volume_faces(xr,yr,zr,scale,dimensions,f,persp)
float *xr,*yr,*zr,*scale;
int *dimensions,persp;
FILE *f;
{
    matrix4x4 transformation,viewing,combined;

    xrot = *xr;
    yrot = *yr;
    zrot = *zr;
    
    xwidth = *dimensions++;
    yheight = *dimensions++;
    zdepth = *dimensions;
    
    volume_to_view_vol(xwidth,yheight,zdepth,&transformation,xrot,yrot,zrot,scale);

    /* compute 3d perspective transformation */
    view_xform(&viewing);
    identity_4x4(&combined);
    mmul_4x4(&combined,&transformation);
    mmul_4x4(&combined,&viewing);

    generate_data_points(&data);
    transform_data_points(data,&combined);
    if (persp)
	perspective_divide(data);
    dump_data_points(data,f); 

    free((char *)data); 
}

dump_data_points(v,f)
vector4 *v;
FILE *f;
{
    int faces=6,pts_per_face=4;
    int i,j,offset=0;

    for (i=0;i<faces;i++)
    {
	fprintf(f,"0 4 \n");
	for (j=0;j<pts_per_face;j++)
	{
	    fprintf(f," %6.3lf %6.3lf %6.3lf \n",(v+offset)->v[0],(v+offset)->v[1],(v+offset)->v[2]);
	    offset += 1;
	}
    }
    fprintf(f,"-1\n");
}

transform_data_points(d,m)
vector4 *d;
matrix4x4 *m;
{
    int i;
    vector4 temp;

    for (i=0;i<NUM_DATA_PTS;i++)
    {
	vector_matrix_mult_4(d+i,m,&temp);
	memcpy((char *)(d+i),(char *)&temp,sizeof(vector4));
    }
	
}
perspective_divide(d)
vector4 *d;
{
    int i;
    vector4 temp;

    for (i=0;i<NUM_DATA_PTS;i++)
    {
#if 0
	(d+i)->v[0] = (d+i)->v[0] / ((d+i)->v[2] + 1.);
	(d+i)->v[1] = (d+i)->v[1] / ((d+i)->v[2] + 1.);
#endif
	(d+i)->v[0] = (d+i)->v[0] / ((d+i)->v[2]);
	(d+i)->v[1] = (d+i)->v[1] / ((d+i)->v[2]);
    }
	
}

/**
  * in this routine, the faces which bound the volume are generated.
  * the points lie in a coordinate system with the origin (0,0,0)
  * corresponding to u=v=w=0 in volume data space, and
  * u=v=w=1 corresponding to the number of data points (less one)
  * for each of the logical i,j,k dimensions of the volume data.
  *
  * six bounding faces are generated.  each face consists of
  * a polygon defined by four segments.  the ordering of vertices
  * about these faces is EXTREMELY ORDER DEPENDANT with respect
  * to the resulting image.  don't change the order AT ALL.
**/
generate_data_points(d)
vector4 **d;
{
    int i,j,n=NUM_DATA_PTS;
    vector4 *v;

    v = (vector4 *)malloc(sizeof(vector4)*n);

    /* set all points values to zero initially, then change
       only the ones needed below */
    
    for (i=0;i<n;i++)
	for (j=0;j<4;j++)
	    (v+i)->v[j] = (j==3)?1.:0.;

    /**
      * face 0 :
      * points are generated in this order:
      * u=0,v=0,w=0,
      * u=1,v=0,w=0
      * u=1,v=1,w=0,
      * u=0,v=1,w=0
    **/
    
    i=0;
    (v+i+1)->v[0] = xwidth-1;
    (v+i+2)->v[0] = xwidth-1;
    (v+i+2)->v[1] = yheight-1;
    (v+i+3)->v[1] = yheight-1;

    /**
      * face 1 -- points are generated in this order:
      * u=1,v=0,w=0
      * u=1,v=0,w=1,
      * u=1,v=1,w=1,
      * u=1,v=1,w=0
    **/
    i+=4;
    (v+i)->v[0] = xwidth-1;
    (v+i+1)->v[0] = xwidth-1;
    (v+i+1)->v[2] = zdepth-1;
    (v+i+2)->v[0] = xwidth-1;
    (v+i+2)->v[1] = yheight-1;
    (v+i+2)->v[2] = zdepth-1;
    (v+i+3)->v[0] = xwidth-1;
    (v+i+3)->v[1] = yheight-1;
    
    /**
      * face 2 -- points are generated in this order:
      * u=0,v=1,w=0,
      * u=1,v=1,w=0,
      * u=1,v=1,w=1,
      * u=0,v=1,w=1
    **/
    i += 4;
    (v+i)->v[1] = yheight-1;
    (v+i+1)->v[0] = xwidth-1;
    (v+i+1)->v[1] = yheight-1;
    (v+i+2)->v[0] = xwidth-1;
    (v+i+2)->v[1] = yheight-1;
    (v+i+2)->v[2] = zdepth-1;
    (v+i+3)->v[1] = yheight-1;
    (v+i+3)->v[2] = zdepth-1;

    /**
      * face 3 -- points are generated in this order:
      * u=0,v=0,w=0,
      * u=0,v=0,w=1,
      * u=0,v=1,w=1,
      * u=0,v=1,w=0
    **/
    i += 4;
    (v+i+1)->v[2] = zdepth-1;
    (v+i+2)->v[1] = yheight-1;
    (v+i+2)->v[2] = zdepth-1;
    (v+i+3)->v[1] = yheight-1;

    /**
      * face 4
      * u=0,v=0,w=1,
      * u=1,v=0,w=1,
      * u=1,v=1,w=1,
      * u=0,v=1,w=1
    **/
    i += 4;
    (v+i+0)->v[2] = zdepth-1;
    (v+i+1)->v[0] = xwidth-1;
    (v+i+1)->v[2] = zdepth-1;
    (v+i+2)->v[0] = xwidth-1;
    (v+i+2)->v[1] = yheight-1;
    (v+i+2)->v[2] = zdepth-1;
    (v+i+3)->v[1] = yheight-1;
    (v+i+3)->v[2] = zdepth-1;
    
    /**
      * face 5 -- points are generated in the following order:
      * u=0,v=0,w=0,
      * u=1,v=0,w=0,
      * u=1,v=0,w=1,
      * u=0,v=0,w=1
    **/ 
    i += 4;
    (v+i+1)->v[0] = xwidth-1;
    (v+i+2)->v[0] = xwidth-1;
    (v+i+2)->v[2] = zdepth-1;
    (v+i+3)->v[2] = zdepth-1;
       
    *d = v;
}


#define PI 3.14159
#define DEGREES_TO_RADIANS(a) ((a)*PI/180.)

volume_to_view_vol(x,y,z,t,rx,ry,rz,scalef)
int x,y,z;
matrix4x4 *t;
int rx,ry,rz;
float *scalef;
{
    extern double cos(),sin();
    double scale_factor;
    matrix4x4 scale,translate,rot_x,rot_y,rot_z;
    /**
      * in this routine, we will scale the volume from its native
      * range to one bounded by 0..1. next, we'll translate the center
      * of the scaled volume to lie at the origin.
      * then we will rotate according to the angle measures in rx,ry,rz.
    **/
    identity_4x4(t);

    scale_factor = MAX(x,y);
    scale_factor = MAX(scale_factor,z);
    scale_factor = 1./scale_factor;
    identity_4x4(&scale);
    scale.m[0][0] = scale.m[1][1] = scale.m[2][2] = scale_factor * *scalef;

    identity_4x4(&translate);
    translate.m[3][0] = -0.5 * scale_factor * x * *scalef;
    translate.m[3][1] = -0.5 * scale_factor * y * *scalef;
    translate.m[3][2] = -0.5 * scale_factor * z * *scalef;

    /* do rotations */
    identity_4x4(&rot_x);
    rot_x.m[1][1] = cos(DEGREES_TO_RADIANS(rx));
    rot_x.m[1][2] = sin(DEGREES_TO_RADIANS(rx));
    rot_x.m[2][1] = -1. * sin(DEGREES_TO_RADIANS(rx));
    rot_x.m[2][2] = cos(DEGREES_TO_RADIANS(rx));
    
    identity_4x4(&rot_y);
    rot_y.m[0][0] = cos(DEGREES_TO_RADIANS(ry));
    rot_y.m[0][2] = -1. * sin(DEGREES_TO_RADIANS(ry));
    rot_y.m[2][0] = sin(DEGREES_TO_RADIANS(ry));
    rot_y.m[2][2] = cos(DEGREES_TO_RADIANS(ry));
    
    identity_4x4(&rot_z);
#if 0
    rot_z.m[0][0] = cos(DEGREES_TO_RADIANS(rz));
    rot_z.m[0][1] = sin(DEGREES_TO_RADIANS(rz));
    rot_z.m[1][0] = -1. * sin(DEGREES_TO_RADIANS(rz));
    rot_z.m[1][1] = rot_z.m[0][0];
#endif

    mmul_4x4(t,&scale);
    mmul_4x4(t,&translate);
    mmul_4x4(t,&rot_x);
    mmul_4x4(t,&rot_y);
    mmul_4x4(t,&rot_z);
}

view_xform(v)
matrix4x4 *v;
{
    /**
      * in this routine, we calculate the "viewing transformation"
      * matrix.  refer to foley&van dam, pp 293 for outline of elements.
      * several simplifying assumptions are made: no rotations of the
      * viewing coordinate space into canonical view volume space are
      * required since the eye lies on the z axis, w/x,y = 0.  if
      * x or y are non-zero, these rotations will have to be installed.
      * of the list of operations required to compute the viewing
      * transformation matrix, only the initial transformation, combined
      * with the perspective scaling operation, is required.
    **/
    double xeye,yeye,zeye;
    double vrp_x,vrp_y,vrp_z;
    double back_clip_plane=1.;
    matrix4x4 trans,perspective_scale;
    vector4 vrp,vrp_not;
    double umin,umax,vmin,vmax;


    identity_4x4(v);
    
    /* put view reference point at 0,0,0 */
    vrp_x = vrp_y = vrp_z = 0.;
    
    /* put the eye at 0,0,-3 */    
    xeye = yeye = 0.;
/*    zeye = -3.; */
    zeye = -5.;
    identity_4x4(&trans);
    trans.m[3][0] = -1. * xeye;
    trans.m[3][1] = -1. * yeye;
    trans.m[3][2] = -1. * zeye;

    vrp.v[0] = vrp_x;
    vrp.v[1] = vrp_y;
/*    vrp.v[2] = vrp_z; */
    vrp.v[2] = 0.0;
    vrp.v[3] = 1.;
    vector_matrix_mult_4(&vrp,&trans,&vrp_not);

    identity_4x4(&perspective_scale);
    umin = -0.5;
    umax = 0.5;
    vmin = -0.5;
    vmax = 0.5;
    perspective_scale.m[0][0] = (2. * vrp_not.v[2]) /
	((umax-umin)*(vrp_not.v[2] + back_clip_plane));
    perspective_scale.m[1][1] = (2. * vrp_not.v[2]) /
	((vmax-vmin)*(vrp_not.v[2] + back_clip_plane));
    perspective_scale.m[2][2] = 1./(vrp_not.v[2] + back_clip_plane);

    mmul_4x4(v,&trans);
    mmul_4x4(v,&perspective_scale);
}

