/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
*   Copyright 1993 by University of California Regents, and Tim O. Robinson
*
*    Author info:
*    Tim O. Robinson 			(timro@cchem.berkeley.edu)
*    410 Latimer Hall
*    College of Chemistry, UCB
*    Berkeley, CA 94720
*
* don't forget to chop this off before attempting to read into mod gen!
*/

/* mod_gen Version 1                                                     */
/* Module Name: "non_ortho" (Mapper) (Subroutine)                        */
/* Author: Tim Robinson                                                  */
/* Date Created: Thu Mar 11 09:58:10 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* input 0 "field_in" field uniform REQUIRED                             */
/* output 0 "field_out" field 3-space irregular                          */
/* param 0 "a" typein_real 1.00000 0.00000 100.000                       */
/* param 1 "b" typein_real 1.00000 0.00000 100.000                       */
/* param 2 "c" typein_real 1.00000 0.00000 100.000                       */
/* param 3 "alpha" typein_real 90.0000 0.00000 360.000                   */
/* param 4 "beta" typein_real 90.0000 0.00000 360.000                    */
/* param 5 "gamma" typein_real 90.0000 0.00000 360.000                   */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#define PI 3.14159265358979
#define DTOR (PI/180.0)
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int non_ortho_desc()
{

	int in_port, out_port, param;
	extern int non_ortho_compute();

	AVSset_module_name("non_ortho", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("field_in", "field uniform", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("field_out", 
		"field 3-space irregular");

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("a", 1.00000, 0.00000, 100.000);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("b", 1.00000, 0.00000, 100.000);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("c", 1.00000, 0.00000, 100.000);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("alpha", 90.0000, 0.00000, 360.000);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("beta", 90.0000, 0.00000, 360.000);
	AVSconnect_widget(param, "typein_real");
	param = AVSadd_float_parameter("gamma", 90.0000, 0.00000, 360.000);
	AVSconnect_widget(param, "typein_real");

	AVSset_compute_proc(non_ortho_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int non_ortho_compute( field_in, field_out, a, b, c, alpha, beta, gamma)
	AVSfield *field_in;
	AVSfield **field_out;
	float *a;
	float *b;
	float *c;
	float *alpha;
	float *beta;
	float *gamma;
{
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */

   float (*verts)[3];
   float cell[6];
   float M[3][3];
   int dims[3], i, j, k, ncoord;
   int indx, indy, indz;
   AVSfield *template;

/* fill an array of the cell parameters and construct the non-orthogonal
   transformation matrix */

   cell[0] = *a; cell[1] = *b; cell[2] = *c;
   cell[3] = *alpha; cell[4] = *beta; cell[5] = *gamma;
   buildtransform(M, cell);

/* set higher dimension values to 1 so we don't barf on lower than 3D */
   switch (field_in->ndim) {
      case 1: 
         dims[0] = MAXX(field_in);
         dims[1] = 1;
         dims[2] = 1;
         break;
      case 2:
         dims[0] = MAXX(field_in);
         dims[1] = MAXY(field_in);
         dims[2] = 1;
         break;
      case 3:
         dims[0] = MAXX(field_in);
         dims[1] = MAXY(field_in);
         dims[2] = MAXZ(field_in); 
         break;
      default:
         AVSerror("This field dimensionality is not supported");
         return(0);
   }

/* allocate and fill a 3vector of length dim0 x dim1 x ...       */
   if (!(verts = (float (*)[3])ALLOC_LOCAL(3 * dims[0] * dims[1] *
			dims[2] * sizeof(float))))
   {
      AVSerror("Can't allocate irregular space vertexes");
      return(0);
   }

/* for clarity */
   indx = dims[0];
   indy = dims[1];
   indz = dims[2];

   for(k = 0; k < dims[2]; k++) {
      for(j = 0; j < dims[1]; j++) {
         for(i = 0; i < dims[0]; i++) {
            verts[k*indx*indy + j*indx + i][0] = i;
            verts[k*indx*indy + j*indx + i][1] = j;
            verts[k*indx*indy + j*indx + i][2] = k;
         }
      }
   }

/* transform the "uniform" coordinate array to irregular space    */
mat_vec_mul(M, verts, dims[0]*dims[1]*dims[2]); 

/* Free old field data                                                   */
   if (template) FREE_LOCAL(template);
   if (*field_out) AVSfield_free(*field_out);

/* alloc space for new field based on input field via a template         */
   template = (AVSfield *)ALLOC_LOCAL(sizeof(AVSfield));
   AVSfield_make_template(field_in, template);
   template->uniform = IRREGULAR ;
   *field_out = (AVSfield *)AVSfield_alloc(template, 0);
   if (*field_out == NULL) {
      AVSerror("Allocation of output field failed.");
      return(0);
   }
/* copy the data into the new data array                                 */
   memcpy((*field_out)->field_data, field_in->field_data, dims[0]
                *dims[1]*dims[2]*field_in->size);
/* now fill up the points array with the new points                      */
/* not too efficient but ok for testing */   
   for(ncoord = 0; ncoord < 3; ncoord++) {
      for(k = 0; k < dims[2]; k++) {
         for(j = 0; j < dims[1]; j++) {
            for(i = 0; i < dims[0]; i++) {
            (*field_out)->points[ncoord*indz*indy*indx + k*indy*indx +
			j*indx + i] = verts[k*indx*indy + j*indx + i][ncoord];
            }
         }
      }
   }

/* transform the "extents" to the new space                       */
mat_vec_mul(M, (*field_out)->min_extent, 1);
mat_vec_mul(M, (*field_out)->max_extent, 1);

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
   return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	non_ortho_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/

buildtransform(M,cell)
float M[3][3];
float cell[6];
{
   /* determine the transformation matricies */
   double ca, cb, cg, sg, V;

   ca = cos(cell[3]*DTOR); cb = cos(cell[4]*DTOR);
   cg = cos(cell[5]*DTOR); sg = sin(cell[5]*DTOR);

   V = cell[0]*cell[1]*cell[2]*sqrt(1 - ca*ca - cb*cb - cg*cg + 2*ca*cb*cg);

   M[0][0] = cell[0];
   M[0][1] = cell[1] * cg;
   M[1][1] = cell[1] * sg;
   M[0][2] = cell[2] * cb;
   M[1][2] = cell[2] * (ca - cb * cg) / sg ;
   M[2][2] = V / (sg * cell[0] * cell[1]);
   M[1][0] = M[2][0] = M[2][1] = 0.000;
}


mat_vec_mul(m, vec, number)
   int number; 
   float m[3][3]; 
   float vec[][3];  
{
   int i;
   register double  a0, a1, a2;

   for(i = 0; i < number; i++)
   {
      a0 = vec[i][0];  a1 = vec[i][1];  a2 = vec[i][2];

      vec[i][0] = m[0][0]*a0 + m[0][1]*a1 + m[0][2]*a2;
      vec[i][1] = m[1][0]*a0 + m[1][1]*a1 + m[1][2]*a2;
      vec[i][2] = m[2][0]*a0 + m[2][1]*a1 + m[2][2]*a2;
   }
}
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
