/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce scat2main.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  scat2main.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  scat2main.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     scat2main.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
scat2main.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov

    12 Dec 1991

    Changed output field to rectilinear from irregular.

    31 Jan 1991
    Fixed bug relating to size of work arrays malloced for the fortran
    number crunching routine.
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

static int scat2d();

AVSinit_modules()
{
    int scatmain();
    AVSmodule_from_desc(scatmain);
}

scatmain()
{
    int p,scatmain_p(),scat_2d_init();

    AVSset_module_name("scat 2d",MODULE_MAPPER);
    AVScreate_input_port("input_field","field 2-coordinate irregular scalar float",REQUIRED);
    AVScreate_output_port("output_field","field 2D rectilinear scalar float");

    p=AVSadd_parameter("dummy1","string","Interpolation Range Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_float_parameter("Xmin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Xmax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    
    p=AVSadd_float_parameter("Ymin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Ymax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");

    p=AVSadd_parameter("dummy2","string","Output Grid Resolution","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_parameter("Xsamples","integer",20,2,1000);
    AVSconnect_widget(p,"idial");
    p=AVSadd_parameter("Ysamples","integer",20,2,1000);
    AVSconnect_widget(p,"idial");

    p=AVSadd_parameter("dummy3","string","Number of Points of Influence","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Npoints","integer",4,2,10000);
    AVSconnect_widget(p,"idial");
    
    AVSset_compute_proc(scatmain_p);
}

scatmain_p(inf,outf,dummy1,xmin,xmax,ymin,ymax,dummy2,xs,ys,dummy3,NCP)
AVSfield_float *inf,**outf;
char *dummy1,*dummy2,*dummy3;
float *xmin,*xmax,*ymin,*ymax;
int xs,ys,NCP;
{
    AVSfield_float template;
    int dims[3],npoints,i;

    /**
      * check for following error conditions:
      * 1. field data dimensions greater than one
      *
      * degenerate conditions:
      * 1. 3-d coordinates.  this module will assume the z-coords are
      *    constant. (use the 3d scat2grid module for 3d interpolation)
    **/

    memset((char *)&template,0,sizeof(AVSfield_float));
    template.ndim = 2;  /* take 1-d scatter data, interpolate in 2-d */
    template.nspace = 2;
    template.veclen = 1;
    template.type = AVS_TYPE_REAL;
    template.uniform = RECTILINEAR;
    template.size = sizeof(float);
    dims[0] = xs;
    dims[1] = ys;
    if (*outf)
	AVSfield_free(*outf);
    *outf = (AVSfield_float *)AVSfield_alloc(&template,dims);
    if (*outf == NULL)
    {
	AVSwarning(" Output Field malloc error.");
	return(0);
    }

    /* do validity checking on NCP */

    for (i=0,npoints=1;i<inf->ndim;i++)
	npoints *= inf->dimensions[i];
	
    if ((AVSinput_changed("input_field",0)))
    {
	AVSmodify_parameter("Npoints",AVS_MAXVAL,npoints-1,npoints-1,npoints-1);
    }
    
    if (NCP > npoints-1)
    {
	NCP = npoints-1;
	AVSmodify_parameter("Npoints",AVS_VALUE,npoints-1,npoints-1,npoints-1);
    }
    
    if (scat2d(inf,*outf,xmin,xmax,ymin,ymax,xs,ys,NCP))
	return(1);
    else
	return(0);
}

static int
scat2d(inf,outf,xmin,xmax,ymin,ymax,xs,ys,NCP)
AVSfield_float *inf,*outf;
float *xmin,*xmax,*ymin,*ymax;
int xs,ys,NCP;
{
    extern double sqrt();
    float X,dX,Y,dY,Z,*xp,*yp,*zp,*xptr,*yptr;
    float *out_xpts,*out_ypts;
    char c_zero=0;
#ifdef STARDENT
    extern IDSFFT();
#elif STARDENT800
    extern idsfft_();
#elif SUN
    extern idsfft_();
#endif
    int md=1;  /* mode of computation for IDSFFT..*/
    int ncp;
    int ndp; /* number of data points.. */
    int i,n,j;
    int *iwk;
    float *wk;

    ndp = 1;
    for (i=0;i<inf->ndim;i++)
	ndp *= inf->dimensions[i];

    /**
      * fix ncp to range of 2 <= ncp <= ndp
    **/
    ncp = NCP;
    ncp = (ncp < 2) ? 2 : ncp;
    ncp = (ncp > ndp) ? ndp : ncp;

    n = inf->dimensions[0];
    xptr = inf->points;
    yptr = xptr+ndp;

    /**
      * now, we will evaluate the function at the desired number
      * of locations.
    **/
    X = *xmin;
    dX = (*xmax - *xmin)/(double)(xs - 1);
    Y = *ymin;
    dY = (*ymax - *ymin)/(double)(ys - 1);

    xp = outf->points;
    yp = outf->points + outf->dimensions[0];

    out_xpts = (float *)malloc(sizeof(float)*outf->dimensions[0]);
    out_ypts = (float *)malloc(sizeof(float)*outf->dimensions[1]);

    /* load the coords in the output rectilinear field. */
    for (j=0;j<ys;j++,Y+=dY)
	*yp++ = Y;
    for (j=0;j<xs;j++,X+=dX)
	*xp++ = X;

    /* load the coords for the sake of the numerical code.  it
       doens't know about rectilinear grids. */
    
    Y = *ymin;
    for (j=0;j<ys;j++,Y += dY)
    {
	X = *xmin;
	*(out_ypts+j) = Y;
	for (i=0;i<xs;i++,X += dX)
	    *(out_xpts+i) = X;
    }

    i = ndp*5;
    wk = (float *)malloc(sizeof(float)*i);
    memset((char *)wk,c_zero,n*sizeof(float));
    i = (31 > 27 + ncp) ? 31 : 27 + ncp;
    i = i*ndp + xs*ys;
    iwk = (int *)malloc(sizeof(int)*i);
    memset((char *)iwk,c_zero,i*sizeof(int));
    if ((wk==NULL)||(iwk==NULL))
    {
	AVSwarning("malloc error in scat2d.");
	return(0);
    }
#ifdef STARDENT

    IDSFFT(&md,&ncp,&ndp,xptr,yptr,inf->data,&xs,&ys,
	   out_xpts,out_ypts,outf->data,iwk,wk);
/*    fprintf(stderr," finished with scat2d.\n"); */
    
#elif STARDENT800
    
    idsfft_(&md,&ncp,&ndp,xptr,yptr,inf->data,&xs,&ys,
	   out_xpts,out_ypts,outf->data,iwk,wk);

#elif SUN
    idsfft_(&md,&ncp,&ndp,xptr,yptr,inf->data,&xs,&ys,
	   out_xpts,out_ypts,outf->data,iwk,wk);
#endif

    free(out_xpts);
    free(out_ypts);
    free(wk);
    free(iwk);
    return(1);
}
