/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

 AUTHOR : Lawrence Berkeley Laboratory
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce scat3main.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  scat3main.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  scat3main.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     scat3main.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
scat3main.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

static int scat3d();

AVSinit_modules()
{
    int scatmain();
    AVSmodule_from_desc(scatmain);
}

scatmain()
{
    int p,scatmain_p();

    AVSset_module_name("scat 3d",MODULE_FILTER);
 /*   AVScreate_input_port("input_field","field 1D irregular scalar float",REQUIRED); */
    AVScreate_input_port("input_field","field irregular 1D 3-coordinate scalar float",REQUIRED); 
    AVScreate_output_port("output_field","field irregular 3D 3-coordinate scalar float"); 

    p=AVSadd_parameter("dummy1","string","Interpolation Range Control","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_float_parameter("Xmin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Xmax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    
    p=AVSadd_float_parameter("Ymin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Ymax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");

    p=AVSadd_float_parameter("Zmin",-1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");
    p=AVSadd_float_parameter("Zmax",1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
    AVSconnect_widget(p,"typein_real");

    p = AVSadd_parameter("dummy2","string","3-D Grid Resolution","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);
    
    p=AVSadd_parameter("Xsamples","integer",20,10,1000);
    AVSconnect_widget(p,"idial");
    p=AVSadd_parameter("Ysamples","integer",20,10,1000);
    AVSconnect_widget(p,"idial");
    p=AVSadd_parameter("Zsamples","integer",20,10,1000);
    AVSconnect_widget(p,"idial");

    p = AVSadd_parameter("dummy3","string","Number of Least Squares Points","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Least Squares Points","integer",20,9,10000);
    AVSconnect_widget(p,"idial");

    p = AVSadd_parameter("dummy4","string","Number of Nodes Defining Radii of Influence","","");
    AVSconnect_widget(p,"text");
    AVSadd_parameter_prop(p,"width","integer",4);

    p=AVSadd_parameter("Node Radius","integer",32,1,10000);
    AVSconnect_widget(p,"idial");

    AVSset_compute_proc(scatmain_p);
}

scatmain_p(inf,outf,dummy1,xmin,xmax,ymin,ymax,zmin,zmax,dummy2,
	   xs,ys,zs,dummy3,lsq_pts,dummy4,node_radius)
AVSfield_float *inf,**outf;
char *dummy1,*dummy2,*dummy3,*dummy4;
float *xmin,*xmax,*ymin,*ymax,*zmin,*zmax;
int xs,ys,zs;
int lsq_pts,node_radius;
{
    AVSfield_float template;
    int dims[3];
    int npoints,lsq_pts2,node_radius2;

    /**
      * check for following error conditions:
      * 1. field data dimensions greater than one
    **/

    if (inf->ndim > 1)
    {
	AVSwarning(" Only 1-d scatter fields are presently allowed.");
	return(0);
    }

    memset((char *)&template,0,sizeof(AVSfield_float));
    
    template.ndim = 3;  /* take 1-d scatter data, interpolate in 3-d */
    template.nspace = inf->nspace;
    template.veclen = 1;
    template.type = AVS_TYPE_REAL;
    template.uniform = IRREGULAR;
    template.size = sizeof(float);
    dims[0] = xs;
    dims[1] = ys;
    dims[2] = zs;
    if (*outf)
	AVSfield_free(*outf);
    *outf = (AVSfield_float *)AVSfield_alloc(&template,dims);
    if (*outf == NULL)
    {
	AVSwarning(" Output Field malloc error.");
	return(0);
    }

    /* do validity checks of parameters lsq_points and node_radius. */

    npoints = inf->dimensions[0];

    /* first, check lsq_pts */

    lsq_pts2 = lsq_pts;
    if (lsq_pts < 9)
	lsq_pts2 = 9;
    else
    {
	if (lsq_pts > 4000)
	    lsq_pts2 = 4000;
	if ((lsq_pts > npoints-1) || (lsq_pts2 > npoints-1))
	    lsq_pts2 = npoints-1;
    }
    if (lsq_pts != lsq_pts2)
	AVSmodify_parameter("Least Squares Points",AVS_VALUE,lsq_pts2,lsq_pts2,lsq_pts2);

    /* now do node_radius */
    node_radius2 = node_radius;
    if (node_radius < 1)
	node_radius2 = 1;
    else
    {
	if (node_radius > 40)
	    node_radius2 = 40;
	if ((node_radius > npoints-1) || (node_radius2 > npoints-1))
	    node_radius2 = npoints-1;
    }
    if (node_radius != node_radius2)
	AVSmodify_parameter("Node Radius",AVS_VALUE,node_radius2,node_radius2,
			    node_radius2);
    
    
    if (scat3d(inf,*outf,xmin,xmax,ymin,ymax,zmin,zmax,xs,ys,zs,lsq_pts2,node_radius2))
	return(1);
    else
	return(0);

}

static char erms1[]={" Internal parameter configuration error -- cannot continue."};
static char erms2[]={" Duplicate nodes were encountered in the data.  Cannot continue."};
static char erms3[]={" Data nodes are coplanar.  Unable to continue."};
static char *errmsgs[]=
{
    erms1,
    erms2,
    erms3
};

static int
scat3d(inf,outf,xmin,xmax,ymin,ymax,zmin,zmax,xs,ys,zs,lsq_pts,node_radius)
AVSfield_float *inf,*outf;
float *xmin,*xmax,*ymin,*ymax,*zmin,*zmax;
int xs,ys,zs,lsq_pts;
{
    int n,nq,nw,ierr,nr;
    float *xptr,*yptr,*zptr,*f,*rsq,rmax,XYZmin[3],XYZdel[3],*A;
    extern double pow();
    int *lcell,*lnext;
    int i,j,k;
    float X,dX,Y,dY,Z,dZ,*xp,*yp,*zp,rvalue,*outdata;
#ifdef STARDENT
    extern float QS3VAL();
#elif STARDENT800
    extern float qs3val_();
#endif

    /* set up parameters for qshep3() call */
    
    n = inf->dimensions[0];
    xptr = inf->points;
    yptr = xptr + n;
    zptr = yptr + n;
    f = inf->data;

    nq = lsq_pts;

    nw = node_radius;
    
    nr = (int)(pow(((double)(n)/3.0),0.33334));  /* ditto */

    lcell = (int *)malloc(sizeof(int)*nr*nr*nr);
    lnext = (int *)malloc(sizeof(int)*n);
    rmax = 0.0;
    rsq = (float *)malloc(sizeof(float)*n);
    A = (float *)malloc(sizeof(float)*9*n);

    if (lcell == NULL ||
	lnext == NULL ||
	rsq == NULL ||
	A == NULL)
    {
	AVSwarning(" Malloc failure in scat3d.");
	return(0);
    }

    /**
      * this routine just gets stuff set up.
    **/
#ifdef STARDENT
    QSHEP3(&n,xptr,yptr,zptr,f,&nq,&nw,&nr,lcell,lnext,XYZmin,XYZdel,
	   &rmax,rsq,A,&ierr);
#elif STARDENT800
    qshep3_(&n,xptr,yptr,zptr,f,&nq,&nw,&nr,lcell,lnext,XYZmin,XYZdel,
	   &rmax,rsq,A,&ierr);
    
#endif
    
    if (ierr != 0)
	fprintf(stderr,"error code: %d;%s\n",ierr,errmsgs[ierr-1]);
    else
	fprintf(stderr," Done with qshep3.\n");
	
    /**
      * now, we will evaluate the function at the desired number
      * of locations.
    **/
    X = *xmin;
    dX = (*xmax - *xmin)/(double)(xs - 1);
    Y = *ymin;
    dY = (*ymax - *ymin)/(double)(ys - 1);
    Z = *zmin;
    dZ = (*zmax - *zmin)/(double)(zs - 1);

    xp = outf->points;
    yp = outf->points + (outf->dimensions[0]*outf->dimensions[1]*outf->dimensions[2]);
    zp = yp + (outf->dimensions[0]*outf->dimensions[1]*outf->dimensions[2]);
    outdata = outf->data;

    for (k=0;k<zs;k++,Z += dZ)
    {
	Y = *ymin;
	for (j=0;j<ys;j++,Y += dY)
	{
	    X = *xmin;
	    for (i=0;i<xs;i++,X += dX)
	    {
		rvalue = -123456.;
#ifdef STARDENT
		rvalue = QS3VAL(&X,&Y,&Z,&n,xptr,yptr,zptr,f,&nr,lcell,lnext,
				XYZmin,XYZdel,&rmax,rsq,A);
#elif STARDENT800
		rvalue = qs3val_(&X,&Y,&Z,&n,xptr,yptr,zptr,f,&nr,lcell,lnext,
				XYZmin,XYZdel,&rmax,rsq,A);
		
#endif
		if (rvalue == -123456.)
		    fprintf(stderr," error somewhere in qs3val.\n");
		*outdata++ = rvalue;
		*xp++ = X;
		*yp++ = Y;
		*zp++ = Z;
	    }
	}
    }
    fprintf(stderr," finished with scat3d.\n");

    free(lcell);
    free(lnext);
    free(rsq);
    free(A);
    return(1);
}
