/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * scat_base_label - draw Text label at 1st point of scatter data
 *
 * If your vector data is 1D n-vector float irregular,
 * this module will draw a text label just above the first point,
 * showing the data label in the AVSfield header.
 * This is used in one application to show the names of wells.
 *
 * Input: field 1D irregular float (scatter)
 *
 * Output: geometry containing label
 *
 * Parameters:
 *     On/Off          - total module control
 *     
 *
 * Author: I. Curington, AVS Inc, UK
 *
 * Revision:
 * 31 March 92  Original (from ucd_cell_ribbon, cell data)
 * 14 July  92  Conversion to scatter fields
 * 15 July  92  bug fix in positioning
 * 15 Aug   92  conversion of scatter_arrows to scat_base_label
 * 24 Aug   93  adapted scat_base_label to scatter ribbons
 *              added controls
 * 25 Aug   93  ripped out tristrip, put in disj quad code
 * 26 Aug   93  added width min-max control
 *              added tics and labels
 * 28 Aug   93  ripped out ribbons, converted to single label
 *
 */


/*-----------------------------------------------------*
 *                                                     *
 *     ****  scat_base_label   module  ****            *
 *                                                     *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>


#include <avs/avs.h>
#include <avs/geom.h>
#include <avs/field.h>

/* =============== compute routine ============== */

int scat_base_label (scatter,
                     output,
                     on_off )

  AVSfield_float *scatter;  /* scatter field */
  GEOMedit_list  *output;   /* geom out */
  int            on_off;    /* module on-off control */
{
    GEOMobj *obj_label;

   /***********
    * Body    *
    ***********/


    /* establish the geometry output object */
    *output = GEOMinit_edit_list(*output);
    obj_label = GEOMcreate_label(GEOM_NULL, NULL);


    /* draw labels down side of scatter */
    if ( on_off )
    {
        draw_label_obj (obj_label, scatter );
    }


    /* complete the geometry to output port process */

    GEOMedit_geometry (*output, "scat_base_label", obj_label);

    GEOMdestroy_obj (obj_label);

    GEOMedit_transform_mode (*output, "scat_base_label", "parent");


    return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *    ****  draw labels along scatter  ****            *
 *                                                     *
 *-----------------------------------------------------*/

draw_label_obj (obj, scatter  )
    GEOMobj *obj;
    AVSfield_float *scatter;
{

    int         i, k, n;
    float       p[3];
    float       verts[ 2 * 3 ];
    float       xt[3];          /* tic angle vector */
    float       z;

    int label_flags;
    int font, title, background, drop, align, stroke;
    float label_center[3];
    float label_offset[3];
    float label_size;
    char  string[80];
    char  delim[4];


    /********************
     *  B O D Y         *
     ********************/

    n = MAXX( scatter );

    AVSfield_get_labels( scatter, string, delim );

    xt[0] = 0.0;
    xt[1] = 0.0;
    xt[2] = 0.0;
 
    font = 1;                   /* font 0-21 */
    title = 0;                  /* use ref_point */
    background = 1;             /* 1=filled rectable */
    drop = 1;                   /* 0=no, 1=drop shadow */
    stroke = 0;                 /* always zero */
    align = GEOM_LABEL_RIGHT;
    label_size = 0.08;          /* height in screen space */
    label_center[2] =
    label_offset[0] = label_offset[1] = label_offset[2] = 0.0;
    label_flags = GEOMcreate_label_flags(
               font, title, background, drop,align, stroke);


    /* loop over input polyline length */
/***
    for( i=0; i < n; i+= label_interval )
 ***/
    /* Just Once, for 1st point */
    i = 0;
    {
 
      /* X, Y, Z loop: */
      for( k=0; k < 3; k++ )
      {
            /* get label point */
            p[k] = scatter->points[k*n+i] + xt[k];
      }

      GEOMadd_label ( obj, string, p,
                      label_offset, label_size, GEOM_NULL, label_flags );

    }


}


/*-----------------------------------------------------*
 *                                                     *
 *        ****  scat_base_label_desc  ****               *
 *                                                     *
 *-----------------------------------------------------*/
int
scat_base_label_desc()
{
  extern int scat_base_label();
  int  param;

  /* name on the box */
  AVSset_module_name ("scat_base_la", MODULE_MAPPER);
  AVSset_module_flags( COOPERATIVE | REENTRANT );


  /*
   * Input Ports
   */
  /* input scatter field structure to draw */
  AVScreate_input_port ("Scatter",
     "field 1D 3-space irregular float", REQUIRED);

  /*
   * Output Ports
   */
  /* output geomerty to draw */
  AVScreate_output_port ("scat_base_label", "geom");

  /*
   * Parameters
   */
  AVSadd_parameter("On / Off",      "boolean", 1, 0, 1 );

  /* routine pointers */
  AVSset_compute_proc (scat_base_label);

}  /* end of description routine */

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
#ifdef SEP_EXE
int ((*mod_list[])()) = {
        scat_base_label_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
        AVSinit_from_module_list(mod_list, NMODS);
}
#endif


