/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * scatter_arrows (updated version 10/2/93)
 *
 * draw geometric representation of scatter input
 *
 * If your vector data is 2 or 3-vector,
 * this module will draw arrows from the
 * specified positions in the scatter field coord
 * array.
 *
 * Author: I. Curington, AVS Inc, UK
 *
 * Revision:
 * 31 March 92  Original (from ucd_cell_arrows, cell data)
 * 14 July  92  Conversion to scatter fields
 * 15 July  92  bug fix in positioning
 * 10 Feb   93  added ``Normalise Vector'' button - Steve Larkin, CGU, MCC, UK
 *              
 */

/*-----------------------------------------------------*
 *                                                     *
 *     ****  scatter_arrows   module  ****            *
 *                                                     *
 *                                                     *
 *-----------------------------------------------------*/

#include <stdio.h>


#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/geom.h>
#include <avs/field.h>
#include <avs/colormap.h>

void HSVA_to_RGB ();

/* =============== compute routine ============== */

static scatter_arrows (input, colormap, output, scale, normalise )

  AVSfield_float *input;
  AVScolormap   *colormap;
  GEOMedit_list **output;
  float         *scale;
  int           normalise;
{
    char model_name[80];
    GEOMobj *obj, *lobj;
    float *xc, *yc, *zc, *cell_data;
    int cell, i, name_flag, util_flag, data_len, cell_len, node_len,
        n, num_nodes, num_cells;

    int num_arrows;

    num_arrows = input->dimensions[0];  /* number of vectors to draw */


    /* establish the geometry output object */
    *output = (GEOMedit_list *)GEOMinit_edit_list(*output);
    obj    =  GEOMcreate_obj (GEOM_POLYTRI, NULL);

    /* draw the geometry from the scatter list */
    display_arrows (input, num_arrows, obj, *scale, normalise, colormap );


    /* complete the geometry to output port process */
    GEOMedit_geometry (*output, "scatter_arrows", obj);
    GEOMdestroy_obj (obj);
    GEOMedit_transform_mode (*output, "scatter_arrows", "parent");

    return(1);
}


/*-----------------------------------------------------*
 *                                                     *
 *          ****  display_arrows  ****                 *
 *                                                     *
 *-----------------------------------------------------*/

static display_arrows (input, num_cells, obj, scale, normalise, colormap )

  AVSfield_float *input;  /* scatter input port */
  int num_cells;          /* how many cells */
  GEOMobj *obj;           /* add polygons to this object */
  float scale;            /* length of arrows */
  int   normalise;        /* 0 or 1 if normalise option on */
  AVScolormap *colormap;  /* used to colour normalised vectors */
{
      char ctype[40];
      float vector[3], cx, cy, cz, line_cols[3];

      int cell, cell_id, mat_id, cell_type, me_flags, *node_list,
          node, face, v, numv, num_fv, 
          num_nodes, i, k, j;

      float *xc, *yc, *zc;    /* node position arrays */
      int cell_len;           /* cell vector length */
      float *cell_data;       /* data to use for arrows */
      float mag,r,b,g;        /* used to get colour value */
      int   index;            /* index into colormap */

      /*********************************************/
      /**** loop over ALL cell  surfaces        ****/
      /*********************************************/
    
      cell_len = input->veclen;

      for (cell = 0; cell < num_cells; cell++)
      {

        cx = input->points[ 0 * num_cells + cell ]; 
        cy = input->points[ 1 * num_cells + cell ];
        cz = input->points[ 2 * num_cells + cell ];

        vector[0] = input->data[ cell_len * cell +0 ];
        vector[1] = input->data[ cell_len * cell +1 ];
        if ( cell_len <= 2 )
            vector[2] = 0.0;
        else
            vector[2] = input->data[ cell_len * cell +2 ];

/* printf("%d coord  %f %f %f\n",  cell,cx,cy,cz); */
/* printf("%d vector %f %f %f\n\n",cell,vector[0],vector[1],vector[2]); */

        /* if vectors are to be normalised then colour */

        if ((normalise) && (colormap))
	  {
	    mag = sqrt ( vector[0]*vector[0] + vector[1]*vector[1] +
                         vector[2]*vector[2] );

	    /* get the hsva value for the magnitude */

            index = AVScmap_index(colormap,mag);

            /* convert hsv to rgb */

            HSVA_to_RGB (colormap->hue[index],
			 colormap->saturation[index],
			 colormap->value[index],
			 colormap->alpha[index],
			 &r,&g,&b);

	    /* set the rgb values */

	    line_cols[0] = r;
	    line_cols[1] = g;
	    line_cols[2] = b;

	  }
	else {
        /* set the line colours to white */
       
        line_cols[0] = 1.0;
        line_cols[1] = 1.0;
        line_cols[2] = 1.0;
      }

        create_arrow (obj, cx, cy, cz, vector, scale, normalise, line_cols);

      }  /* end of cell loop */
    
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  HSVA_to_RGB ****                       *
 *                                                     *
 *-----------------------------------------------------*/

void HSVA_to_RGB (h, s, v, a, r, g, b)
    
     float h,s,v,a,*r,*g,*b;
{
  float p,q,f,t;
  int i;

  if (v == 0)
    {
      *r = 0.0;
      *g = 0.0;
      *b = 0.0;
      }
  else {
    if (s == 0)
      {
	 *r = v;
	 *g = v;
	 *b = v;
       }
    else {
      h = h * 6.0;
         { if (h >= 6.0) h=0.0; } 

         i = (int)h;
         f = h - i;
         p = v*(1.0-s);
         q = v*(1.0-s*f);
         t = v*(1.0-s*(1.0-f));
              
      switch (i)
	{
	case 0:
	  *r = v;
	  *g = t;
	  *b = p;
	  break;
	case 1:
	  *r = q;
	  *g = v;
	  *b = p;
          break;
	case 2: 
	  *r = p;
	  *g = v;
	  *b = t;
	  break;
	case 3:
	  *r = p;
	  *g = q;
	  *b = v;
	case 4:
	 *r = t;
	 *g = p;
	 *b = v;
         break;
        case 5:
	 *r = v;
	 *g = p;
	 *b = q;
	}
    }
  }
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  create_arrow  ****                     *
 *                                                     *
 *-----------------------------------------------------*/

static create_arrow (obj, x, y, z, v1, scale, normalise, line_cols)
            GEOMobj *obj;            /* output geom object */
            float         x, y, z;   /* arrow position */
            float         v1[3];     /* vector data */
            float         scale;     /* length scale */
            int           normalise; /* normalise option */
            float         line_cols[3]; /* rgb for arrow */
{
  double sqrt();

  float mag, s1, x1, y1, z1, nx, ny, nz, s, vt[3], v2[3], v3[3], vx, vy, vz;
  float verts[20][3], vcolors[20][3], r, g, b;
  int i, n, m, index;
  static float arrow_scale = 0.4;

  /* normalise the vector if option is set (1) */

  if (normalise == 1)
    {
      nx = v1[0]; ny = v1[1]; nz = v1[2];
      mag = sqrt(nx * nx + ny * ny + nz * nz);
      
      /* check we do not divide by zero */

      if (mag != 0)
	{
	  v1[0] = v1[0]/mag;
	  v1[1] = v1[1]/mag;
	  v1[2] = v1[2]/mag;
	}
    }

  index = -1;
  nx = scale * v1[0];
  ny = scale * v1[1];
  nz = scale * v1[2];

  mag = sqrt(nx * nx + ny * ny + nz * nz);

  if (mag == 0.0) {
    n = 0;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    verts[n][0] = x;
    verts[n][1] = y;
    verts[n++][2] = z;
    }
  else {
    s = 0.9;
    s1 = arrow_scale * (1.0 - s) * mag;
    vx = x + s * nx;
    vy = y + s * ny;
    vz = z + s * nz;

    /*  compute v2[] and v3[], which will be 
        the sides of the arrow head.          */

    vt[0] = -v1[1];
    vt[1] = v1[0];
    vt[2] = 0.0;

    if ((vt[0] == 0.0) && (vt[1] == 0.0))
      vt[0] = 1.0;

    vcross_prod (v1, vt, v2);
    vcross_prod (v1, v2, v3);

    vnorm (v2);
    vnorm (v3);

    n = 0;
    verts[n][0] = x, verts[n][1] = y, verts[n++][2] = z;
    verts[n][0] = x1 = x + nx; 
    verts[n][1] = y1 = y + ny;
    verts[n++][2] = z1 = z + nz;

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v2[0];
    verts[n][1] = vy + s1 * v2[1]; 
    verts[n++][2] = vz + s1 * v2[2];

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx + s1 * v3[0]; 
    verts[n][1] = vy + s1 * v3[1];
    verts[n++][2] = vz + s1 * v3[2];

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v2[0];  
    verts[n][1] = vy - s1 * v2[1];
    verts[n++][2] = vz - s1 * v2[2]; 

    verts[n][0] = x1,  verts[n][1] = y1,  verts[n++][2] = z1;  
    verts[n][0] = vx - s1 * v3[0]; 
    verts[n][1] = vy - s1 * v3[1];
    verts[n++][2] = vz - s1 * v3[2]; 


    /*  form the base of the arrow head.  */

    for (m = n, i = 3; i < m; i += 2) {
      verts[n][0] = verts[i][0];  
      verts[n][1] = verts[i][1];  
      verts[n++][2] = verts[i][2];  

      if (i == 9) {
        verts[n][0] = verts[3][0];  
        verts[n][1] = verts[3][1];  
        verts[n++][2] = verts[3][2];  
        }
      else {
        verts[n][0] = verts[i + 2][0];  
        verts[n][1] = verts[i + 2][1];  
        verts[n++][2] = verts[i + 2][2];  
        }
      }
    }

    for (i=0; i<20; i++)
      {
       vcolors[i][0] = line_cols[0];       
       vcolors[i][1] = line_cols[1];       
       vcolors[i][2] = line_cols[2];
     }

    GEOMadd_disjoint_line (obj, verts, vcolors, n, GEOM_COPY_DATA);
}

/* normalize the length of a 3-vector */
static vnorm (v)
        float v[];
{
  double mag, sqrt();

  mag = sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);

  if (mag == 0.0) {
    v[0] = 0.0;
    v[1] = 0.0;
    v[2] = 0.0;
    return (0);
    }
  else {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
    }

  return (1);
}

/* 3-vector cross product */
static vcross_prod (v1,  v2,  v3)
             float *v1, *v2, *v3;
{
  v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
}

/*-----------------------------------------------------*
 *                                                     *
 *        ****  scatter_arrows_desc  ****               *
 *                                                     *
 *-----------------------------------------------------*/
scatter_arrows_desc()
{
  int scatter_arrows(), param;

  /* name on the box */
  AVSset_module_name ("scatter arrows", MODULE_MAPPER);

  /* input ucd structure to draw */
  AVScreate_input_port ("Input",
     "field 1D 3-space irregular float", REQUIRED);

  /* input colormap to colour normalised vectors (optional) */

  AVScreate_input_port ("Input Colormap","colormap",OPTIONAL);

  /* output geomerty to draw */
  AVScreate_output_port ("scatter_arrows", "geom");

  param = AVSadd_float_parameter("Scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
  param = AVSadd_parameter("Normalise Vectors","boolean",0,0,0);

  /* routine pointers */
  AVSset_compute_proc (scatter_arrows);

}  /* end of description routine */

AVSinit_modules()
{
        AVSmodule_from_desc(scatter_arrows_desc);
}






