/*******************************************************************************
 *
 *  These are a set of utility file name routines that can be used by 
 *  user-written AVS modules.
 *
 *	31 May 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 *	16 Mar 92  Phil McDonald		Add file_name_check.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Check a file name and open the file if possible.
 *
 */

FILE	*UTILS_file_name_check (p_file_name, mode, err_msg)

char	**p_file_name, *mode, *err_msg;
{

    register int	n, good_name;
    FILE		*file;

    file = NULL;

    if (*p_file_name != NULL)
    {
        good_name = FALSE;

        n = strlen (*p_file_name);
        while (--n >= 0) if ((*p_file_name)[n] != ' ') break;
        if (n >= 0)
        {
            if (((*p_file_name)[0] != ' ') &&
                ((*p_file_name)[n] != '/')) good_name = TRUE;
        }

        if (good_name)
        {
            if ((file = fopen (*p_file_name, mode)) == NULL)
                AVSerror ("%s\n\n%s\n\n%s", err_msg, *p_file_name,
                          "could not be opened.");
        }
        else
            (*p_file_name)[0] = '\0';
    }



    return (file);
}



/*******************************************************************************
 *
 *  Concatenate a file name to a directory name.
 *
 */

int	UTILS_file_name_dir_add (file_name, file_dir)

char		*file_name, *file_dir;
{

    strcat (file_dir, file_name);

    return (strlen (file_dir));
}



/*******************************************************************************
 *
 *  Extract a file directory name from the file name.
 *
 */

int	UTILS_file_name_dir_get (file_name, file_dir)

char		*file_name, *file_dir;
{
    register int	l_dir;

    strcpy (file_dir, file_name);

    l_dir = strlen (file_dir);
    while (--l_dir >= 0)  if (file_dir[l_dir] != '/') break;
    file_dir[++l_dir] = '\0';

    return (l_dir);
}
