/*******************************************************************************
 *
 *  These are a set of utility vertex chain routines that can be used by 
 *  user-written AVS modules.
 *
 *	13 Mar 92  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Add a vertex to the chain.
 *
 */

int	UTILS_vert_chain_add (xyz)

FLOAT3		xyz;
{
    n_vert_chain++;
    p_vert_chain->next = (vert_chain *) malloc (sizeof (vert_chain));
    p_vert_chain       = p_vert_chain->next;
    p_vert_chain->next = NULL;
    UTILS_float3_copy (xyz, p_vert_chain->verts);

    return (n_vert_chain);
}



/*******************************************************************************
 *
 *  Convert a vertex chain to chain of disjoint line vertices.
 *
 */

int	UTILS_vert_chain_disjoint ()

{

    register int		n_pts;
    register vert_chain		*p_pts, *p_nxt;

    if (p_vert_chain_mark->next == NULL) return (n_vert_chain);

    p_pts = p_vert_chain_mark;
    n_pts = n_vert_chain;

    p_nxt = p_pts->next;
    while (p_nxt->next != NULL)
    {
        n_pts++;
        p_pts->next       = (vert_chain *) malloc (sizeof (vert_chain));
        p_pts->next->next = p_nxt;
        UTILS_float3_copy (p_nxt->verts, p_pts->next->verts);
        p_pts = p_nxt, p_nxt = p_pts->next;
    }

    p_pts = p_vert_chain_mark;
    while (p_pts->next != NULL) p_pts = p_pts->next;
    p_vert_chain = p_pts;
    n_vert_chain = n_pts;

    return (n_vert_chain);
}



/*******************************************************************************
 *
 *  Initialize a vertex chain.
 *
 */

int	UTILS_vert_chain_init ()

{
    n_vert_chain       = 0;
    p_vert_chain       = (vert_chain *) malloc (sizeof (vert_chain));
    p_vert_chain->next = NULL;
    p_vert_chain_start = p_vert_chain;


    return (n_vert_chain);
}




/*******************************************************************************
 *
 *  Mark (remember) the current postion in a vertex chain.
 *
 */

int	UTILS_vert_chain_mark ()

{

    p_vert_chain_mark = p_vert_chain;


    return (n_vert_chain);
}



/*******************************************************************************
 *
 *  Sort the vertices in a vertex chain.
 *
 */

int	UTILS_vert_chain_sort (xyz1, xyz2, i_coord)

FLOAT3		xyz1, xyz2;
int		i_coord;
{

    register int		i, j, n_pts;
    register float		di, dj;
    register vert_chain		*p_pts, *p_nxt, *p_tmp;
    register FLOAT3		xyz;

    p_pts = p_vert_chain_mark;
    n_pts = n_vert_chain;

    i = i_coord, j = 1 - i;

    if (xyz1[i] == xyz2[i]) return (n_vert_chain);

    if (xyz1[i] < xyz2[i])
    {
        while (p_pts != NULL)
        {
            p_nxt = p_tmp = p_pts;
            while ((p_nxt = p_nxt->next) != NULL)
            {
                di = p_pts->verts[i] - p_nxt->verts[i];
                dj = p_pts->verts[j] - p_nxt->verts[j];

                if ((fabs ((double) di) < VERT_CHAIN_PT_FUZZ) &&
                    (fabs ((double) dj) < VERT_CHAIN_PT_FUZZ))
                {
                    n_pts--;
                    p_tmp->next = p_nxt->next;
                    free (p_nxt);
                    p_nxt = p_tmp;
                }
                else if (di > 0.0)
                {
                    UTILS_float3_copy (p_pts->verts, xyz);
                    UTILS_float3_copy (p_nxt->verts, p_pts->verts);
                    UTILS_float3_copy (xyz, p_nxt->verts);
                }
                p_tmp = p_nxt;
            }
            p_pts = p_pts->next;
        }
    }
    else
    {
        while (p_pts != NULL)
        {
            p_nxt = p_tmp = p_pts;
            while ((p_nxt = p_nxt->next) != NULL)
            {
                di = p_pts->verts[i] - p_nxt->verts[i];
                dj = p_pts->verts[j] - p_nxt->verts[j];

                if ((fabs ((double) di) < VERT_CHAIN_PT_FUZZ) &&
                    (fabs ((double) dj) < VERT_CHAIN_PT_FUZZ))
                {
                    n_pts--;
                    p_tmp->next = p_nxt->next;
                    free (p_nxt);
                    p_nxt = p_tmp;
                }
                else if (di < 0.0)
                {
                    UTILS_float3_copy (p_pts->verts, xyz);
                    UTILS_float3_copy (p_nxt->verts, p_pts->verts);
                    UTILS_float3_copy (xyz, p_nxt->verts);
                }
                p_tmp = p_nxt;
            }
            p_pts = p_pts->next;
        }
    }

    p_pts = p_vert_chain_mark;
    while (p_pts->next != NULL) p_pts = p_pts->next;
    p_vert_chain = p_pts;
    n_vert_chain = n_pts;


    return (n_vert_chain);
}



/*******************************************************************************
 *
 *  Copy a vertex chain to the specified vertex list.
 *
 */

int	UTILS_vert_chain_to_vlist (p_vlist)

GEOMvert_list	*p_vlist;
{

    register int	i;
    register FLOAT3	*v_new;

    v_new = (n_vert_chain == 0) ? NULL :
                             (FLOAT3 *) malloc (n_vert_chain * sizeof (FLOAT3));

    i = 0;
    while ((p_vert_chain = p_vert_chain_start->next) != NULL)
    {
        UTILS_float3_copy (p_vert_chain->verts, (v_new+i));
        free (p_vert_chain_start);
        p_vert_chain_start = p_vert_chain;
        i++;
    }
    free (p_vert_chain_start);

    free (p_vlist->l);
    p_vlist->l = (float *) v_new;
    p_vlist->n = n_vert_chain;


    return (n_vert_chain);
}
