/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *
 *  The Surf_Mesh module covers a surface with a rectangular mesh.
 */



#include "avs_utils.h"



char		parm_mesh_x_res[] = "mesh x res";
char		parm_mesh_y_res[] = "mesh y res";
char		parm_mesh_z_res[] = "mesh z res";
char		parm_show_polys[] = "show polygons";



surf_mesh_desc ()

{
    int		surf_mesh_compute ();
    int		out_port, iparm;

    AVSset_module_name ("surface mesh", MODULE_MAPPER);

    AVScreate_input_port ("Input Geom", "geom", REQUIRED | MULTIPLE);

    out_port = AVScreate_output_port ("Output Geom", "geom");

    AVSautofree_output (out_port);

    iparm = AVSadd_parameter (parm_mesh_x_res, "integer", 0, 0, INT_UNBOUND);
    AVSadd_parameter_prop (iparm, "accumulator", "boolean", TRUE);
    AVSadd_parameter_prop (iparm, "local_range", "real", 100.0);
    iparm = AVSadd_parameter (parm_mesh_y_res, "integer", 0, 0, INT_UNBOUND);
    AVSadd_parameter_prop (iparm, "accumulator", "boolean", TRUE);
    AVSadd_parameter_prop (iparm, "local_range", "real", 100.0);
    iparm = AVSadd_parameter (parm_mesh_z_res, "integer", 0, 0, INT_UNBOUND);
    AVSadd_parameter_prop (iparm, "accumulator", "boolean", TRUE);
    AVSadd_parameter_prop (iparm, "local_range", "real", 100.0);
    AVSadd_parameter (parm_show_polys, "boolean", TRUE, FALSE, TRUE);


    AVSset_compute_proc (surf_mesh_compute);

    return;
}



/******************************************************************************/
/*
 *  Inform AVS (the main procedure) of the modules in this file.
 *
 */

static int	((*module_list[])()) =

{
		surf_mesh_desc
};

#define		N_MODULES	(sizeof(module_list) / sizeof(int*))


AVSinit_modules()
{
    AVSinit_from_module_list (module_list, N_MODULES);
    return ;
}



surf_mesh_compute (in_geom, out_geom, i_xres, i_yres, i_zres, show_polys)

GEOMedit_list	in_geom;
GEOMedit_list	*out_geom;
int		i_xres, i_yres, i_zres, show_polys;
{
    static char		obj_name[] = "surface mesh" ;

    static int		jnext[3] = {1, 2, 0};
    int			i, j, j1, j2, n;
    int			npolytri, nptverts, nverts, iptvert, show_mesh;
    FLOAT3		*ptverts, *ptcolors;
    FLOAT3		*verts, *colors;
    FLOAT3		mesh_siz, mesh_min, range, *line_v, *line_c;
    float		xyzmin, xyzmax, extent[6];
    GEOMobj		*in_obj, *out_obj;
    GEOMpolytri		*polytri;




    in_obj = NULL;
    if ((in_geom != NULL) && (in_geom->l != NULL))
        in_obj = (GEOMobj *) in_geom->l->data;
    if (in_obj == NULL)		/* No input geometry */
    {
        if (*out_geom != NULL) GEOMdestroy_edit_list (*out_geom);
        *out_geom = NULL;
        return (1);
    }

    polytri  = NULL;
    npolytri = 0;
    if (in_obj->type == GEOM_POLYTRI) polytri = &in_obj->d.pt;
    if (polytri != NULL) npolytri = polytri->npts;
    if (npolytri == 0)		/* No polytriangle strips */
    {
        if (*out_geom != NULL) GEOMdestroy_edit_list (*out_geom);
        *out_geom = NULL;
        return (1);
    }

    nptverts  = (polytri->ptverts == NULL) ? 0 : polytri->ptverts->n;
    ptverts   = (polytri->ptverts == NULL) ? NULL :
                (FLOAT3 *) polytri->ptverts->l;
    ptcolors  = (polytri->ptcolors == NULL) ? NULL :
                (FLOAT3 *) polytri->ptcolors->l;

    out_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);

    nverts = 4;
    verts  = (FLOAT3 *) malloc (nverts * sizeof (FLOAT3));
    colors = (ptcolors == NULL) ? NULL :
             (FLOAT3 *) malloc (nverts * sizeof (FLOAT3));

    n      = 2;
    line_v = (FLOAT3 *) malloc (n * sizeof (FLOAT3));
    line_c = (colors == NULL) ? NULL : (FLOAT3 *) malloc (n * sizeof (FLOAT3));

    if (in_obj->has_extent)
    {
        for (j = 0; j < 3; j++)
        {
            j1 = j, j2 = j + 3;
            if (in_obj->extent[j1] > in_obj->extent[j2]) j1 = j2, j2 = j;
            extent[j]   = in_obj->extent[j1];
            extent[j+3] = in_obj->extent[j2];
        }
    }
    else
    {
        for (j = 0; j < 3; j++)
            extent[j] = 1.0e+30, extent[j+3] = -extent[j];
        for (i = 0; i < nptverts; i++)
        {
            if (ptverts[i][0] < extent[0]) extent[0] = ptverts[i][0];
            if (ptverts[i][1] < extent[1]) extent[1] = ptverts[i][1];
            if (ptverts[i][2] < extent[2]) extent[2] = ptverts[i][2];
            if (ptverts[i][0] > extent[3]) extent[3] = ptverts[i][0];
            if (ptverts[i][1] > extent[4]) extent[4] = ptverts[i][1];
            if (ptverts[i][2] > extent[5]) extent[5] = ptverts[i][2];
        }
    }

    if (i_xres < 0) i_xres = 0;
    if (i_yres < 0) i_yres = 0;
    if (i_zres < 0) i_zres = 0;
    mesh_siz[0] = i_xres - 1;
    mesh_siz[1] = i_yres - 1;
    mesh_siz[2] = i_zres - 1;
    show_mesh   = 0;
    for (j = 0; j < 3; j++)
    {
        mesh_min[j] = 0.0;
        if (mesh_siz[j] >= 0.0)
        {
            show_mesh = 1;
            if (mesh_siz[j] == 0.0)
                mesh_min[j] = (extent[j+3] + extent[j]) / 2.0;
            else
            {
                mesh_siz[j] = (extent[j+3] - extent[j]) / mesh_siz[j];
                mesh_min[j] = extent[j];
            }
        }
    }


    iptvert = 0;
    while (iptvert < nptverts)
    {
        UTILS_geom_polytri_tri_get (ptverts, ptcolors, &nptverts, &iptvert,
                                   verts, colors, &n);

        if (n == 3)
        {
            UTILS_float3_copy (verts, (verts+3));
            UTILS_float3_copy (colors, (colors+3));

            if (show_polys)
            {

/*
                GEOMadd_polyline (out_obj, verts, colors, nverts, 
                                  GEOM_COPY_DATA);
*/
                if (colors == NULL)
                    for (i = 0; i < 3; i++)
                        GEOMadd_disjoint_line (out_obj, &verts[i][0],
                                               NULL, 2, GEOM_COPY_DATA);
                else
                    for (i = 0; i < 3; i++)
                        GEOMadd_disjoint_line (out_obj, &verts[i][0],
                                               &colors[i][0], 2,
                                               GEOM_COPY_DATA);
            }

            if (show_mesh)
            {

                for (j = 0; j < 3; j++)
                {
                    range[j] = 0.0;
                    if (mesh_siz[j] >= 0.0)
                    {
                        xyzmin = 1.0e+30;
                        xyzmax = -xyzmin;
                        for (i = 0; i < 3; i++)
                        {
                            if (verts[i][j] < xyzmin) xyzmin = verts[i][j];
                            if (verts[i][j] > xyzmax) xyzmax = verts[i][j];
                        }
                        range[j] = xyzmax - xyzmin;
                    }
                }

                for (j = 0; j < 3; j++)
                {
                    j1 = jnext[j];
                    j2 = jnext[j1];

                    if (range[j] > 0.0)
                    {
                        n = -1;
                        mesh_triangle (&verts[0][j], &verts[0][j1],
                                       &verts[0][j2], &colors[0][0],
                                       &mesh_siz[j], &mesh_min[j], &n);

                        while (n != 0)
                        {
                            mesh_triangle (&line_v[0][j], &line_v[0][j1],
                                           &line_v[0][j2], &line_c[0][0],
                                           &mesh_siz[j], &mesh_min[j], &n);
                            if (n == 2)
                            {
                                GEOMadd_disjoint_line (out_obj, line_v, line_c,
                                                       n, GEOM_COPY_DATA);
                            }
                            if (mesh_siz[j] == 0.0) n = 0;
                        }

                    } /* if (range[j] > 0.0) */

                } /* for (j = 0; j < 3; j++) */

            } /* if (show_mesh) */

        } /* if (n == 3) */

    } /* while (iptvert < nptverts) */



    *out_geom = GEOMinit_edit_list (*out_geom);
    GEOMedit_geometry (*out_geom, obj_name, out_obj);
    GEOMdestroy_obj (out_obj);


    return (1);
}



/******************************************************************************/
/*
 *  String a mesh within the specified triangle.
 *
 */

mesh_triangle (px, py, pz, pc, pxres, pxstart, pn)

FLOAT3		*px, *py, *pz, *pc;
float		*pxres, *pxstart;
int		*pn;

{
    static float	x, lims[6][13], ddx[3][5];
    static float	fuzz = 5.0e-05, fuzz_fac = 1.00005;
    float		y, z, dx, xmin, xmax;
    register int	i, j, ii, jj;

    if (*pn < 0)				/* Initialize */
    {
        xmin = 1.0e+30, xmax = -xmin;
        for (i = 0, j = 2; i < 3; i++)
        {
            if (px[j][0] <= px[i][0])
                jj = j, ii = i;
            else
                jj = i, ii = j;

            if (px[jj][0] < xmin) xmin = px[jj][0];
            if (px[ii][0] > xmax) xmax = px[ii][0];
            lims[i][0] = px[jj][0];
            lims[i][1] = py[jj][0];
            lims[i][2] = pz[jj][0];
            lims[i][3] = px[ii][0];
            lims[i][4] = py[ii][0];
            lims[i][5] = pz[ii][0];
            lims[i][6] = 0.0;
            if ((px[ii][0] - px[jj][0]) > fuzz)		/* Not vertical line */
            {
                lims[i][6] = 1.0;
                dx         = px[ii][0] - px[jj][0];
                ddx[i][0]  = (py[ii][0] - py[jj][0]) / dx;
                ddx[i][1]  = (pz[ii][0] - pz[jj][0]) / dx;
                if (pc != NULL)
                {
                    ddx[i][2] = (pc[ii][0] - pc[jj][0]) / dx;
                    ddx[i][3] = (pc[ii][1] - pc[jj][1]) / dx;
                    ddx[i][4] = (pc[ii][2] - pc[jj][2]) / dx;
                }
            }
            if (pc != NULL)
            {
                UTILS_float3_copy (&pc[jj][0], &lims[i][7]);
                UTILS_float3_copy (&pc[ii][0], &lims[i][10]);
            }

            j = i;
        }

        for (i = 0; i < 3; i++)
        {
            if (lims[i][0] == xmin) lims[i][0] -= fuzz;
            if (lims[i][3] == xmax) lims[i][3] += fuzz;
        }
        xmin -= fuzz, xmax += fuzz;

        if (*pxres == 0.0)
            x = *pxstart;
        else
        {
            i = ((xmin - *pxstart) * fuzz_fac) / *pxres;
            x = ((float) i * *pxres) + *pxstart;
        }
        if (x < xmin) x += *pxres;

        *pn = (x <= xmax) ? 999 : 0;
    }

    else
    {
        *pn = 0;

        for (i = 0, j = 3; i < j; i++)
        {
            if ((x >= lims[i][0]) && (x < lims[i][3]))
            {
                if (lims[i][6] != 0.0)		/* Not vertical line */
                {
                    dx = x - lims[i][0];
                    y  = lims[i][1] + (ddx[i][0] * dx);
                    z  = lims[i][2] + (ddx[i][1] * dx);
                    px[*pn][0] = x;
                    py[*pn][0] = y;
                    pz[*pn][0] = z;
                    if (pc != NULL)
                    {
                        pc[*pn][0] = lims[i][7] + (ddx[i][2] * dx);
                        pc[*pn][1] = lims[i][8] + (ddx[i][3] * dx);
                        pc[*pn][2] = lims[i][9] + (ddx[i][4] * dx);
                    }
                    (*pn)++;
                }
                else				/* Vertical line */
                {
                    px[0][0] = x;
                    py[0][0] = lims[i][1];
                    pz[0][0] = lims[i][2];
                    px[1][0] = x;
                    py[1][0] = lims[i][4];
                    pz[1][0] = lims[i][5];
                    if (pc != NULL)
                    {
                        UTILS_float3_copy (&lims[i][7], &pc[0][0]);
                        UTILS_float3_copy (&lims[i][10], &pc[1][0]);
                    }
                    *pn = 2;
                    j   = 0;
                }
            }
        }

        x += *pxres;
    }

    return;
}
