/*******************************************************************************
 *
 *  These are a set of utility LAPS routines that can be used by 
 *  user-written AVS modules.
 *
 *	11 Dec 91  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#include	"avs_utils.h"
#include	"laps_read.h"




/*******************************************************************************
 *
 *  Create a field from a LAPS file
 *
 */

AVSfield	*UTILS_laps_file_to_field (laps_file_name)

char		*laps_file_name;
{
    register int	ierr, ivar;
    int			dims[3], nvar;
    char		**p_p_labels, **p_p_units;
    char		labels[AVS_FIELD_LABEL_LEN];
    char		units[AVS_FIELD_UNIT_LEN];
    float		*p_data;
    AVSfield		*field;

    ierr = laps_read (laps_file_name, &dims[0], &dims[1], &dims[2], &nvar,
                      &p_data, &p_p_labels, &p_p_units);
    if (ierr != LAPS_READ_OK)
    {
        if (ierr == LAPS_READ_FORMAT_ERROR)
            AVSerror ("%s%s%s", "A format error occurred while reading ",
                      "LAPS product file\n\n", laps_file_name);
        else
            AVSerror ("%s%s%s", "An error occurred while reading ",
                      "LAPS product file\n\n", laps_file_name);
        return (NULL);
    }

    if ((field = UTILS_field_create (3, dims, 3, nvar, AVS_TYPE_REAL, UNIFORM))
        == NULL) return (NULL);

    field->field_data_float = p_data;

    UTILS_field_extents_find (field);

    if (p_p_labels != NULL)
    {
        labels[0] = '\0';
        for (ivar = 0; ivar < nvar; ivar++)
        {
            strcat (labels, p_p_labels[ivar]);
            if (ivar != nvar) strcat (labels, FIELD_LABELS_DELIMITER_STR);
        }
        AVSfield_set_labels (field, labels, FIELD_LABELS_DELIMITER_STR);
    }

    if (p_p_units != NULL)
    {
        units[0] = '\0';
        for (ivar = 0; ivar < nvar; ivar++)
        {
            strcat (units, p_p_units[ivar]);
            if (ivar != nvar) strcat (units, FIELD_UNITS_DELIMITER_STR);
        }
        AVSfield_set_units (field, units, FIELD_UNITS_DELIMITER_STR);
    }

    return (field);
}
