/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/******************************************************************************/
/*
 *
 *  The Surf_Web module covers a surface with a web.
 */



#include "avs_utils.h"



char		parm_web_den[] = "web density";



surf_web_desc ()

{
    int		surf_web_compute ();
    int		out_port;

    AVSset_module_name ("surface web", MODULE_MAPPER);

    AVScreate_input_port ("Input Geom", "geom", REQUIRED | MULTIPLE);

    out_port = AVScreate_output_port ("Output Geom", "geom");

    AVSautofree_output (out_port);

    AVSadd_parameter (parm_web_den, "integer", 0, 0, INT_UNBOUND);


    AVSset_compute_proc (surf_web_compute);

    return;
}



/******************************************************************************/
/*
 *  Inform AVS (the main procedure) of the modules in this file.
 *
 */

static int	((*module_list[])()) =

{
		surf_web_desc
};

#define		N_MODULES	(sizeof(module_list) / sizeof(int*))


AVSinit_modules()
{
    AVSinit_from_module_list (module_list, N_MODULES);
    return ;
}



surf_web_compute (in_geom, out_geom, i_den)

GEOMedit_list	in_geom;
GEOMedit_list	*out_geom;
int		i_den;
{
    static char		obj_name[] = "surface web" ;

    int			i, n;
    int			npolytri, nptverts, nverts, iptvert;
    FLOAT3		*ptverts, *ptcolors;
    FLOAT3		*verts, *colors;
    GEOMobj		*in_obj, *out_obj;
    GEOMpolytri		*polytri;




    in_obj = NULL;
    if ((in_geom != NULL) && (in_geom->l != NULL))
        in_obj = (GEOMobj *) in_geom->l->data;
    if (in_obj == NULL)		/* No input geometry */
    {
        if (*out_geom != NULL) GEOMdestroy_edit_list (*out_geom);
        *out_geom = NULL;
        return (1);
    }

    polytri  = NULL;
    npolytri = 0;
    if (in_obj->type == GEOM_POLYTRI) polytri = &in_obj->d.pt;
    if (polytri != NULL) npolytri = polytri->npts;
    if (npolytri == 0)		/* No polytriangle strips */
    {
        if (*out_geom != NULL) GEOMdestroy_edit_list (*out_geom);
        *out_geom = NULL;
        return (1);
    }

    nptverts  = (polytri->ptverts == NULL) ? 0 : polytri->ptverts->n;
    ptverts   = (polytri->ptverts == NULL) ? NULL :
                (FLOAT3 *) polytri->ptverts->l;
    ptcolors  = (polytri->ptcolors == NULL) ? NULL :
                (FLOAT3 *) polytri->ptcolors->l;

    out_obj = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);

    nverts = 4;
    verts  = (FLOAT3 *) malloc (nverts * sizeof (FLOAT3));
    colors = (ptcolors == NULL) ? NULL :
             (FLOAT3 *) malloc (nverts * sizeof (FLOAT3));



    iptvert = 0;
    while (iptvert < nptverts)
    {
        UTILS_geom_polytri_tri_get (ptverts, ptcolors, &nptverts, &iptvert,
                                    verts, colors, &n);

        if (n == 3)
        {
            UTILS_float3_copy (verts, (verts+3));
            UTILS_float3_copy (colors, (colors+3));

/*
            GEOMadd_polyline (out_obj, verts, colors, nverts, 
                              GEOM_COPY_DATA);
*/
            if (colors == NULL)
                for (i = 0; i < 3; i++)
                    GEOMadd_disjoint_line (out_obj, &verts[i][0],
                                           NULL, 2, GEOM_COPY_DATA);
            else
                for (i = 0; i < 3; i++)
                    GEOMadd_disjoint_line (out_obj, &verts[i][0],
                                           &colors[i][0], 2,
                                           GEOM_COPY_DATA);

            if (i_den > 0)
            {
                web_triangle (out_obj, verts, colors, 0, 1, 2, i_den);
                web_triangle (out_obj, verts, colors, 1, 2, 0, i_den);
                web_triangle (out_obj, verts, colors, 2, 1, 0, i_den);
            }

        } /* if (n == 3) */

    } /* while (iptvert < nptverts) */



    *out_geom = GEOMinit_edit_list (*out_geom);
    GEOMedit_geometry (*out_geom, obj_name, out_obj);
    GEOMdestroy_obj (out_obj);


    return (1);
}


/******************************************************************************/
/*
 *  String a web within the specified triangle.
 *
 */

web_triangle (out_obj, verts, colors, i1, i2, i3, n_web)

GEOMobj		*out_obj;
FLOAT3		verts[3], colors[3];
int		i1, i2, i3, n_web;

{
    register FLOAT3	line_v[2], line_c[2], dxyz, drgb, *plc;
    float		frac;
    register int	i_ray;

    frac    = 1.0 / ((float) (n_web + 1));
    dxyz[0] = (verts[i3][0] - verts[i2][0]) * frac;
    dxyz[1] = (verts[i3][1] - verts[i2][1]) * frac;
    dxyz[2] = (verts[i3][2] - verts[i2][2]) * frac;

    UTILS_float3_copy (&verts[i1][0], &line_v[0][0]);
    UTILS_float3_copy (&verts[i2][0], &line_v[1][0]);

    plc = NULL;
    if (colors != NULL)
    {
        plc = line_c;

        drgb[0] = (colors[i3][0] - colors[i2][0]) * frac;
        drgb[1] = (colors[i3][1] - colors[i2][1]) * frac;
        drgb[2] = (colors[i3][2] - colors[i2][2]) * frac;

        UTILS_float3_copy (&colors[i1][0], &line_c[0][0]);
        UTILS_float3_copy (&colors[i2][0], &line_c[1][0]);
    }

    for (i_ray = n_web; i_ray > 0; i_ray--)
    {
        line_v[1][0] += dxyz[0];
        line_v[1][1] += dxyz[1];
        line_v[1][2] += dxyz[2];
        if (plc != NULL)
        {
            line_c[1][0] += drgb[0];
            line_c[1][1] += drgb[1];
            line_c[1][2] += drgb[2];
        }
        GEOMadd_disjoint_line (out_obj, line_v, plc, 2, GEOM_COPY_DATA);
    }

    return;

}
