#include	<stdio.h>
#include	"laps_read.h"






/******************************************************************************/

int		laps_read (laps_file_name, p_nx, p_ny, p_nz, p_nvar, p_p_data,
                           p_p_p_labels, p_p_p_units)

char		*laps_file_name;
int		*p_nx, *p_ny, *p_nz, *p_nvar;
float		**p_p_data;
char		***p_p_p_labels, ***p_p_p_units;
{

    register int	i, j, k, n;
    register float	*p_dat, *p_flt;
    int			nbytes, nx, ny, nz, nvar, nblk, ivar, error;
    FILE		*laps_file;

    char		*record;
    char		flag;
    char		prod_date[12], prod_time[7], prod_vers[5];
    char		prod_nums[16];
    int			irec, nlev[20];
    char		var_type[4], var_levl[5], var_vert[5], var_unit[11];
    char		var_irec[5];
    char		var_comm[126], old_type[4], old_levl[5];

    *p_nx = *p_ny = *p_nz = *p_nvar = 0;
    *p_p_data = NULL;
    *p_p_p_labels = *p_p_p_units = NULL;



    if ((laps_file = fopen (laps_file_name, "r")) == NULL)
        return (LAPS_READ_OPEN_ERROR);

/*  Read file header	*/

    if (fscanf (laps_file, "%c%15c", &flag, prod_nums) == EOF)
        return (LAPS_READ_REC_ERROR);

    prod_nums[15] = '\0', sscanf ((prod_nums+11), "%d", &nblk);
    prod_nums[11] = '\0', sscanf ((prod_nums+ 7), "%d", &ny);
    prod_nums[ 7] = '\0', sscanf ((prod_nums+ 0), "%d", &nx);

    nbytes = (nx * sizeof (float)) + 4;
    record = (char *) malloc (nbytes);

    error = laps_read_rec (laps_file, (nbytes-16), record, *p_p_data);
    if (error != LAPS_READ_OK) return (error);

    prod_date[11] = prod_time[6] = prod_vers[4] = '\0';

    strncpy (prod_date, (record+ 0), 11);
    strncpy (prod_time, (record+11),  6);
    strncpy (prod_vers, (record+17),  4);

    if (flag != LAPS_READ_HDR_FLAG)
    {
        fclose (laps_file);
        free (record);
        return (LAPS_READ_FORMAT_ERROR);
    }

    var_type[3] = var_levl[4] = var_vert[4] = var_unit[10]= var_irec[4] =
                  var_comm[125] = '\0';

    old_type[0] = old_levl[0] = '\0';
    nvar = -1;
    nz   = 0;
    for (i = 0; i < nblk; i++)
    {
        error = laps_read_rec (laps_file, nbytes, record, *p_p_data);
        if (error != LAPS_READ_OK) return (error);

        flag = record[0];
        strncpy (var_type, (record+ 1),   3);
        strncpy (var_levl, (record+ 4),   4);
        strncpy (var_vert, (record+ 8),   4);
        strncpy (var_unit, (record+12),  10);
        strncpy (var_irec, (record+22),   4);
        strncpy (var_comm, (record+26), 125);
        sscanf (var_irec, "%d", &irec);

        if (strcmp (var_type, old_type) == 0)
        {
            if (strcmp (var_levl, old_levl) != 0)
            {
               strcpy (old_levl, var_levl);
               nz++;
            }
        }
        else
        {
            if (nvar >= 0) nlev[nvar] = nz;
            nvar++;

            if (*p_p_p_labels == NULL) *p_p_p_labels =
                (char **) calloc (LAPS_READ_MAX_VAR, sizeof (char *));
            j = strlen (var_type);
            while ((--j >= 0) && isspace (var_type[j]));
            j++;
            k = strlen (var_comm);
            while ((--k >= 0) && isspace (var_comm[k]));
            k++;
            n = j + k;
            if ((j > 0) && (k > 0)) n += 2;
            if (n > LAPS_READ_LABELS_LEN)
            {
                n = LAPS_READ_LABELS_LEN;
                if ((j > 0) && (k > 0)) n -= 2;
                k = (j < n) ? n - j : 0;
            }
            n = j + k;
            if ((j > 0) && (k > 0)) n += 2;
            (*p_p_p_labels)[nvar] = (char *) calloc ((n+1), sizeof (char *));
            if (j > 0) strncat ((*p_p_p_labels)[nvar], var_type, j);
            if ((j > 0) && (k > 0)) strcat ((*p_p_p_labels)[nvar], ", ");
            if (k > 0) strncat ((*p_p_p_labels)[nvar], var_comm, k);

            if (*p_p_p_units == NULL) *p_p_p_units =
                (char **) calloc (LAPS_READ_MAX_VAR, sizeof (char *));
            n = strlen (var_unit);
            while ((--n >= 0) && isspace (var_unit[n]));
            var_unit[++n] = '\0';
            (*p_p_p_units)[nvar] = (char *) calloc ((n+1), sizeof (char));
            strcpy ((*p_p_p_units)[nvar], var_unit);

            nz = 1;
            strcpy (old_type, var_type);
            strcpy (old_levl, var_levl);
        }
    }
    if (nvar >= 0) nlev[nvar] = nz;
    nvar++;
    nz = 0;
    for (ivar = 0; ivar < nvar; ivar++)
        if (nlev[ivar] > nz) nz = nlev[ivar];


/*  Allocate space for data and copy from LAPS file.	*/

    n = nx * ny * nz * nvar;
    if ((*p_p_data = (float *) calloc (n, sizeof (float))) == NULL)
    {
        free (record);
        return (LAPS_READ_ALLOC_ERROR);
    }


    for (ivar = 0; ivar < nvar; ivar++)
    {
        p_dat = *p_p_data + ivar;

        for (k = 0; k < nlev[ivar]; k++)
        {
            for (j = 0; j < ny; j++)
            {
                error = laps_read_rec (laps_file, nbytes, record, *p_p_data);
                if (error != LAPS_READ_OK) return (error);

                p_flt = (float *) (record + 4);

                vax_r4_to_float_blk (p_flt, (long) nx);

                for (i = 0; i < nx; i++, p_dat += nvar, p_flt++)
                    *p_dat = *p_flt;
            }
        }
    }

    fclose (laps_file);
    free (record);

    *p_nx   = nx;
    *p_ny   = ny;
    *p_nz   = nz;
    *p_nvar = nvar;

    return (LAPS_READ_OK);
}



int		laps_read_rec (laps_file, nbytes, record, p_data)

FILE		*laps_file;
int		nbytes;
char		*record;
float		*p_data;
{

    if (fread (record, 1, nbytes, laps_file) != nbytes)
    {
        fclose (laps_file);
        free (record);
        if (*p_data != NULL) free (*p_data);
        return (LAPS_READ_REC_ERROR);
    }

    return (LAPS_READ_OK);
}
