/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>

/******************************************************************************/
/*  Author:  Lars M Bishop, National Center for Computational Electronics
 *    University of Illinois at Urbana Champaign
 */

/* Tracer Volume Bounds - This module takes in a 3D Uniform 4 vector Byte field,
 * and adds a frame to the edges.  It is designed to be applied to a volume of
 * data right before it is sent to the tracer module, and allows the addition
 * of lines that look like the geometry viewer's volume bounds, which are
 * normally inaccessible to volume-traced data.
 * It also includes the ability to fill in the min X,Y, or Z walls, as the
 * original volume bounds module does.
 */

/* 
 * The function AVSinit_modules is called from the main() routine supplied
 * by AVS.  In it, we call AVSmodule_from_desc with the name of our 
 * description routine.
 */

AVSinit_modules()
{
	int tracer_bounds();

	AVSmodule_from_desc(tracer_bounds);
}

/*  The routine "threshold" is the description routine.  */

tracer_bounds()
{
	int tracer_bounds_compute();	/* declare the compute function (below) */
	int in_port, out_port;	/* temporaries to hold the port numbers */

	/* Set the module name and type */
	AVSset_module_name("tracer bounds", MODULE_MAPPER);

	/* Create an input port for the required field input */
	in_port =
		AVScreate_input_port("Input Field",
				     "field 3D 4-vector byte", REQUIRED);

	/* Create an output port for the result */
	out_port = AVScreate_output_port("Output Field",
					 "field 3D 4-vector byte");


	AVSadd_parameter("thickness","integer",1,0,10);
	AVSadd_float_parameter("opacity scale",1.0,0.0,1.0);
	AVSadd_parameter("min x","boolean",0,0,1);
	AVSadd_parameter("min y","boolean",0,0,1);
	AVSadd_parameter("min z","boolean",0,0,1);

	AVSinitialize_output(in_port, out_port);

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(tracer_bounds_compute);
}


tracer_bounds_compute(input, output, width, opacity, x_min, y_min, z_min)
AVSfield_char *input, **output;
int width;
float *opacity;
int x_min, y_min, z_min;
{
    register int i, j, k, u, num_points;

    if(input->uniform == IRREGULAR)     
      {
	AVSwarning("Irregular Data is not supported by this module");
	return(0);
      }

    /* copies the data to the new block, with the opacity
       scaled by the opacity parameter */
    for (k = 0; k < MAXZ(input); k++)
      for (j = 0; j < MAXY(input); j++)
	for (i = 0; i < MAXX(input); i++)
	  {
	    for(u=1; u < 4; u++)
	      (I3DV(*output, i, j, k))[u] = (I3DV(input, i, j, k))[u];
	    (I3DV(*output, i, j, k))[0] = (float)(I3DV(input, i, j, k))[0] * (*opacity);
	  }
    
    /* Creates the frame outline of the volume bound */
     for (k = 0; k < MAXZ(input); k++)
       for(j=0; j<width; j++)
	 for(u=0; u<width; u++)
       {
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, 0+j, 0+u, k))[i] = 255;
	     (I3DV(*output, 0+j, MAXY(input)-1-u, k))[i] = 255;
	     (I3DV(*output, MAXX(input)-1-j, 0+u, k))[i] = 255;
	     (I3DV(*output, MAXX(input)-1-j, MAXY(input)-1-u, k))[i] = 255;
	   }
       }
     for (k = 0; k < MAXY(input); k++)
       for(j=0; j<width; j++)
	 for(u=0; u<width; u++)
       {
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, 0+j, k, 0+u))[i] = 255;
	     (I3DV(*output, 0+j, k, MAXZ(input)-1-u))[i] = 255;
	     (I3DV(*output, MAXX(input)-1-j, k, 0+u))[i] = 255;
	     (I3DV(*output, MAXX(input)-1-j, k, MAXZ(input)-1-u))[i] = 255;
	   }
       }
     for (k = 0; k < MAXX(input); k++)
       for(j=0; j<width; j++)
	 for(u=0; u<width; u++)
       {
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, k, 0+j, 0+u))[i] = 255;
	     (I3DV(*output, k, 0+j, MAXZ(input)-1-u))[i] = 255;
	     (I3DV(*output, k, MAXY(input)-1-j, 0+u))[i] = 255;
	     (I3DV(*output, k, MAXY(input)-1-j, MAXZ(input)-1-u))[i] = 255;
	   }
       }

    /* if selected, creates the minimum X value wall */
    if(x_min)
     for (j = 0; j < MAXY(input); j++)
       for (k = 0; k < MAXZ(input); k++)
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, 0,j,k))[i] = 255;
	     (I3DV(*output, 0,j,k))[i] = 255;
	     (I3DV(*output, 0,j,k))[i] = 255;
	     (I3DV(*output, 0,j,k))[i] = 255;
	   }

    /* if selected, creates the minimum Y value wall */
    if(y_min)
     for (j = 0; j < MAXX(input); j++)
       for (k = 0; k < MAXZ(input); k++)
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, j,0,k))[i] = 255;
	     (I3DV(*output, j,0,k))[i] = 255;
	     (I3DV(*output, j,0,k))[i] = 255;
	     (I3DV(*output, j,0,k))[i] = 255;
	   }

    /* if selected, creates the minimum Z value wall */
    if(z_min)
     for (j = 0; j < MAXX(input); j++)
       for (k = 0; k < MAXY(input); k++)
	 for(i=0; i<4; i++)
	   {
	     (I3DV(*output, j,k,0))[i] = 255;
	     (I3DV(*output, j,k,0))[i] = 255;
	     (I3DV(*output, j,k,0))[i] = 255;
	     (I3DV(*output, j,k,0))[i] = 255;
	   }

    /* When we're done, we return 1 to indicate success */
    return(1);
}





