/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* xform_tool.c -- mapper module for AVS ver 2.0 (4/7/93)
*
*  Copyright 1993 by University of California Regents, and Tim O. Robinson
*
*  Author info:
*  Tim O. Robinson			(timro@cchem.berkeley.edu)
*  410 Latimer Hall
*  College of Chemistry, UCB
*  Berkeley, CA 94720
*
*/

#include <stdio.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/udata.h>
#include <string.h>

AVSinit_modules()
{
/* set up descriptions for all modules in this executable */
   int module_desc1();
   AVSmodule_from_desc(module_desc1);
}

module_desc1()
{
/* module description 1 */
   int geom_spec();
   int p;

   AVSset_module_name("transform tool", MODULE_MAPPER);
   p = AVScreate_input_port("Transform","struct upstream_transform", 
		GEOM_NULL);	
   p = AVScreate_output_port("Control List", "geom");
   p = AVScreate_output_port("Move List","geom");
   p = AVSadd_parameter("control object name","string","",NULL,NULL);
   AVSconnect_widget(p,"typein");
   p = AVSadd_parameter("object to move","string","",NULL,NULL);
   AVSconnect_widget(p,"typein");

   AVSset_compute_proc(geom_spec);
}

geom_spec(trans_info, geom_out, geom_out_xform, name, name2)
upstream_transform *trans_info;
GEOMedit_list *geom_out, *geom_out_xform;
char *name, *name2;
{

if (strcmp(name,""))  {
*geom_out = GEOMinit_edit_list(*geom_out);
GEOMedit_transform_mode(*geom_out, name, "notify", BUTTON_UP);
}

if ((strcmp(name2,"")) && (trans_info)) {
*geom_out_xform = GEOMinit_edit_list(*geom_out_xform);
GEOMedit_set_matrix(*geom_out_xform, name2, trans_info->msxform);
}

return(1);
}
