C   
C     This software is copyright (C) 1992,  Regents  of  the
C University  of  California.   Anyone may reproduce trivar_f.f,
C the software in this distribution, in whole or in part, pro-
C vided that:
C
C (1)  Any copy  or  redistribution  of  trivar_f.f  must  show  the
C     Regents  of  the  University of California, through its
C     Lawrence Berkeley Laboratory, as the source,  and  must
C     include this notice;
C
C (2)  Any use of this software must reference this  distribu-
C     tion,  state that the software copyright is held by the
C     Regents of the University of California, and  that  the
C     software is used by their permission.
C
C     It is acknowledged that the U.S. Government has  rights
C in  trivar_f.f  under  Contract DE-AC03-765F00098 between the U.S.
C Department of Energy and the University of California.
C
C     trivar_f.f is provided as a professional  academic  contribu-
C tion  for  joint exchange.  Thus it is experimental, is pro-
C vided ``as is'', with no warranties of any kind  whatsoever,
C no  support,  promise  of updates, or printed documentation.
C The Regents of the University of California  shall  have  no
C liability  with respect to the infringement of copyrights by
C trivar_f.f, or any part thereof.     
C
C Author:
C	Wes Bethel   
C	Lawrence Berkeley Laboratory
C	1 Cyclotron Rd.   Mail Stop 50-F
C	Berkeley CA 94720
C	510-486-6626
C	ewbethel@lbl.gov
C


      subroutine vector_square(w,n)
      real w(n)
      integer n

      integer ii
      do ii=1,n
         w(ii) = w(ii) ** 2
      end do
      return
      end

      subroutine vector_scalar_diff(s,v,w,n)
      real s, v(n), w(n)
      integer n

      integer ii

      do ii=1,n
         w(ii) = v(ii) - s
      end do
      return
      end



      subroutine vector_3add(a,b,c,n)
      real a(n),b(n),c(n)
      integer n

      integer ii

      do ii=1,n
         a(ii) = a(ii) + b(ii) + c(ii)
      end do
      return
      end

      subroutine vector_threshold(w,n,t)
      real w(n),t
      integer n

      integer ii
      
      do ii=1,n
         if (w(ii) .gt. t) then
            w(ii) = 0.0
         endif
      end do
      return
      end

      subroutine vector_power_inverse(w,n,wf)
      real w(n),wf
      integer n
      integer ii
      do ii=1,n
         w(ii) = 1. / (w(ii) ** wf)
      end do
      return
      end

      subroutine vector_sum(w,n,s)
      real w(n),s
      integer n
      integer ii
      s = 0.0
      do ii=1,n
         s = s + w(ii)
      end do
      return
      end

      subroutine vector_scale_sum(v,n,s,sum)
      real v(n),s(n),sum
      integer n
      integer ii
      sum = 0.0
      do ii=1,n
         sum = sum + v(ii) * s(ii)
      end do
      return
      end
         
