/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#ifdef SCCS
static char sccsid[]="@(#)hex.c	5.0  Jonathan Cox 21/08/92";
#endif
/*
 * FILE: hex.c
 * 
 * DESCRIPTION
 * 
 * Creates an include file that defines a table of cases for cutting
 * a hexahedron.
 * 
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 
 */

#include <stdio.h>

typedef struct _cutting_info {
  int edges[6][2];
  int nvert;
} cutting_info;

typedef struct _edge {
  int number;
  int cut;
  int written;
  struct _face *faces[2];
} edge;

typedef struct _face {
  int number;
  int cut;
  struct _edge *edges[4];
} face;

static edge edgelist[12];
static face facelist[6];

static int Hex_Edges[12][2] = {
  0, 1,
  4, 5,
  3, 2,
  7, 6,
  0, 4,
  1, 5,
  3, 7,
  2, 6,
  2, 1,
  6, 5,
  3, 0,
  7, 4
};

static int Mid_Edge_Nodes[12] =
{ 8, 12, 10, 14, 16, 17, 19, 18, 9, 13, 11, 15 };

init_lists()
{
  int e, f;

  edgelist[0].faces[0] = facelist + 0;
  edgelist[0].faces[1] = facelist + 1;
  edgelist[1].faces[0] = facelist + 4;
  edgelist[1].faces[1] = facelist + 0;
  edgelist[2].faces[0] = facelist + 1;
  edgelist[2].faces[1] = facelist + 5;
  edgelist[3].faces[0] = facelist + 5;
  edgelist[3].faces[1] = facelist + 4;
  edgelist[4].faces[0] = facelist + 3;
  edgelist[4].faces[1] = facelist + 0;
  edgelist[5].faces[0] = facelist + 0;
  edgelist[5].faces[1] = facelist + 2;
  edgelist[6].faces[0] = facelist + 5;
  edgelist[6].faces[1] = facelist + 3;
  edgelist[7].faces[0] = facelist + 2;
  edgelist[7].faces[1] = facelist + 5;
  edgelist[8].faces[0] = facelist + 2;
  edgelist[8].faces[1] = facelist + 1;
  edgelist[9].faces[0] = facelist + 4;
  edgelist[9].faces[1] = facelist + 2;
  edgelist[10].faces[0] = facelist + 1;
  edgelist[10].faces[1] = facelist + 3;
  edgelist[11].faces[0] = facelist + 3;
  edgelist[11].faces[1] = facelist + 4;

  facelist[0].edges[0] = edgelist + 0;
  facelist[0].edges[1] = edgelist + 1;
  facelist[0].edges[2] = edgelist + 4;
  facelist[0].edges[3] = edgelist + 5;
  facelist[1].edges[0] = edgelist + 0;
  facelist[1].edges[1] = edgelist + 2;
  facelist[1].edges[2] = edgelist + 8;
  facelist[1].edges[3] = edgelist + 10;
  facelist[2].edges[0] = edgelist + 5;
  facelist[2].edges[1] = edgelist + 7;
  facelist[2].edges[2] = edgelist + 8;
  facelist[2].edges[3] = edgelist + 9;
  facelist[3].edges[0] = edgelist + 4;
  facelist[3].edges[1] = edgelist + 6;
  facelist[3].edges[2] = edgelist + 10;
  facelist[3].edges[3] = edgelist + 11;
  facelist[4].edges[0] = edgelist + 1;
  facelist[4].edges[1] = edgelist + 3;
  facelist[4].edges[2] = edgelist + 9;
  facelist[4].edges[3] = edgelist + 11;
  facelist[5].edges[0] = edgelist + 2;
  facelist[5].edges[1] = edgelist + 3;
  facelist[5].edges[2] = edgelist + 6;
  facelist[5].edges[3] = edgelist + 7;

  for (e=0; e < 12; e++)
    edgelist[e].number = e;
  for (f=0; f < 6; f++)
    facelist[f].number = f;
}

int test(s, node)
int s;
int node;
{
  return (s & (1 << node)) >> node;
}

int write_verticies(current_edge, current_face, start_edge, edge_list, nvert)
edge *current_edge;
face *current_face;
edge *start_edge;
int edge_list[6];
int *nvert;
{
  int i;
  edge *next_edge, *test_edge;
  face *next_face;

  edge_list[(*nvert)] = current_edge->number;
  current_edge->written = 1;
  (*nvert)++;
  next_edge = 0;
  for (i=0; i<4; i++)
    {
      test_edge = current_face->edges[i];
      if (test_edge == current_edge || !test_edge->cut)
	continue;
      if (next_edge || test_edge->written && test_edge != start_edge)
	return 1;
      next_edge = test_edge;
    }
  if (!next_edge) return 2;
  current_face->cut = 1;
  if (next_edge == start_edge) return 0;
  next_face = (next_edge->faces[0] == current_face) ?
    next_edge->faces[1] : next_edge->faces[0];
  if (next_face->cut) return 3;
  return write_verticies(next_edge, next_face, start_edge, edge_list, nvert);
}

write_edge(valid, e)
int valid;
int e;

{
  if (valid)
    printf("%d,%d,%-2d", Hex_Edges[e][0], Hex_Edges[e][1], Mid_Edge_Nodes[e]);
  else
    printf("0,0,0 ");
}


write_polygon(start_edge, s)
edge *start_edge;
int s;
{
  int err, i, nvert, edge_list[6];

  nvert = 0;
  if (start_edge)
    err = write_verticies(start_edge, start_edge->faces[0], start_edge,
			  edge_list, &nvert);
  printf("  { { ");
  for (i=0; i < 5; i++)
    {
      write_edge(i < nvert, edge_list[i]);
      printf(", ");
    }
  write_edge(nvert == 6, edge_list[5]);
  printf(" }, %d}", err ? 0 : nvert);
  if (s < 255)
    printf(",");
  if (start_edge)
    {
      if (!err)
	printf("\t/* %d: yes */\n", s);
      else
	printf("\t/* %d: err %d! */\n", s, err);
    }
  else
    printf("\t/* %d: no */\n", s);
}

main()
{
  int e, f, s;
  edge *start_edge;

  init_lists();

  printf("static cutting_info Hex_Table[256] = {\n");

  for (s=0; s < 256; s++)
    {
      for (e=0; e < 12; e++)
	{
	  edgelist[e].cut =
	    test(s, Hex_Edges[e][0]) ^ test(s, Hex_Edges[e][1]);
	  edgelist[e].written = 0;
	}
      for (f=0; f < 6; f++)
	{
	  facelist[f].cut = 0;
	}
      e = 0;
      start_edge = edgelist;
      while (e++ < 12 && ! start_edge->cut)
	start_edge++;
      write_polygon(e < 12 ? start_edge : 0, s);
    }
  printf("};\n\n");
  return 0;
}

