#ifdef SCCS
static char sccsid[]="@(#)utils.c	5.4  Jonathan Cox 26/07/93";
#endif
/*
 * FILE: utils.c
 *
 * DESCRIPTION
 * 
 * Common utility routines for the two modules.
 *
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 5.1 - Jonathan Cox.  Fixed problem with dissapearing input ports.
 * 5.2 - Jonathan Cox.  Made module cooperative and rentrant.
 * 5.3 - Jonathan Cox.  ANSI C.
 * 5.4 - Jonathan Cox.  Added code for the generation of contours.
 * 
 */

/*
 * Include Files.
 */
#include <stdio.h>

#include <avs.h>
#include <geom.h>
#include <udata.h>

#include "utils.h"
#include "mat.h"

/*
 * Coordinates of the origin.
 */
float Origin[3] = {
  0.0, 0.0, 0.0
};

/*
 * RGB definition of the colour white.
 */
float White[3] = {
  1.0, 1.0, 1.0
};

/*
 * Array to generate points of a square as a polytriangle.
 */
static int Square_Signs[4][3] = {
  -1, -1, 0,
  1, -1, 0,
  -1, 1, 0,
  1, 1, 0
};



int add_square(GEOMobj *obj, float centre[3], float size, int axis, float
	       (*matrix)[4])
{
  register int i, j;
  float vertices[4][3];

  for (i=0; i<3; i++)
    for (j=0; j<4; j++)
      vertices[j][i] = centre[i] + size*Square_Signs[j][(i+2-axis)%3];

  /*
   * If the probe transformation mode is 'redirect' then we have to transform
   * the vertices manually.
   */
  if (matrix)
    for (j=0; j<4; j++)
      mat_vecmul(vertices[j], matrix);
  
  GEOMadd_polytriangle(obj, (float *)vertices, NULL, NULL, 4, GEOM_COPY_DATA);
}


int get_trans_info_flag(upstream_transform *trans_info)
{
  if (!trans_info ||
      !AVSinput_changed("transformation info", 0) ||
      strncmp(trans_info->object_name, "Probe", 5))
    return 0;
  return trans_info->flags;
} 
