/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#ifdef SCCS
static char sccsid[]="@(#)utils.c 6.0  Jonathan Cox 29/10/93";
#endif
/*
 * FILE: utils.c
 *
 * DESCRIPTION
 * 
 * Common utility routines for the two modules.
 *
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 5.1 - Jonathan Cox.  ANSI C.
 * 6.0 - Jonathan Cox.  Second version for general release.
 * 
 */

/*
 * Include Files.
 */
#include <stdio.h>

#include <avs.h>
#include <geom.h>
#include <udata.h>

#include "utils.h"
#include "mat.h"

/*
 * Coordinates of the origin.
 */
float Origin[3] = {
  0.0, 0.0, 0.0
};

/*
 * RGB definition of the colour white.
 */
float White[3] = {
  1.0, 1.0, 1.0
};

/*
 * Array to generate points of a square as a polytriangle.
 */
static int Square_Signs[4][3] = {
  -1, -1, 0,
  1, -1, 0,
  -1, 1, 0,
  1, 1, 0
};



int add_square(obj, centre, size, axis, 
	       matrix)
GEOMobj *obj; float centre[3]; float size; int axis; float
	       (*matrix)[4];
{
  register int i, j;
  float vertices[4][3];

  for (i=0; i<3; i++)
    for (j=0; j<4; j++)
      vertices[j][i] = centre[i] + size*Square_Signs[j][(i+2-axis)%3];

  /*
   * If the probe transformation mode is 'redirect' then we have to transform
   * the vertices manually.
   */
  if (matrix)
    for (j=0; j<4; j++)
      mat_vecmul(vertices[j], matrix);
  
  GEOMadd_polytriangle(obj, (float *)vertices, NULL, NULL, 4, GEOM_COPY_DATA);
}


int get_trans_info_flag(trans_info)
upstream_transform *trans_info;
{
  if (!trans_info ||
      !AVSinput_changed("transformation info", 0) ||
      strncmp(trans_info->object_name, "Probe", 5))
    return 0;
  return trans_info->flags;
} 
