/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
static char sccsid[]="@(#)cut_ucd.c 6.0  Jonathan Cox 29/10/93";
/*
 * FILE: cut_ucd.c
 * 
 * DESCRIPTION
 * 
 * Cutting cases for 3D UCD cells.  Each cutting case is characterised by a
 * number from 0 to 2**(number_of_nodes)-1.  Each bit in this number
 * corresponds to the respective vertex being above or below the plane.  Given
 * this number the tables below can be used to generate a list of edges which
 * form the intersecting polygon.  Edges are describe by a triple of vertices
 * being the two end nodes and the mid edge node.
 * 
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 5.1 - Jonathan Cox.  ANSI C.
 * 6.0 - Jonathan Cox.  Second version for general release.
 * 
 */

#include "cut_ucd.h"

cutting_info Tet_Table[16] = {
  { { 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0 } ,0},
  { { 0,1,4, 0,2,5, 0,3,6, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,1,4, 1,2,7, 1,3,9, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,2,5, 0,3,6, 1,3,9, 1,2,7, 0,0,0, 0,0,0 } ,4},
  { { 0,2,5, 1,2,7, 2,3,8, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,1,4, 1,2,7, 2,3,8, 0,3,6, 0,0,0, 0,0,0 } ,4},
  { { 0,1,4, 0,2,5, 2,3,8, 1,3,9, 0,0,0, 0,0,0 } ,4},
  { { 1,3,9, 2,3,8, 0,3,6, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 1,3,9, 2,3,8, 0,3,6, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,1,4, 0,2,5, 2,3,8, 1,3,9, 0,0,0, 0,0,0 } ,4},
  { { 0,1,4, 1,2,7, 2,3,8, 0,3,6, 0,0,0, 0,0,0 } ,4},
  { { 0,2,5, 1,2,7, 2,3,8, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,2,5, 0,3,6, 1,3,9, 1,2,7, 0,0,0, 0,0,0 } ,4},
  { { 0,1,4, 1,2,7, 1,3,9, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,1,4, 0,2,5, 0,3,6, 0,0,0, 0,0,0, 0,0,0 } ,3},
  { { 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0 } ,0}
};


cutting_info Pry_Table[32] = {
  { { 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0  }, 0},
  { { 0,1,5 , 0,2,6 , 0,3,7 , 0,4,8 , 0,0,0 , 0,0,0  }, 4},
  { { 1,4,12, 1,2,9 , 0,1,5 , 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 1,2,9 , 0,2,6 , 0,3,7 , 0,4,8 , 1,4,12, 0,0,0  }, 5},
  { { 0,2,6 , 1,2,9 , 2,3,10, 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 2,3,10, 0,3,7 , 0,4,8 , 0,1,5 , 1,2,9 , 0,0,0  }, 5},
  { { 2,3,10, 1,4,12, 0,1,5 , 0,2,6 , 0,0,0 , 0,0,0  }, 4},
  { { 1,4,12, 2,3,10, 0,3,7 , 0,4,8 , 0,0,0 , 0,0,0  }, 4},
  { { 2,3,10, 3,4,11, 0,3,7 , 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 3,4,11, 0,4,8 , 0,1,5 , 0,2,6 , 2,3,10, 0,0,0  }, 5},
  { { 1,4,12, 0,1,5 , 1,2,9 , 2,3,10, 0,3,7 , 3,4,11 }, 6},
  { { 3,4,11, 0,4,8 , 1,4,12, 1,2,9 , 0,2,6 , 2,3,10 }, 6},
  { { 1,2,9 , 0,2,6 , 0,3,7 , 3,4,11, 0,0,0 , 0,0,0  }, 4},
  { { 3,4,11, 0,4,8 , 0,1,5 , 1,2,9 , 0,0,0 , 0,0,0  }, 4},
  { { 1,4,12, 0,1,5 , 0,2,6 , 0,3,7 , 3,4,11, 0,0,0  }, 5},
  { { 1,4,12, 0,4,8 , 3,4,11, 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 1,4,12, 0,4,8 , 3,4,11, 0,0,0 , 0,0,0 , 0,0,0  }, 3},  
  { { 1,4,12, 0,1,5 , 0,2,6 , 0,3,7 , 3,4,11, 0,0,0  }, 5},
  { { 3,4,11, 0,4,8 , 0,1,5 , 1,2,9 , 0,0,0 , 0,0,0  }, 4},
  { { 1,2,9 , 0,2,6 , 0,3,7 , 3,4,11, 0,0,0 , 0,0,0  }, 4},
  { { 3,4,11, 0,4,8 , 1,4,12, 1,2,9 , 0,2,6 , 2,3,10 }, 6},
  { { 1,4,12, 0,1,5 , 1,2,9 , 2,3,10, 0,3,7 , 3,4,11 }, 6},
  { { 3,4,11, 0,4,8 , 0,1,5 , 0,2,6 , 2,3,10, 0,0,0  }, 5},
  { { 2,3,10, 3,4,11, 0,3,7 , 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 1,4,12, 2,3,10, 0,3,7 , 0,4,8 , 0,0,0 , 0,0,0  }, 4},
  { { 2,3,10, 1,4,12, 0,1,5 , 0,2,6 , 0,0,0 , 0,0,0  }, 4},
  { { 2,3,10, 0,3,7 , 0,4,8 , 0,1,5 , 1,2,9 , 0,0,0  }, 5},
  { { 0,2,6 , 1,2,9 , 2,3,10, 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 1,2,9 , 0,2,6 , 0,3,7 , 0,4,8 , 1,4,12, 0,0,0  }, 5},
  { { 1,4,12, 1,2,9 , 0,1,5 , 0,0,0 , 0,0,0 , 0,0,0  }, 3},
  { { 0,1,5 , 0,2,6 , 0,3,7 , 0,4,8 , 0,0,0 , 0,0,0  }, 4},
  { { 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0 , 0,0,0  }, 0}
};


cutting_info Psm_Table[64] = {
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 0,1,6,  0,3,13, 0,2,8,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 1,4,12, 1,2,7,  0,1,6,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,2,8,  0,3,13, 1,4,12, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 2,5,14, 1,2,7,  0,2,8,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,1,6,  0,3,13, 2,5,14, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  1,4,12, 2,5,14, 0,2,8,  0,0,0,  0,0,0  }, 4},
  { { 0,3,13, 1,4,12, 2,5,14, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,3,13, 3,4,10, 3,5,11, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 3,4,10, 3,5,11, 0,2,8,  0,1,6,  0,0,0,  0,0,0  }, 4},
  { { 1,4,12, 1,2,7,  0,1,6,  0,3,13, 3,5,11, 3,4,10 }, 6},
  { { 0,2,8,  3,5,11, 3,4,10, 1,4,12, 1,2,7,  0,0,0  }, 5},
  { { 2,5,14, 1,2,7,  0,2,8,  0,3,13, 3,4,10, 3,5,11 }, 6},
  { { 1,2,7,  0,1,6,  3,4,10, 3,5,11, 2,5,14, 0,0,0  }, 5},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 1,4,12, 3,4,10, 3,5,11, 2,5,14, 0,0,0,  0,0,0  }, 4},
  { { 1,4,12, 3,4,10, 4,5,10, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,1,6,  0,2,8,  0,3,13, 3,4,10, 4,5,10, 1,4,12 }, 6},
  { { 0,1,6,  3,4,10, 4,5,10, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 0,2,8,  1,2,7,  4,5,10, 3,4,10, 0,3,13, 0,0,0  }, 5},
  { { 1,2,7,  0,2,8,  2,5,14, 4,5,10, 3,4,10, 1,4,12 }, 6},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 0,1,6,  3,4,10, 4,5,10, 2,5,14, 0,2,8,  0,0,0  }, 5},
  { { 0,3,13, 3,4,10, 4,5,10, 2,5,14, 0,0,0,  0,0,0  }, 4},
  { { 0,3,13, 1,4,12, 4,5,10, 3,5,11, 0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  1,4,12, 4,5,10, 3,5,11, 0,2,8,  0,0,0  }, 5},
  { { 0,1,6,  0,3,13, 3,5,11, 4,5,10, 1,2,7,  0,0,0  }, 5},
  { { 0,2,8,  1,2,7,  4,5,10, 3,5,11, 0,0,0,  0,0,0  }, 4},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 1,2,7,  0,1,6,  1,4,12, 4,5,10, 3,5,11, 2,5,14 }, 6},
  { { 0,3,13, 0,1,6,  0,2,8,  2,5,14, 4,5,10, 3,5,11 }, 6},
  { { 2,5,14, 3,5,11, 4,5,10, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 2,5,14, 3,5,11, 4,5,10, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,3,13, 0,1,6,  0,2,8,  2,5,14, 4,5,10, 3,5,11 }, 6},
  { { 1,2,7,  0,1,6,  1,4,12, 4,5,10, 3,5,11, 2,5,14 }, 6},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 0,2,8,  1,2,7,  4,5,10, 3,5,11, 0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  0,3,13, 3,5,11, 4,5,10, 1,2,7,  0,0,0  }, 5},
  { { 0,1,6,  1,4,12, 4,5,10, 3,5,11, 0,2,8,  0,0,0  }, 5},
  { { 0,3,13, 1,4,12, 4,5,10, 3,5,11, 0,0,0,  0,0,0  }, 4},
  { { 0,3,13, 3,4,10, 4,5,10, 2,5,14, 0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  3,4,10, 4,5,10, 2,5,14, 0,2,8,  0,0,0  }, 5},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 1,2,7,  0,2,8,  2,5,14, 4,5,10, 3,4,10, 1,4,12 }, 6},
  { { 0,2,8,  1,2,7,  4,5,10, 3,4,10, 0,3,13, 0,0,0  }, 5},
  { { 0,1,6,  3,4,10, 4,5,10, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  0,2,8,  0,3,13, 3,4,10, 4,5,10, 1,4,12 }, 6},
  { { 1,4,12, 3,4,10, 4,5,10, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 1,4,12, 3,4,10, 3,5,11, 2,5,14, 0,0,0,  0,0,0  }, 4},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0},
  { { 1,2,7,  0,1,6,  3,4,10, 3,5,11, 2,5,14, 0,0,0  }, 5},
  { { 2,5,14, 1,2,7,  0,2,8,  0,3,13, 3,4,10, 3,5,11 }, 6},
  { { 0,2,8,  3,5,11, 3,4,10, 1,4,12, 1,2,7,  0,0,0  }, 5},
  { { 1,4,12, 1,2,7,  0,1,6,  0,3,13, 3,5,11, 3,4,10 }, 6},
  { { 3,4,10, 3,5,11, 0,2,8,  0,1,6,  0,0,0,  0,0,0  }, 4},
  { { 0,3,13, 3,4,10, 3,5,11, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,3,13, 1,4,12, 2,5,14, 0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,1,6,  1,4,12, 2,5,14, 0,2,8,  0,0,0,  0,0,0  }, 4},
  { { 0,1,6,  0,3,13, 2,5,14, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 2,5,14, 1,2,7,  0,2,8,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,2,8,  0,3,13, 1,4,12, 1,2,7,  0,0,0,  0,0,0  }, 4},
  { { 1,4,12, 1,2,7,  0,1,6,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,1,6,  0,3,13, 0,2,8,  0,0,0,  0,0,0,  0,0,0  }, 3},
  { { 0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  }, 0}
};

cutting_info *Ucd_Cutting_Info[8] =
{ 0, 0, 0, 0, Tet_Table, Pry_Table, Psm_Table, Hex_Table };

int Ucd_Num_Nodes[8] = { 0, 0, 0, 0, 4, 5, 6, 8 };
