/*       @(#)mat.h 6.0  Jonathan Cox 29/10/93 */
/*
 * FILE: mat.h
 *
 * DESCRIPTION
 * 
 * Matrix and vector manipulation routines.
 *
 * NOTICE
 *
 * (c) University of Manchester 1991, 1992, 1993.
 * Author:  Jonathan Cox.
 * Address: IT301, Department of Computer Science, University of Manchester,
 *          Oxford Road, Manchester.  M13 9PL.  England.
 * Email:   coxjp@cs.man.ac.uk
 *
 * No part of this software may be altered, incorporated in other programs or
 * given to third parties, except under the conditions of the license, if any,
 * with which it was distributed.  This notice may not be removed from the
 * source code with which it is associated.
 *
 * VERSION HISTORY
 *
 * 5.0 - Jonathan Cox.  First version for general release.
 * 5.1 - Jonathan Cox.  ANSI C.
 * 6.0 - Jonathan Cox.  Second version for general release.
 * 
 */
#ifdef __STDC__

/*
 * The following functions are from AVS's mat(3V) library
 * ANSI C bindings for these function do not work so they are commented out.

extern mat_identity(float m[4][4]);
extern mat_copy(float res[4][4], float src[4][4]);
extern mat_x_rotate(float rotx, float m[4][4]);
extern mat_y_rotate(float roty, float m[4][4]);
extern mat_z_rotate(float rotz, float m[4][4]);
extern mat_translate(float m[4][4], float tx, float ty, float tz);
extern mat_scale(float m[4][4], float sx, float sy, float sz);
extern vec_add(float res[3], float vec1[3], float vec2[3]);
extern vec_copy(float res[3], float src[3]);
extern mat_vecmul(float v[3], float m[4][4]);
extern mat_inverse(float res[4][4], float src[4][4]);
extern mat_multiply(float m1[4][4], float m2[4][4], float res[4][4]);
extern normalize_vec(float vec[3]);
extern cross_product(float res[3], float vec1[3], float vec2[3]);
*/

extern rotate3d(float result_mat[4][4], float axis_x, float axis_y, float
		axis_z, float angle_in_radians);
extern float dot_product(float v1[3], float v2[3]);
extern double vec_mag(float v[3]);
extern double mat_mag(float m[4][4]);
extern mat2_vecmul(float v[3], float m[4][4]);
extern mat3_vecmul(float v[3], float m[4][4]);
extern int different_quadrant(float a1, float a2);
extern float rot180(float a);

#else

extern mat_identity();
extern mat_copy();
extern mat_x_rotate();
extern mat_y_rotate();
extern mat_z_rotate();
extern mat_translate();
extern mat_scale();
extern vec_add();
extern vec_copy();
extern mat_vecmul();
extern mat_inverse();
extern mat_multiply();
extern normalize_vec();
extern cross_product();

extern rotate3d();
extern float dot_product();
extern double vec_mag();
extern double mat_mag();
extern mat2_vecmul();
extern mat3_vecmul();
extern int different_quadrant();
extern float rot180();

#endif
