/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/*
 * ucd_plumbline
 *
 * UCD Plumb Line sampler,
 * puts a vertical line (Z-axis) through a UCD,
 * allows "picking" of icons at the top or dials for x-y position.
 *
 * Author: I. Curington, AVS Inc., UK
 *
 * Revision:
 * 17 Mar 93 ianc - Original
 * 16 July 93 ianc - converted from field to ucd
 * 26 Aug  93 ianc - fixed pointer indirection bug
 */
#ifdef SCCS
static char sccsid[]="@(#)ucd_plumbline.c	7.1 AVS 92/02/25";
#endif
/*
			Copyright (c) 1989,1990 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
*/

#include <stdio.h>

#include <avs/avs.h>
#include <avs/ucd_defs.h>
#include <avs/geom.h>
#include <avs/udata.h>

/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

/******************************************************************************/


/* 
 * Drop a plumb line down one vert line from a ucd node
 */  

/* 
 * The function AVSinit_modules is called from the main() routine supplied
 * by AVS.  In it, we call AVSmodule_from_desc with the name of our 
 * description routine.
 */

AVSinit_modules()
{
	int ucd_plumbline();

	AVSmodule_from_desc(ucd_plumbline);
}

/*  
 * The routine "ucd_plumbline" is the description routine.  It provides
 * AVS some necessary information such as: name, input and output ports, 
 * parameters etc. 
 */
ucd_plumbline()
{
	int ucd_plumbline_compute();	/* declare the compute function (below) */
	int out_port;	/* temporaries to hold the port numbers */
	int in_port;	/* temporaries to hold the port numbers */
	int parm;

	/* Set the module name and type */
	AVSset_module_name("ucd_plumbline", MODULE_MAPPER);

	/* There is one input port for this module */
	in_port =
           AVScreate_input_port(/*name*/ "Vel-Field", /*type*/"ucd", REQUIRED);

        in_port = AVScreate_input_port("pick",
              "struct upstream_geom", OPTIONAL | INVISIBLE);
        AVSset_input_class(in_port,"upstream_geom");

	/* Create an output port for the result */
	out_port =
           AVScreate_output_port(/*name*/ "LineIcon",
                   /*type*/"geom");

	out_port =
           AVScreate_output_port(/*name*/ "Node-Index", /*type*/"integer");
        out_port =
           AVScreate_output_port("X-norm", "real");
        out_port =
           AVScreate_output_port("Y-norm", "real");

        /* set up some interactive parameters */
        parm = AVSadd_parameter("Node_Num","integer",1,INT_UNBOUND,INT_UNBOUND);
        AVSconnect_widget( parm, "typein_integer" );;

        parm = AVSadd_float_parameter("Size",    1.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
        parm = AVSadd_float_parameter("Offset", 10.0,FLOAT_UNBOUND,FLOAT_UNBOUND);
        parm = AVSadd_parameter("Downsize","integer",1,1,50);
        parm = AVSadd_parameter("Flat","boolean",1,0,1);

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(ucd_plumbline_compute);
}

/******************************************************************************/

/*
 * ucd_plumbline_compute is the compute routine.  It is called whenever AVS 
 * is given a new filename for us to compute.  The arguments are: the 
 * output geometry (passed by reference), and the filename parameter.  
 * Note that the order is always inputs, outputs, parameters.
 */

ucd_plumbline_compute(input,
                      xgeom,
                      output,
                      n_index,
                      x_out, y_out,
                      node_num,
                      p_size,
                      p_offset,
                      downsize,
                      flat )

    UCD_structure *input;      /* ucd input structure geometry */
    upstream_geom *xgeom;      /* interactive pick info */
    GEOMedit_list *output;     /* cross hair output */
    int *n_index;              /* picked node index output */
    float **x_out, **y_out;    /* picked node position output */
    int node_num;              /* param control of picked point */
    float *p_size;             /* cross hair size control */
    float *p_offset;           /* cross hair z-offset control */
    int   flat;                /* flat plane, or use data-z coords */
{
    int i, j, k;
    float verts[2][3];
    int vdata[2];
    GEOMobj *obj;
    float size, offset;
    int node;
    float *xc, *yc, *zc;
    float min_extent[3], max_extent[3];   
    int num_nodes;
    float zz;

    /***************
     * STATICS     *
     ***************/
    static int ix;
    static int iix;
    static float x_result, y_result;
    static float vcolor_white[2][3] = { .9, .9, .9, .9, .9, .9 };
    static float vcolor_red[2][3]   = { .9, 0., 0., .9, 0., 0. };

    /***********
     * Body    *
     ***********/

    /*
     * query the ucd input, get number of nodes, node position arrays,
     * and overall extent.
     */

    num_nodes = input->nnodes;

    UCDstructure_get_extent (input, min_extent, max_extent);

    UCDstructure_get_node_positions (input, &xc, &yc, &zc);

    size   = *p_size;
    offset = *p_offset;

    /* establish the geometry output object */
    *output = GEOMinit_edit_list(*output);
    obj    =  GEOMcreate_obj ( GEOM_POLYTRI, NULL);


    /* Pick Mode */
    if ( xgeom != NULL &&
         AVSinput_changed( "pick", 0) &&
         xgeom->vdata >= 0 )
    {
        ix = xgeom->vdata;
        x_result = xc[ ix ];
        y_result = yc[ ix ];
        AVSmodify_parameter("Node_Num",AVS_VALUE,ix,0,1000);
    }

    /* Node Num dial change */
    else if ( AVSparameter_changed( "Node_Num") )
    {
        ix = node_num;
        x_result = xc[ ix ];
        y_result = yc[ ix ];
    }

   /* cross hair markers */
   for (node = 0; node < num_nodes; node+=downsize)
   {
         vdata[0] = vdata[1] = node;
         if ( flat )
             zz = 0.0 + offset;
         else
             zz = zc[ node ] + offset;

         verts[0][0] = xc[ node ]- size;
         verts[0][1] = yc[ node ];
         verts[0][2] = zz;
         verts[1][0] = xc[ node ]+ size;
         verts[1][1] = yc[ node ];
         verts[1][2] = zz;
         if ( node==ix )
           GEOMadd_disjoint_line (obj, verts, vcolor_white, 2, GEOM_COPY_DATA);
         else
           GEOMadd_disjoint_line (obj, verts, vcolor_red, 2, GEOM_COPY_DATA);
         GEOMadd_disjoint_vertex_data (obj, vdata, 2, GEOM_COPY_DATA);

         verts[0][0] = xc[ node ];
         verts[0][1] = yc[ node ]- size;
         verts[0][2] = zz;
         verts[1][0] = xc[ node ];
         verts[1][1] = yc[ node ]+ size;
         verts[1][2] = zz;
         if ( node==ix )
           GEOMadd_disjoint_line (obj, verts, vcolor_white, 2, GEOM_COPY_DATA);
         else
           GEOMadd_disjoint_line (obj, verts, vcolor_red, 2, GEOM_COPY_DATA);
         GEOMadd_disjoint_vertex_data (obj, vdata, 2, GEOM_COPY_DATA);
   }


   /* complete the geometry to output port process */
   GEOMedit_geometry (*output, "ucd_plumbline", obj);
   GEOMdestroy_obj (obj);

   GEOMedit_transform_mode (*output, "ucd_plumbline", "parent");
   GEOMedit_selection_mode(*output,
                   "ucd_plumbline",
                   "notify",
                   BUTTON_DOWN );

   /* integer output port */
   iix = ix;
   *n_index = iix;  /* return pointer */

   /* float output ports */
   *x_out = &x_result;
   *y_out = &y_result;




   /* 
    * Make sure that module returns success when finished (otherwise
    * AVS might think that it failed and won't execute downstream modules) 
    */
   return(1);
}

/******************************************************************************/

