/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* Module Name: "volume mesh" (Mapper) (Subroutine)                      */
/* Author: Edward Bender, Convex Computer Corporation			 */
/* Date Created: Tue Mar  2 15:52:41 1993                                */
/*                                                                       */
/*                                                                       */
/*  The volume mesh module is similar to the volume bounds module.       */
/*  But instead of putting a wireframe on each of the Min/Max            */
/*  computational planes, it generates a mesh like field to mesh does.   */
/*  This replaces up to six ortho_slice/field_to_mesh combinations.      */
/*  By placing the crop module upstream, it is easy to control the       */
/*  location of the slice planes.                                        */
/*                                                                       */
/*                                                                       */
/*                                                                       */
/*                                                                       */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
 
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int volume_mesh_desc()
{

	int in_port, out_port, param, iresult;
	extern int volume_mesh_compute();

	AVSset_module_name("volume mesh", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("infield", 
		"field 3D 3-space 1-vector irregular float", REQUIRED);
	in_port = AVScreate_input_port("colormapin", "colormap", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("geom_faces", "geom");

	/* Parameter Specifications                */
	param = AVSadd_parameter("Min I", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Max I", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Min J", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Max J", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Min K", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Max K", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(volume_mesh_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int volume_mesh_compute( infield, colormapin, geom_faces, Min_I, Max_I, 
Min_J, Max_J, Min_K, Max_K)
	AVSfield_float *infield;
	AVScolormap *colormapin;
	GEOMedit_list *geom_faces;
	int Min_I;
	int Max_I;
	int Min_J;
	int Max_J;
	int Min_K;
	int Max_K;
{
	GEOMobj *obj0;
	float *verts;
	int *colors;
	int *colors_faces;
	int loc;
	int n,i,j,l;
	int d0,d1,d2;

	*geom_faces = GEOMinit_edit_list(*geom_faces);
	d0 = infield->dimensions[0];
	d1 = infield->dimensions[1];
	d2 = infield->dimensions[2];

        /*  convert hsva colormap to byte packed argb */
	n = colormapin->size;
	colors = (int *) (malloc(n * (sizeof(int))));
        cmaptoargb(colormapin,colors);

	if (Min_I) {
	   verts = (float *) (malloc(3*d1*d2*(sizeof(float))));
	   colors_faces = (int *) (malloc(d1*d2*(sizeof(int))));
	   l = 0;
		for (j=0;j<d2;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d1;i++) {
		     verts[l] = COORD_X_3D(infield,0,i,j);
		     verts[l+1] = COORD_Y_3D(infield,0,i,j);
		     verts[l+2] = COORD_Z_3D(infield,0,i,j);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,0,i,j));
		     colors_faces[i+j*d1] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d1, d2, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}

	if (Max_I) {
	   verts = (float *) (malloc(3*d1*d2*(sizeof(float))));
	   colors_faces = (int *) (malloc(d1*d2*(sizeof(int))));
	   l = 0;
		for (j=0;j<d2;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d1;i++) {
		     verts[l] = COORD_X_3D(infield,d0-1,i,j);
		     verts[l+1] = COORD_Y_3D(infield,d0-1,i,j);
		     verts[l+2] = COORD_Z_3D(infield,d0-1,i,j);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,d0-1,i,j));
		     colors_faces[i+j*d1] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d1, d2, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}

	if (Min_J) {
	   verts = (float *) (malloc(3*d0*d2*(sizeof(float))));
	   colors_faces = (int *) (malloc(d0*d2*(sizeof(int))));
	   l = 0;
		for (j=0;j<d2;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d0;i++) {
		     verts[l] = COORD_X_3D(infield,i,0,j);
		     verts[l+1] = COORD_Y_3D(infield,i,0,j);
		     verts[l+2] = COORD_Z_3D(infield,i,0,j);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,i,0,j));
		     colors_faces[i+j*d0] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d0, d2, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}

	if (Max_J) {
	   verts = (float *) (malloc(3*d0*d2*(sizeof(float))));
	   colors_faces = (int *) (malloc(d0*d2*(sizeof(int))));
	   l = 0;
		for (j=0;j<d2;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d0;i++) {
		     verts[l] = COORD_X_3D(infield,i,d1-1,j);
		     verts[l+1] = COORD_Y_3D(infield,i,d1-1,j);
		     verts[l+2] = COORD_Z_3D(infield,i,d1-1,j);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,i,d1-1,j));
		     colors_faces[i+j*d0] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d0, d2, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}

	if (Min_K) {
	   verts = (float *) (malloc(3*d0*d1*(sizeof(float))));
	   colors_faces = (int *) (malloc(d0*d1*(sizeof(int))));
	   l = 0;
		for (j=0;j<d1;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d0;i++) {
		     verts[l] = COORD_X_3D(infield,i,j,0);
		     verts[l+1] = COORD_Y_3D(infield,i,j,0);
		     verts[l+2] = COORD_Z_3D(infield,i,j,0);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,i,j,0));
		     colors_faces[i+j*d0] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d0, d1, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}

	if (Max_K) {
	   verts = (float *) (malloc(3*d0*d1*(sizeof(float))));
	   colors_faces = (int *) (malloc(d0*d1*(sizeof(int))));
	   l = 0;
		for (j=0;j<d1;j++) {
		  /*$dir no_recurrence*/
		  for (i=0;i<d0;i++) {
		     verts[l] = COORD_X_3D(infield,i,j,d2-1);
		     verts[l+1] = COORD_Y_3D(infield,i,j,d2-1);
		     verts[l+2] = COORD_Z_3D(infield,i,j,d2-1);
		     l = l+3;
		     loc = AVScmap_index(colormapin,I3D(infield,i,j,d2-1));
		     colors_faces[i+j*d0] = colors[loc];
		  }
		}
	   obj0 = GEOMcreate_mesh_with_data(GEOM_NULL, verts, GEOM_NULL,
		 colors_faces, d0, d1, GEOM_COPY_DATA);
           GEOMgen_normals(obj0, 0);
	   GEOMedit_geometry(*geom_faces, "volume_mesh", obj0);
	   GEOMdestroy_obj(obj0);
	   free (verts);
	   free (colors_faces);
	}



	free(colors);

/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
static int ((*mod_list[])()) = {
	volume_mesh_desc
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
cmaptoargb(cmap,argb)
AVScolormap *cmap;
int *argb;
{
	int i,l,npts;
	unsigned char *cargb;
	float R,G,B;
	float h,s,v;

	cargb = (unsigned char *) (argb);
	npts = cmap->size;
	l = 0;
	for (i=0; i<npts; i++) {
           h = cmap->hue[i];
           s = cmap->saturation[i];
           v = cmap->value[i];
/*	   PIXELhsv_to_rgb(h,s,v,&R,&G,&B); */
	   hsvtorgb_pixel(&R,&G,&B,&h,&s,&v);
	   cargb[l] = (unsigned char ) (cmap->alpha[i] *255.);
	   cargb[l+1] = (unsigned char) (R*255.);
	   cargb[l+2] = (unsigned char) (G*255.);
	   cargb[l+3] = (unsigned char) (B*255.);
	   l = l+4;
	}
}



hsvtorgb_pixel(R,G,B,h,s,v)
float *R,*G,*B;
float *h,*s,*v;
{
    float f, p, q, t;
    float r, g, b;
    float ht;
    int i;
 
    ht = *h * 360.;  /* convert from 0..1 to 0..360 */

    if (*v == 0.)
    {
	r=0.;
	g=0.;
	b=0.;
    }
    else
    {
	if (*s == 0.)
	{
	    r = *v;
	    g = *v;
	    b = *v;
	}
	else
	{
	    if (ht == 360.)
		ht = 0.;
	    ht = ht/60.;
	    
	    i = ht;
	    f = ht - i;
	    p = *v*(1.0- *s);
	    q = *v*(1.0- *s*f);
	    t = *v*(1.0- *s*(1.0-f));
      
 	    if (i == 0) 
	    {
		r = *v;
		g = t;
		b = p;
	    }
	    else if (i == 1)
	    {
		r = q;
		g = *v;
		b = p;
	    }
	    else if (i == 2)
	    {
		r = p;
		g = *v;
		b = t;
	    }
	    else if (i == 3)
	    {
		r = p;
		g = q;
		b = *v;
	    }
	    else if (i == 4)
	    {
		r = t;
		g = p;
		b = *v;
	    }
	    else if (i == 5)
	    {
		r = *v;
		g = p;
		b = q;
	    }
	}
    }
    *R = r;
    *G = g;
    *B = b;
}

/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */

