/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
			Copyright (c) 1989 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at Stardent in:
	/usr/users/ianc/avs/modules/mappers/s.waffle.c
	
*/

/*
 * waffle module
 * derived from the standard "field to mesh" module.
 * Then derived from city_scape module.
 * Therefore, leave the copyright note in.
 *
 * Author: Ian Curington, Advanced Visual Systems, Inc.
 *         Staines, UK
 *
 * Revision History:
 *    31 January  92  ianc: Original
 *     4 February 92  ianc: Complete boxes, scale factors
 *     5 February 92  ianc: added averages shadow
 *     8 March    92  ianc: added threshold sheet
 *    12 March    92  ianc: added wireframe base, tickmarks
 *    17 March    92  ianc: added labels on tics
 *    19 March    92  ianc: vertical tics, separate sheet obj
 *    20 March    92  ianc: tidy up, average bug fix
 *     7 June     92  ianc: converted city_scape to waffle
 *
 */

#include <stdio.h>

#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/geomdata.h>
#include <avs/colormap.h>

#define NUM_V_TICS 10

/**********************************************************************/
/* Module Description Section */
/**********************************************************************/

MODwaffle()
{
	int waffle_compute();

	AVSset_module_name("waffle", MODULE_MAPPER);
	AVSset_module_flags( COOPERATIVE | REENTRANT );
	AVScreate_input_port("Field Input","field 2D uniform scalar float", 
				REQUIRED | MODIFY_IN);
	AVScreate_input_port("Input Colormap", "colormap", REQUIRED);
	
	AVScreate_output_port("geometry", "geom");
	AVSadd_float_parameter("Z scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
	AVSadd_float_parameter("width", 0.8, 0.0, 1.0);
	AVSadd_float_parameter("offset", 0.1, 0.0, 1.0);
	AVSadd_float_parameter("threshold", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	AVSadd_float_parameter("tic scale", 1.0, FLOAT_UNBOUND, FLOAT_UNBOUND );
        AVSadd_parameter("show X-cells","boolean",1,0,1);
        AVSadd_parameter("show Y-cells","boolean",1,0,1);
        AVSadd_parameter("show shadows","boolean",1,0,1);
        AVSadd_parameter("show threshold","boolean",1,0,1);
        AVSadd_parameter("show annotation","boolean",1,0,1);
	AVSset_compute_proc(waffle_compute);
}

/**********************************************************************/
/* Module Compute Function */
/**********************************************************************/
waffle_compute(input, colormap, output,
	zscale, fwidth, foffset, threshold, tic_scale,
        show_x, show_y, show_shadow, show_threshold, show_labels )

        AVSfield_float *input;
        AVScolormap *colormap;
        GEOMedit_list *output;
        float *zscale;
        float *fwidth;
        float *foffset;
        float *threshold;
        float *tic_scale;
        int   show_x;
        int   show_y;
        int   show_shadow;
        int   show_threshold;
        int   show_labels;
{
   GEOMobj *obj;
   GEOMobj *obj_sheet;
   GEOMobj *obj_base;
   GEOMobj *obj_label;
   float   min, max;
   unsigned int color_lut[BYTE_TABLE];
   int size, i, j;

   size = MAXX(input) * MAXY(input);

   /* pre-build a color lookup table for speed */
   for (i=0; i<colormap->size; i++) 
   {
	 PIXELhsva_to_pixel (&color_lut[i], colormap->hue[i], 
			colormap->saturation[i],
			colormap->value[i], colormap->alpha[i]);
   }

   /* create the output geometric structure pointers */
   *output   = GEOMinit_edit_list(*output);
   obj       = GEOMcreate_obj ( GEOM_POLYHEDRON, GEOM_NULL );
   obj_sheet = GEOMcreate_obj ( GEOM_POLYHEDRON, GEOM_NULL );
   obj_base  = GEOMcreate_obj ( GEOM_POLYTRI,    GEOM_NULL );
   obj_label = GEOMcreate_label(GEOM_NULL, NULL);


   /* create the main waffle 3D bar chart here */
   draw_waffle (obj, input->data, colormap,
	      color_lut, MAXX(input), MAXY(input),
	      *fwidth, min, max, *zscale, show_x, show_y );

   /* create the side averages here */
   if ( show_shadow )
   {
       draw_averages (obj, input->data, colormap,
	      color_lut, MAXX(input), MAXY(input),
	      *fwidth, min, max, *zscale, *foffset );
   }

   /* draw a base sheet, at threshold level */
   if ( show_threshold )
   {
       draw_sheet (obj_sheet, *fwidth, *zscale, *threshold,
                MAXX(input), MAXY(input) );
   }

   if ( show_labels )
   {
       /* draw a base line around city */
       draw_base_line (obj_base, *fwidth, MAXX(input), MAXY(input),
                   *foffset, *threshold, *zscale, *tic_scale );

       /* draw in the text labels */
       draw_labels (obj_label, *fwidth, MAXX(input), MAXY(input),
                   *foffset, *threshold, *zscale, *tic_scale );
   }

   GEOMgen_normals(obj, 0); 
   GEOMcvt_polyh_to_polytri(obj,
	GEOM_NO_CONNECTIVITY | GEOM_SURFACE | GEOM_WIREFRAME);

   GEOMedit_geometry(*output,"waffle",obj);
   GEOMedit_geometry(*output,"waffle",obj_base);
   GEOMedit_geometry(*output,"waffle",obj_label);
   GEOMedit_geometry(*output,"waffle_threshold",obj_sheet);
   GEOMedit_transform_mode(*output, "waffle", "parent",0);
   GEOMedit_transform_mode(*output, "waffle_threshold", "parent",0);

   GEOMdestroy_obj(obj);
   GEOMdestroy_obj(obj_sheet);
   GEOMdestroy_obj(obj_base);
   GEOMdestroy_obj(obj_label);

   return(1);
}

/**********************************************************************/
/* Geometric Object Creation Routine */
/**********************************************************************/
draw_waffle ( obj, fmesh, colormap,
              color_lut, nx, ny, width,
              min, max, zscale, show_x, show_y )

    GEOMobj *obj;
    float   *fmesh;
    AVScolormap *colormap;
    unsigned int  *color_lut;
    int     nx, ny;
    float   width, min, max, zscale;
    int     show_x, show_y;
{

   int i,j;
   int index;
   float x1, y1, x2, y2, height1, height2;
   float spacing;
   unsigned int color1, color2;

   if ( nx < ny ) spacing = (float)ny;
   else           spacing = (float)nx;

   /* draw x-axis cells */
   if ( show_x )
   {
       for (i=0; i<ny; i++) {
         for (j=0; j<(nx-1); j++) {

           index = PIXELget_index(colormap, fmesh[i*nx+j]);
           color1 = color_lut[index];
           index = PIXELget_index(colormap, fmesh[i*nx+j+1]);
           color2 = color_lut[index];
           x1  = (float) j / spacing;
           y1  = (float)(ny-i-1) / spacing;
           x2  = (float) (j+1) / spacing;
           y2  = (float)(ny-i-1) / spacing;
           height1 = zscale * fmesh[i*nx+j];
           height2 = zscale * fmesh[i*nx+j+1];

           draw_a_cell (obj, x2, y2, height2, color2,
                             x1, y1, height1, color1 );
    
         }
       }
   }

   /* draw y-axis cells */
   if ( show_y )
   {
       for (j=0; j<nx; j++) {
         for (i=0; i<(ny-1); i++) {

           index = PIXELget_index(colormap, fmesh[i*nx+j]);
           color1 = color_lut[index];
           index = PIXELget_index(colormap, fmesh[(i+1)*nx+j]);
           color2 = color_lut[index];
           x1  = (float) j / spacing;
           y1  = (float)(ny-i-1) / spacing;
           x2  = (float) (j) / spacing;
           y2  = (float)(ny-(i+1)-1) / spacing;
           height1 = zscale * fmesh[i*nx+j];
           height2 = zscale * fmesh[(i+1)*nx+j];

           draw_a_cell (obj, x2, y2, height2, color2,
                         x1, y1, height1, color1 );

         }
       }
   }
}

/**********************************************************************/
/* Secondary Geometric Object Creation Routine */
/**********************************************************************/
draw_averages ( obj, fmesh, colormap,  color_lut,
		nx, ny, width, min, max, zscale, offset )
    GEOMobj *obj;
    float   *fmesh;
    AVScolormap *colormap;
    unsigned int  *color_lut;
    int     nx, ny;
    float   width, min, max, zscale, offset;
{

   int i,j;
   int index;
   float xpos, ypos, height;
   float spacing, base;
   unsigned int color;
   float average, minimum, maximum;

   if ( nx < ny ) spacing = (float)ny;
   else           spacing = (float)nx;

   for (i=0; i<ny; i++) {
     average = 0;
     minimum = maximum = fmesh[i*nx];
     for (j=0; j<nx; j++) {
       average += fmesh[i*nx+j];
       if ( maximum < fmesh[i*nx+j] ) maximum = fmesh[i*nx+j];
       if ( minimum > fmesh[i*nx+j] ) minimum = fmesh[i*nx+j];
     }
     average /= (float)nx;

     index = PIXELget_index(colormap, minimum);
     color = color_lut[index];
     xpos  = (float) nx / spacing + offset;
     ypos  = ((float)(ny-i-1) / spacing );
     height = zscale * average;
     base   = zscale * minimum;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 0 );

     index = PIXELget_index(colormap, maximum);
     color = color_lut[index];
     height = zscale * maximum;
     base   = zscale * average;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 0 );
   }

   for (j=0; j<nx; j++) {
     average = 0;
     minimum = maximum = fmesh[j];
     for (i=0; i<ny; i++) {
       average += fmesh[i*nx+j];
       if ( maximum < fmesh[i*nx+j] ) maximum = fmesh[i*nx+j];
       if ( minimum > fmesh[i*nx+j] ) minimum = fmesh[i*nx+j];
     }
     average /= (float)ny;

     index = PIXELget_index(colormap, minimum);
     color = color_lut[index];
     xpos  = (float) j / spacing;
     ypos  = 1.0 + offset;
     height = zscale * average;
     base   = zscale * minimum;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 1 );

     index = PIXELget_index(colormap, maximum);
     color = color_lut[index];
     height = zscale * maximum;
     base   = zscale * average;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 1 );
   }


}

/**********************************************************************/
/* routine to a cell of certain size and position */
/**********************************************************************/
draw_a_cell (obj, x1, y1, height1, color1,
                  x2, y2, height2, color2 )

    GEOMobj *obj;
    float x1, y1, height1;
    float x2, y2, height2;
    unsigned int color1, color2;

{
         float verts[ 4 * 3 ];
         int   cols [ 4 ];  

         /* draw one quad */
         verts[ 0 * 3 + 0 ] = x1;
	 verts[ 0 * 3 + 1 ] = y1;
	 verts[ 0 * 3 + 2 ] = 0;
	 cols [ 0 ]         = color1;

         verts[ 1 * 3 + 0 ] = x1;
	 verts[ 1 * 3 + 1 ] = y1;
	 verts[ 1 * 3 + 2 ] = height1;
	 cols [ 1 ]         = color1;

         verts[ 2 * 3 + 0 ] = x2;
	 verts[ 2 * 3 + 1 ] = y2;
	 verts[ 2 * 3 + 2 ] = height2;
	 cols [ 2 ]         = color2;

         verts[ 3 * 3 + 0 ] = x2;
	 verts[ 3 * 3 + 1 ] = y2;
	 verts[ 3 * 3 + 2 ] = 0;
	 cols [ 3 ]         = color2;

         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_int_colors(obj, cols, 4, GEOM_COPY_DATA);

} 


/**********************************************************************/
/* routine to draw one averaged quadrilateral of certain size and position */
/**********************************************************************/

draw_a_side (obj, xpos, ypos, base, height, width, color, flip )
    GEOMobj *obj;
    float xpos, ypos, height, width, base;
    unsigned int color;
    int flip;
{
       float verts[ 4 * 3 ];
       int   cols [ 4 ];  

       if ( flip == 0 )
       {
         /* draw side average quad */
         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = base;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = ypos - width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos;
	 verts[ 3 * 3 + 1 ] = ypos + width;
	 verts[ 3 * 3 + 2 ] = base;
	 cols [ 3 ]         = color;

       } else {

         verts[ 0 * 3 + 0 ] = xpos + width;
	 verts[ 0 * 3 + 1 ] = ypos;
	 verts[ 0 * 3 + 2 ] = base;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos + width;
	 verts[ 1 * 3 + 1 ] = ypos;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos - width;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos - width;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = base;
	 cols [ 3 ]         = color;
       }

       GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
                                  GEOM_NOT_SHARED, GEOM_COPY_DATA);
       GEOMadd_int_colors(obj, cols, 4, GEOM_COPY_DATA);

} 


/**********************************************************************/
/* routine to draw one threshold quadrilateral over city */
/**********************************************************************/

draw_sheet (obj, width, zscale, threshold, nx, ny )
    GEOMobj *obj;
    float width, zscale, threshold; 
    int nx, ny;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float verts[ 4 * 3 ];

       height = zscale * threshold;
       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

         /* draw one quad */
         verts[ 0 * 3 + 0 ] = minx;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = minx;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = maxx;
	 verts[ 2 * 3 + 1 ] = maxy;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = miny;
	 verts[ 3 * 3 + 2 ] = height;

       GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
                                  GEOM_NOT_SHARED, GEOM_COPY_DATA);
}


/**********************************************************************/
/* routine to draw one base polyline and tick marks */
/**********************************************************************/

draw_base_line (obj, width, nx, ny, offset, threshold, zscale, tic_scale )
    GEOMobj *obj;
    float width; 
    int nx, ny;
    float offset;
    float threshold;
    float zscale;
    float tic_scale;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float xpos, ypos;
       float verts[ 5 * 3 ];
       int i, j;

       height = 0.0;
       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

         /* draw one quad around the base of city */
         verts[ 0 * 3 + 0 ] = minx;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = minx;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = maxx;
	 verts[ 2 * 3 + 1 ] = maxy;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = miny;
	 verts[ 3 * 3 + 2 ] = height;

         verts[ 4 * 3 + 0 ] = minx;
	 verts[ 4 * 3 + 1 ] = miny;
	 verts[ 4 * 3 + 2 ] = height;

       /* draw the two pairs */
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);
       GEOMadd_disjoint_line ( obj, &verts[3], NULL, 4, GEOM_COPY_DATA);

       /* draw some lines at base of shadow averages */
         /* draw two lines */
         xpos  = 1.0 + offset;
         ypos  = 1.0 + offset;

         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = minx;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = height;
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);

       /* draw some lines at threshold sheet near averages */
         /* draw two lines */
         height = threshold * zscale;
         xpos  = 1.0 + offset * 0.98;
         ypos  = 1.0 + offset * 0.98;

         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = minx;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = height;
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);


       /* add some tick marks along front edge */
       height = 0.0;
       for (i=0; i<ny; i++) {
               ypos  = (float)(ny-i-1) / spacing;

               verts[ 0 * 3 + 0 ] = minx;
	       verts[ 0 * 3 + 1 ] = ypos;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = minx - 0.10;
	       verts[ 1 * 3 + 1 ] = ypos;         /* hand code length */
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }

       for (j=0; j<nx; j++) {
               xpos  = (float) j / spacing;
               verts[ 0 * 3 + 0 ] = xpos;
	       verts[ 0 * 3 + 1 ] = miny;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = xpos;
	       verts[ 1 * 3 + 1 ] = miny - 0.10;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }

       /* put some vertical ticks on shadow averages */
       for (i=0; i< NUM_V_TICS; i++) {
               height  = (float) i * tic_scale * zscale;

               verts[ 0 * 3 + 0 ] = 1.0 + offset;
	       verts[ 0 * 3 + 1 ] = miny;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = 1.0 + offset;
	       verts[ 1 * 3 + 1 ] = miny - 0.10;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);

               verts[ 0 * 3 + 0 ] = minx;
	       verts[ 0 * 3 + 1 ] = 1.0 + offset;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = minx - 0.10;
	       verts[ 1 * 3 + 1 ] = 1.0 + offset;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }


}


/**********************************************************************/
/* routine to draw labels */
/**********************************************************************/

draw_labels (obj, width, nx, ny, offset, threshold, zscale, tic_scale )
    GEOMobj *obj;
    float width; 
    int nx, ny;
    float offset;
    float threshold;
    float zscale;
    float tic_scale;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float xpos, ypos;
       float verts[ 5 * 3 ];
       int i, j;
       int label_flags;
       int label_flags_r;
       int font, title, background, drop, align, stroke;
       float label_center[3];
       float label_offset[3];
       float label_size;
       char  string[40];

       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

       font = 1;                   /* font 0-21 */
       title = 0;                  /* use ref_point */
       background = 1;             /* 1=filled rectable */
       drop = 1;                   /* 0=no, 1=drop shadow */
       stroke = 0;                 /* always zero */
       align = GEOM_LABEL_LEFT;
       label_size = 0.04;          /* height in screen space */
       label_center[2] =
       label_offset[0] = label_offset[1] = label_offset[2] = 0.0;
       label_flags = GEOMcreate_label_flags(
                font, title, background, drop,align, stroke);
       align = GEOM_LABEL_RIGHT;
       label_flags_r = GEOMcreate_label_flags(
                font, title, background, drop,align, stroke);


       /* add labels to tick marks along front edge */
       for (i=0; i<ny; i++) {
               label_center[0] = minx - 0.15;
               label_center[1] = (float)(ny-i-1) / spacing;
               sprintf(string,"%d",i);
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }

       for (j=0; j<nx; j++) {
               label_center[0] = (float) j / spacing;
               label_center[1] = miny - 0.15;
               sprintf(string,"%d",j);
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }

       /* put a label on the threshold sheet */
/* dissabled
       label_center[0] = 1.0 + offset;
       label_center[1] = miny;
       label_center[2] = threshold * zscale;
       sprintf(string,"<- %f",threshold);
       GEOMadd_label ( obj, string, label_center,
               label_offset, label_size, GEOM_NULL, label_flags );
*/

       /* put labels on the vertical tics */
       for (i=0; i< NUM_V_TICS; i++) {
               sprintf(string,"%3.2f", (float)i * tic_scale );
               label_center[2] = (float) i * tic_scale * zscale;
               label_center[0] = minx - 0.15;
               label_center[1] = 1.0 + offset;
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags_r );
               label_center[0] = 1.0 + offset;
               label_center[1] = miny - 0.15;
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }
}

/**********************************************************************/
/*
 * initialization for modules contained in this file.
 */

int ((*mapper_mod_list[])()) = {
  MODwaffle,
};

#define NMODS sizeof(mapper_mod_list) / sizeof(char *) 

AVSinit_modules ()
{
	AVSinit_from_module_list(mapper_mod_list, NMODS);
}
/**********************************************************************/


