/*******************************************************************************
 *
 *  These are a set of utility geometry copy routines that can be used by 
 *  user-written AVS modules.
 *
 *	19 Mar 92  Phil McDonald, NOAA/ERL/FSL	Original version.
 *
 ******************************************************************************/



#include	"avs_utils.h"



/*******************************************************************************
 *
 *  Return a copy of an edit list.
 *
 */


GEOMedit_list	UTILS_geom_copy_edlist (edlist_src)

GEOMedit_list	edlist_src;
{
    register char	*name;
    GEOMedit		*list, *list_dst;
    GEOMedit_list	edlist_dst;
    GEOMobj		*obj;

    if (edlist_src == GEOM_NULL) return (GEOM_NULL);

    edlist_dst = GEOMinit_edit_list (GEOM_NULL);

    list = edlist_src->l;
    while (list != GEOM_NULL)
    {
        if (list->type == 0)
        {
            if ((obj = UTILS_geom_copy_obj (list->data)) != NULL)
            {
                name = list->name;
                if (obj->name != GEOM_NULL)
                    if (isprint (obj->name[0])) name = obj->name;

                GEOMedit_geometry (edlist_dst, name, obj);
                GEOMdestroy_obj (obj);
            }
        }
        else
        {
            list_dst = UTILS_geom_copy_list (list);

            if (edlist_dst->l == NULL)
                edlist_dst->l = list_dst;
            else
                edlist_dst->l->next = list_dst;
        }

        list = list->next;
    }

    return (edlist_dst);
}



/*******************************************************************************
 *
 *  Return a copy of an list.
 *
 */


GEOMedit	*UTILS_geom_copy_list (list_src)

GEOMedit	*list_src;
{
    register int	n;
    GEOMedit		*list_dst;

    if (list_src == GEOM_NULL) return (GEOM_NULL);

    list_dst = (GEOMedit *) malloc (sizeof (GEOMedit));

    list_dst->type = list_src->type;
    list_dst->size = list_src->size;
    list_dst->data = NULL;
    if (list_src->data != NULL)
    {
        list_dst->data = (char *) malloc (list_src->size);
        memcpy (list_dst->data, list_src->data, list_src->size);
    }
    list_dst->name = NULL;
    if (list_src->name != NULL)
    {
        n              = strlen (list_src->name) + 1;
        list_dst->name = (char *) malloc (n);
        memcpy (list_dst->name, list_src->name, n);
    }
    list_dst->next = NULL;


    return (list_dst);
}



/*******************************************************************************
 *
 *  Return a copy of an geometry object.
 *
 */


GEOMobj		*UTILS_geom_copy_obj (obj_src)

GEOMobj		*obj_src;
{
    register int	i, n, m;
    register char	**p0;
    register float	*pv, *pc, *pn, *p1, *p2;
    GEOMobj		*obj_dst;
    GEOMmesh		*pm;
    GEOMpolyh		*ph;
    GEOMpolytri		*pt;
    GEOMsphere		*ps;
    GEOMlabel		*pl;

    if (obj_src == GEOM_NULL) return (GEOM_NULL);

    switch (obj_src->type)
    {
        case GEOM_MESH :

            pm = &(obj_src->d.m);

            m  = pm->m;
            n  = pm->n;
            pv = pm->verts.l;
            pn = pm->normals.l;
            pc = pm->colors.l;

            obj_dst = GEOMcreate_mesh_with_data (GEOM_NULL, pv, pn, pc, m, n,
                                                 GEOM_COPY_DATA);

            break;

        case GEOM_POLYHEDRON :

            ph = &(obj_src->d.ph);

            n  = ph->verts.n;
            pv = ph->verts.l;
            pn = ph->normals.l;
            pc = ph->colors.l;
            p1 = (float *) (ph->ptlist.l);

            obj_dst = GEOMcreate_polyh_with_data (GEOM_NULL, pv, pn, pc, n, p1,
                                                  GEOM_CONCAVE, GEOM_COPY_DATA);
            break;

        case GEOM_POLYTRI :

            pt = &(obj_src->d.pt);

            obj_dst = GEOMcreate_obj (GEOM_POLYTRI, GEOM_NULL);

            for (i = 0; i < pt->npts; i++)
            {
                n  = (pt->ptverts+i)->n;
                pv = (pt->ptverts+i)->l;
                pc = (pt->ptcolors == GEOM_NULL) ? GEOM_NULL
                                                 : (pt->ptcolors+i)->l;
                pn = (pt->ptnormals == GEOM_NULL) ? GEOM_NULL
                                                  : (pt->ptnormals+i)->l;
                GEOMadd_polytriangle (obj_dst, pv, pn, pc, n, GEOM_COPY_DATA);
            }

            for (i = 0; i < pt->npls; i++)
            {
                n  = (pt->plverts+i)->n;
                pv = (pt->plverts+i)->l;
                pc = (pt->plcolors == GEOM_NULL) ? GEOM_NULL
                                                 : (pt->plcolors+i)->l;
                GEOMadd_polyline (obj_dst, pv, pc, n, GEOM_COPY_DATA);
            }

            n  = pt->dlverts.n;
            pv = pt->dlverts.l;
            pc = pt->dlcolors.l;
            GEOMadd_disjoint_line (obj_dst, pv, pc, n, GEOM_COPY_DATA);

            break;

        case GEOM_SPHERE :

            ps = &(obj_src->d.sp);

            n  = ps->verts.n;
            pv = ps->verts.l;
            pn = ps->normals.l;
            pc = ps->colors.l;
            p1 = ps->radii.l;

            obj_dst = GEOMcreate_sphere (GEOM_NULL, pv, p1, pn, pc, n,
                                         GEOM_COPY_DATA);

            break;

        case GEOM_LABEL :

            pl = &(obj_src->d.la);

            n  = pl->labels.n;
            pv = pl->verts.l;
            pc = pl->colors.l;
            p0 = pl->labels.l;
            p1 = pl->offsets.l;
            p2 = pl->heights.l;

            obj_dst = GEOMcreate_label (GEOM_NULL, pl->lflags);

            for (i = 0; i < n; i++)
            {
                GEOMadd_label (obj_dst, *p0, pv, p1, *p2, pc, pl->lflags);

                p0++, pv += 3, p1 += 3, p2++;
                if (pc != GEOM_NULL) pc += 3;
            }

            break;

        default :

            ;
    }

    obj_dst->has_extent = obj_src->has_extent;
    if (obj_src->has_extent)
        for (i = 0; i < 6; i++) obj_dst->extent[i] = obj_src->extent[i];

    if (obj_src->name != NULL)
    {
        n = strlen (obj_src->name);
        obj_dst->name = (char *) malloc (n + 1);
        strcpy (obj_dst->name, obj_src->name);
    }

    if (obj_src->filename != NULL)
    {
        n = strlen (obj_src->filename);
        obj_dst->filename = (char *) malloc (n + 1);
        strcpy (obj_dst->filename, obj_src->filename);
    }

    if (obj_src->groupname != NULL)
    {
        n = strlen (obj_src->groupname);
        obj_dst->groupname = (char *) malloc (n + 1);
        strcpy (obj_dst->groupname, obj_src->groupname);
    }

    return (obj_dst);
}
