#ifdef SCCS
static char sccsid[]="@(#)avs_client.c	8.1 AVS 92/12/23";
#endif
/*
			Copyright (c) 1990,1991 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at AVS in:
	/sccs1.p/avs/examples/s.avs_client.c
	
*/
/* Server acknowledgement leader strings */
#define AVS_SERVER_ACK       "- Server Acknowledge"
#define AVS_SERVER_CMD_OK    "- Server Command Successful"
#define AVS_SERVER_CMD_FAIL  "- Server Command Failed"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

static int client_debug = 1;
FILE *sock_file;

/* avsi_bouw_   to be called in FORTRAN as avsi_bouw, works for 
      HP(not ciwi ...), SUN,IBM,DEC,Convex (?), SGI ....
*/

int avsi_bouw(aa1,aa2)
char *aa1, *aa2;
{
   int argc;
   char *argv[3], *t1, *t2, *a1, *a2;
   extern FILE *AVSbuild_tcp_connection();

/*
   printf("arg1=(%s), arg2=(%s)\n",aa1,aa2);
*/

   if(!strcmp(aa1,"localhost")) {
/* local, a2= port number */
       argc=2;
       a2=aa2;
       t2=a2;
/* remove trailing spaces */
       while ( *t2 != ' ' && *t2 != '\0' ) { t2++;}
       if ( *t2 = ' ' ) *t2 = '\0';
       argv[1]=a2;
   }
     else {
/* remote host , a1= hostname, a2= port number */
       argc=3;
       a1=aa1;
       t1=a1;
/* remove trailing spaces */
       while ( *t1 != ' ' && *t1 != '\0' ) { t1++;}
       if ( *t1 = ' ' ) *t1 = '\0';
       a2=aa2;
       t2=a2;
/* remove trailing spaces */
       while ( *t2 != ' ' && *t2 != '\0' ) { t2++;}
       if ( *t2 = ' ' ) *t2 = '\0';
       argv[2]=a1;
       argv[1]=a2;
   }
   sock_file = AVSbuild_tcp_connection(argc,argv);
}

int avsi_klant(com)
char *com;
{

/* add newline, assume strlen(com) < 256 ..    
volgende wil niet ....
         char dum[256];
         char * a1,* t1;
         strcpy(dum,com);
         strcat(dum,"\n");
         printf("CLI-command= %s", dum);
         a1=dum;
         printf("CLI-command= %s", a1);
         t1=a1;
         while ( *t1 != ' ' && *t1 != '\0' ) { t1++;}
         if ( *t1 = ' ' ) *t1 = '\0';
         printf("CLI-command= %s", a1);
*/

	 /* Send input to the server */
	 /* for some reason, if this line is left out, the vistra seems
	    to send an extra newline in the second fflush.  this is
	    interpreted as an extra command and causes us to be off by one.
	    */
	 fflush(sock_file);
	 fputs(com, sock_file);
	 fflush(sock_file);

	 /* This would be the place to do your own processing */

	 /* Recognize quit command after it is sent to */
	 if (!strncmp(com, "quit", 4))
	    return (0);

	 AVSclient_process_output(sock_file);
}

/**********************************************************************
AVSclient_process_output - Interpret the servers responses
   recognizing certain initial 
**********************************************************************/

AVSclient_process_output(sock_file)
FILE *sock_file;
{
   char buf[1024];
 
   /* add a rewind to work around a bug on the SGI */
   /* where the output, flush, input cycle gives   */
   /* a EBADF error */
   rewind(sock_file);

   /* Process response from the AVS kernel until completed */
   for (;;) {
      if (!fgets(buf, 1024, sock_file)) {
	 fprintf(stderr, "server disappeared unexpectedly!\n");
	 exit(1);
      }
      /* Recognize Acknowledgement of original command */
      if (!strncmp(buf, AVS_SERVER_ACK, strlen(AVS_SERVER_ACK))) {
	 if (client_debug)
	    fputs(buf, stdout);	 
      }
      /* Figure out the response - recognize success or failure */
      else if (!strncmp(buf, AVS_SERVER_CMD_OK, strlen(AVS_SERVER_CMD_OK))) {
	 if (client_debug) fputs(buf, stdout);
	 return(1);
      }

      else if (!strncmp(buf, AVS_SERVER_CMD_FAIL, strlen(AVS_SERVER_CMD_FAIL))) {
	 if (client_debug) fputs(buf, stdout);
	 return(0);
      }

      /* Echo the output from the kernel */
      else fputs(buf, stdout);
   }
}


/*----------------------------------------------------------------------
Establish the connection on the given port
----------------------------------------------------------------------*/

FILE *
AVSbuild_tcp_connection(argc, argv)
int argc;
char *argv[];
{
   int sock_fd;
   struct sockaddr_in sin;
   struct hostent *hostent;
   char filename[256], portbuf[256], *getenv();
   FILE *fd, *sock_file;
   int port;
   char *host, *temp;
   int i, j = 0, swap = 0;

   for (i = 1; i < argc; i++) {
      if (!strcmp(argv[i],"-swap")) {
         swap = 1;
         j = 1;
         argc--;
      }
      argv[i] = argv[i+j];
   }
   
   if ((sock_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror("socket");
      exit(1);
   }
   if (argc > 2) {
      port = atoi(argv[1]);
      host = argv[2];
   }
   else {
      port = 0;
      host = "localhost";
   }
      
   hostent = gethostbyname(host);
   if (!hostent) {
      fprintf(stderr, "No host entry for %s!\n",host);
      exit(1);
   }

   if (port == 0) {

      sprintf(filename, "/tmp/avs_server.%s",
              (argc > 1) ? argv[1] : getenv("AVS_SERVER_PROCESS"));

/* remove trailing spaces : 
      temp=filename;
      while ( *temp != ' ' && *temp != '\0' ) { temp++;}
      if ( *temp = ' ' ) *temp = '\0';
 remove trailing spaces : */

      if ((fd = fopen(filename, "r")) == NULL) {
	 fprintf(stderr, "No filename %s\n", filename);
	 exit(1);
      }

/*
      printf("filename= (%s)\n",temp);
      if ((fd = fopen(temp, "r")) == NULL) {
	 fprintf(stderr, "No filename %s\n", temp);
	 exit(1);
      }
*/
      fgets(portbuf, 256, fd);
      fclose(fd);
      port = atoi(portbuf);
   }

   if (port == 0) {
      fprintf(stderr, "No port number!\n");
      exit(1);
   }
   sin.sin_family = AF_INET;
   sin.sin_port = htons(port);
   memcpy(&(sin.sin_addr),hostent->h_addr,sizeof(int));
   /* Get this guy in host format from network format */
   memset(sin.sin_zero, '\0', sizeof(sin.sin_zero));
   /* 
    * AVS is not consistent with how the byte order of this port is 
    * specified.  The kernel should give us the port in network format.
    * If it is an older kernel, it will be in it's native host format
    * which may be byte swapped from ours.
    */
   if (swap) sin.sin_port = ((port & 0xff00) >> 8) | ((port & 0xff) << 8);
   if (connect(sock_fd,(struct sockaddr *)&sin,sizeof(struct sockaddr_in))<0){
      perror("connect failed: rerun with -swap option?");
      exit(1);
   }
   sock_file = fdopen(sock_fd, "r+");
   setbuf(sock_file, 0);
   return(sock_file);
}

