/* call AVSI_routines from a C program
>>> Generic version , use c_to_f77 <<<
for UNIFORM grids
string parameters = "*" are prompted for
works for HP, SGI, but nor for Convex */


main() {
  float s1[10], s2[40] [20], s3 [10] [10] [10], vx2 [10] [10], 
        vy2 [10] [10];
  int i, j, k;

  AVSI_initialize("./networks", ".", "*", "*");

/* let AVSI_routines transpose matrices in situ */
  AVSI_transpose();

/* 1D scalar data in s2 (y=x*x, x=1...10) */

  for (i=1;i<11;i++)
    s1[i-1]=i*i;

  AVSI_1D_scalar_real_uniform("*","1Ds", 10, s1);

/* 2D scalar data in s2 */

  for (i=1;i<41;i++)
    for (j=1;j<21;j++)
      s2 [i-1] [j-1] = i+j;

  AVSI_2D_scalar_real_uniform("*","2Ds", 40, 20, s2);

/* 3D scalar data in s3 */

  for (i=1;i<11;i++)
    for (j=1;j<11;j++)
      for (k=1;k<11;k++) 
        s3 [i-1] [j-1] [k-1] = i*j*k*(1-0.1*i)*(1-0.1*j)*(1-0.1*k);
      
  AVSI_3D_scalar_real_uniform("*","3Ds",10, 10, 10, s3);

/* 2D vectors in vx2, vy2 */

  for (i=1; i<11; i++)
    for (j=1; j<11; j++) {
      vx2 [i-1] [j-1] = 1.0;
      vy2 [i-1] [j-1] = 0.5*j;
  }

  AVSI_2D_vector_real_uniform("*","2Dv",10, 10, vx2, vy2);

}

