

c *******************************************************************
       program fexample1 
c *******************************************************************

c This program demonstrates the AVSI_routines FORTRAN 77.

       dimension s1(10), s2(20, 20), s3(10,10,10), vx2(10,10),
     + vy2(10,10)
c      character *80 avsop, cip
       integer i, j, k

c  initialize AVSI
c      call AVSI_initialize (netdir,localdir,display_name,avsoptions)
c      print *
c      print *,'*** enter display name of workstation '
c      read (*,'(a)') cip
c      print *
c      print *,'*** enter AVS options (optional) '
c      read (*,'(a)') avsop
c      call AVSI_initialize ( './networks', '.', cip, avsop)

c AVSI prompts for display name and AVS options:

       call AVSI_initialize ( './networks', '.', '*', '*')

c >> 1D >> make graph of y=x*x for x=1,2,...,10

       do 10 i=1,10
10     s1(i)=i*i

c prompt for visualization method 
       call AVSI_1D_scalar_real_uniform
     + ('*','1Ds',10,s1)

c fixed visualization method:
c      call AVSI_1D_scalar_real_uniform
c    + ('XY_Graph','1Ds',10,s1)

c >> 2D >> display data in s2(20,20) (generated by ZPRMDS) 
c on a uniform grid

       call ZPRMDS(s2)
       call AVSI_2D_scalar_real_uniform
     + ('*','2Ds',20,20,s2)

c >> 3D >> display data is s3(10,10,10) 
c          on a uniform grid

       do 200 i=1,10
       do 200 j=1,10
       do 200 k=1,10
          z =      -0.4*i*i + 4*i
          z = z * (-0.4*j*j + 4*j)
          z = z * (-0.4*k*k + 4*k)
          s3(i,j,k)=z
200    continue

       call AVSI_3D_scalar_real_uniform
     + ('*','3Ds',10,10,10,s3)

c >> 2D << display 2D vectors in vx2(10,10), vy2(10,10)
c          on an uniform grid

       do 300 i=1,10
       do 300 j=1,10
          vx2(i,j)= 1.
          vy2(i,j)=.5*j
300    continue
       call AVSI_2D_vector_real_uniform
     + ('*', '2Dv', 10, 10, vx2, vy2)

       end
