
c ****************************************************************
       program fexample3
c *******************************************************************
       integer dim1, dim2, dim3, dim4
       parameter (dim1=10, dim2=10, dim3=10, dim4=10)
       dimension s4(dim1, dim2, dim3, dim4),
     + s31(dim1, dim2, dim3), s32(dim1, dim2, dim3),
     + vx3(dim1, dim2, dim3), vy3(dim1, dim2, dim3),
     + vz3(dim1, dim2, dim3)

c  initialize AVSI
c      call AVSI_initialize (netdir, localdir, DISPLAY, avsoptions)
       call AVSI_initialize ('./networks','.','*','*')

c >>>>>> display 2 3D data sets on uniform grid:

       do 300 k=1, dim3
       do 300 j=1, dim2
       do 300 i=1, dim1
          s31(i,j,k) = i*j*k*(1-.1*i)*(1-.1*j)*(1-.1*k) 
          s32(i,j,k) = k
300    continue
       call AVSI_3D_ss_real_uniform('*',
     + 'ss',dim1, dim2, dim3, s31, s32)

      
C >>>>>>>> display 3D scalar and vector field on uniform grid:

       do 400 k=1, dim3
       do 400 j=1, dim2
       do 400 i=1, dim1
          s31(i,j,k) = i*j*k*(1-.1*i)*(1-.1*j)*(1-.1*k) 
          vx3(i,j,k) = i
          vy3(i,j,k) = k
          vz3(i,j,k) = 0
400    continue

       call AVSI_3D_sv_real_uniform
     + ('*','sv',dim1, dim2, dim3, s31,
     +  vx3, vy3, vz3) 

      
c  >>>>>> display 4D data in s4:

       do 200 l=1, dim4
       do 200 k=1, dim3
       do 200 j=1, dim2
       do 200 i=1, dim1
          z = i*j*k*(1-.1*i)*(1-.1*j)*(1-.1*k) 
          z = 0.1*l*z
          s4(i,j,k,l)=z
200    continue

       call AVSI_4D_scalar_real_uniform
     + ('*','4D',dim1, dim2, dim3, dim4, s4)

       end


