
        program flds_to_imgs 

c THis program generates a sequences of AVS fields that are
c converted to images using e.g. the self defined network 
c flds_to_imgs.net :
c
c        READ FIELD
c            |
c       IMAGE VIEWER
c            |
c       WRITE IMAGE

        character *20 name,net, file
        dimension fxy(20,20)
        integer dim1, dim2

c initialize AVSI :

        call AVSI_initialize('~/avsi/networks','.','*','*')
c options -nohw -cli added in AVSI_fields_to_images

c define remote host :
c       call AVSI_remote('rugrcx','kraak','~')

        ib=1000
        ie=1010
        name='FLDS_TO_IMGS'

c generate sequence of AVS fields :
c FLDS_TO_IMGS.1000.fld, FLDS_TO_IMGS.1001.fld, ...,
c FLDS_TO_IMGS.1010.fld 

        call ZPRMDS(fxy)
        dim1=20
        dim2=20
        x=0

        do 10 i= ib, ie
c generate file name :
          write(file,'(a,''.'',i4)') name(1:length(name)),i
c change data :
          x=x+1
          fxy(10,10)=x
c generate only field :
          call AVSI_2D_scalar_real_uniform('_',file,dim1, dim2,fxy)
10      continue

c converts field sequence to image sequence using network net 
c image sequence :
c FLDS_TO_IMGS.1000.x, FLDS_TO_IMGS.1001.x, ...,
c FLDS_TO_IMGS.1010.x

         net='flds_to_imgs.net'

c ir, iw are network dependent ......
         ir=0
c iw < 0 means that the networks resides in directory.
         iw=-2  

         call AVSI_fields_to_images('./macros',name,ib,ie,net,ir,iw)

         end

